/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class Artifact {
    private String groupId;
    private String artifactId;
    private ArtifactVersion version;
    private String buildNumber;
    private static final String[] BUILD_NUMBER_SEPARATORS = new String[]{"m", "b"};
    public static final String SNAPSHOT_QUALIFIER = "SNAPSHOT";

    public static String stripSnapshotQualifier(String qualifier) {
        if (qualifier != null) {
            if (qualifier.endsWith("-SNAPSHOT")) {
                return qualifier.replace("-SNAPSHOT", "");
            }
            return qualifier;
        }
        return null;
    }

    private static String getBuildNumber(String qualifier) {
        String normalizedQualifier = Artifact.stripSnapshotQualifier(qualifier);
        if (normalizedQualifier != null) {
            for (String c : BUILD_NUMBER_SEPARATORS) {
                if (!normalizedQualifier.contains(c)) continue;
                return normalizedQualifier.substring(normalizedQualifier.lastIndexOf(c) + 1);
            }
        }
        return null;
    }

    public Artifact() {
    }

    public Artifact(String gId, String aId, String v) {
        this.groupId = gId;
        this.artifactId = aId;
        this.version = new DefaultArtifactVersion(v);
        this.buildNumber = Artifact.getBuildNumber(this.version.getQualifier());
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public String getAbsoluteVersion() {
        return Artifact.stripSnapshotQualifier(this.version.toString());
    }

    public void setArtifactId(String aId) {
        this.artifactId = aId;
    }

    public void setGroupId(String gId) {
        this.groupId = gId;
    }

    public void setVersion(String v) {
        this.version = new DefaultArtifactVersion(v);
        this.buildNumber = Artifact.getBuildNumber(this.version.getQualifier());
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    private static ZipEntry getPomPropertiesFile(JarFile jar) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("pom.properties")) continue;
            return entry;
        }
        return null;
    }

    public static Artifact fromJar(JarFile jar) throws IOException {
        ZipEntry entry = Artifact.getPomPropertiesFile(jar);
        if (entry == null) {
            throw new RuntimeException("unable to find pom.properties files inside " + jar.getName());
        }
        InputStream is = jar.getInputStream(entry);
        Properties pomProps = new Properties();
        pomProps.load(is);
        return new Artifact(pomProps.getProperty("groupId"), pomProps.getProperty("artifactId"), pomProps.getProperty("version"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(this.groupId);
        sb.append(':');
        sb.append(this.artifactId);
        sb.append(':');
        sb.append(this.version);
        sb.append(" ]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (this.groupId == null && other.groupId != null) {
            return false;
        }
        if (this.groupId != null && !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null && other.artifactId != null) {
            return false;
        }
        if (this.artifactId != null && !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version == null && other.version != null) {
            return false;
        }
        return this.version == null || this.version.equals(other.version);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = 71 * hash + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = 71 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 71 * hash + (this.buildNumber != null ? this.buildNumber.hashCode() : 0);
        return hash;
    }
}

