/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CRLFWriter
extends FilterWriter {
    protected int lastb = -1;
    protected static char[] newline = new char[]{'\r', '\n'};

    public CRLFWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            this.out.write(newline);
        } else if (b == 10) {
            if (this.lastb != 13) {
                this.out.write(newline);
            }
        } else {
            this.out.write(b);
        }
        this.lastb = b;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int start = off;
        len += off;
        for (int i = start; i < len; ++i) {
            if (cbuf[i] == '\r') {
                this.out.write(cbuf, start, i - start);
                this.out.write(newline);
                start = i + 1;
            } else if (cbuf[i] == '\n') {
                if (this.lastb != 13) {
                    this.out.write(cbuf, start, i - start);
                    this.out.write(newline);
                }
                start = i + 1;
            }
            this.lastb = cbuf[i];
        }
        if (len - start > 0) {
            this.out.write(cbuf, start, len - start);
        }
    }
}

