/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.MBeanServerForwarder;
import com.sun.jdmk.OperationContext;
import com.sun.jdmk.ThreadContext;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public abstract class MBeanServerChecker
extends MBeanServerForwarder {
    protected MBeanServerChecker(MBeanServer mbs) {
        super(mbs);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        this.checkAny("instantiate", null);
        this.checkInstantiate("instantiate", className, null, params, signature);
        return super.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkAny("instantiate", null);
        this.checkInstantiate("instantiate", className, loaderName, params, signature);
        return super.instantiate(className, loaderName, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkAny("createMBean", name);
        this.checkCreate("createMBean", className, name, null, params, signature);
        return super.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkAny("createMBean", name);
        this.checkCreate("createMBean", className, name, loaderName, params, signature);
        return super.createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkAny("registerMBean", name);
        this.checkCreate("registerMBean", object == null ? null : object.getClass().getName(), name, null, null, null);
        return super.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkAny("unregisterMBean", name);
        this.checkDelete("unregisterMBean", name);
        super.unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        this.checkAny("getObjectInstance", name);
        this.checkRead("getObjectInstance", name);
        return super.getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        this.checkAny("queryMBeans", name);
        this.checkQuery("queryMBeans", name, query);
        return super.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        this.checkAny("queryNames", name);
        this.checkQuery("queryNames", name, query);
        return super.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        this.checkAny("isRegistered", name);
        this.checkRead("isRegistered", name);
        return super.isRegistered(name);
    }

    public Integer getMBeanCount() {
        this.checkAny("getMBeanCount", null);
        this.checkRead("getMBeanCount", null);
        return super.getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.checkAny("getAttribute", name);
        this.checkRead("getAttribute", name);
        return super.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkAny("getAttributes", name);
        this.checkRead("getAttributes", name);
        return super.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkAny("setAttribute", name);
        this.checkWrite("setAttribute", name);
        super.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.checkAny("setAttributes", name);
        this.checkWrite("setAttributes", name);
        return super.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkAny("invoke", name);
        this.checkInvoke("invoke", name, operationName, params, signature);
        return super.invoke(name, operationName, params, signature);
    }

    public String getDefaultDomain() {
        this.checkAny("getDefaultDomain", null);
        this.checkRead("getDefaultDomain", null);
        return super.getDefaultDomain();
    }

    public String[] getDomains() {
        this.checkAny("getDomains", null);
        this.checkRead("getDomains", null);
        return super.getDomains();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkAny("addNotificationListener", name);
        this.checkNotification("addNotificationListener", name);
        super.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.checkAny("addNotificationListener", name);
        this.checkNotification("addNotificationListener", name);
        super.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkAny("removeNotificationListener", name);
        this.checkNotification("removeNotificationListener", name);
        super.removeNotificationListener(name, listener, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.checkAny("getMBeanInfo", name);
        this.checkRead("getMBeanInfo", name);
        return super.getMBeanInfo(name);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        this.checkAny("isInstanceOf", name);
        this.checkRead("isInstanceOf", name);
        return super.isInstanceOf(name, className);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        this.checkAny("deserialize", name);
        this.checkDeserialize("deserialize", name);
        return super.deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        this.checkAny("deserialize", null);
        this.checkDeserialize("deserialize", className);
        return super.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.checkAny("deserialize", null);
        this.checkDeserialize("deserialize", className);
        return super.deserialize(className, loaderName, data);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        this.checkAny("getClassLoaderFor", mbeanName);
        this.checkRead("getClassLoaderFor", mbeanName);
        return super.getClassLoaderFor(mbeanName);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        this.checkAny("getClassLoader", loaderName);
        this.checkRead("getClassLoader", loaderName);
        return super.getClassLoader(loaderName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkAny("getClassLoaderRepository", null);
        this.checkRead("getClassLoaderRepository", null);
        return super.getClassLoaderRepository();
    }

    protected OperationContext getOperationContext() throws ClassCastException {
        Object context = ThreadContext.get("OperationContext");
        if (context instanceof OperationContext) {
            return (OperationContext)context;
        }
        return null;
    }

    protected void checkAny(String methodName, ObjectName objectName) {
    }

    protected void checkCreate(String methodName, String className, ObjectName objectName, ObjectName loaderName, Object[] params, String[] signature) {
    }

    protected void checkInstantiate(String methodName, String className, ObjectName loaderName, Object[] params, String[] signature) {
    }

    protected void checkDelete(String methodName, ObjectName objectName) {
    }

    protected void checkRead(String methodName, ObjectName objectName) {
    }

    protected void checkWrite(String methodName, ObjectName objectName) {
    }

    protected void checkQuery(String methodName, ObjectName name, QueryExp query) {
    }

    protected void checkInvoke(String methodName, ObjectName objectName, String operationName, Object[] params, String[] signature) {
    }

    protected void checkNotification(String methodName, ObjectName objectName) {
    }

    protected void checkDeserialize(String methodName, Object objectNameOrClass) {
    }
}

