/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.DiscoveryResponder;
import com.sun.jdmk.discovery.ResponsePDU;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.internal.Useful;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.remote.JMXServiceURL;

class ActualResponder
extends DiscoveryCommon {
    private DiscoveryResponder discResponder;
    public volatile boolean stopRequested;
    public Boolean interrupted;
    private final ClassLogger logger;
    private MBeanServer cmf;
    private String mbeanServerName;
    private String ImplementationName;
    private String ImplementationVendor;
    private String ImplementationVersion;
    private String SpecificationName;
    private String SpecificationVendor;
    private String SpecificationVersion;
    private int ttl;
    private boolean sendEvent;
    private boolean spy;

    public ActualResponder(String multicastGroup, int multicastPort, int ttl, MBeanServer cmf, String spy, DiscoveryResponder discResponder) throws IOException {
        block6: {
            super(multicastGroup, multicastPort);
            this.discResponder = null;
            this.stopRequested = false;
            this.interrupted = new Boolean(false);
            this.logger = new ClassLogger("com.sun.jdmk.discovery", "ActualResponder");
            this.cmf = null;
            this.mbeanServerName = null;
            this.ImplementationName = null;
            this.ImplementationVendor = null;
            this.ImplementationVersion = null;
            this.SpecificationName = null;
            this.SpecificationVendor = null;
            this.SpecificationVersion = null;
            this.ttl = 1;
            this.sendEvent = true;
            this.spy = false;
            this.discResponder = discResponder;
            if (this.logger.finerOn()) {
                this.logger.finer("constructor ", "group = " + multicastGroup + ", " + "port  = " + multicastPort);
            }
            this.localClassName = "com.sun.jdmk.discovery.ActualResponder";
            this.ttl = ttl;
            if (spy != null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("constructor ", "constructor spy = '" + spy + "'");
                }
                if (spy.compareTo("act_as_a_spy") == 0) {
                    this.spy = true;
                }
            }
            this.cmf = cmf;
            try {
                ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                this.mbeanServerName = (String)cmf.getAttribute(delegateName, "MBeanServerId");
                this.SpecificationName = (String)cmf.getAttribute(delegateName, "SpecificationName");
                this.SpecificationVendor = (String)cmf.getAttribute(delegateName, "SpecificationVendor");
                this.SpecificationVersion = (String)cmf.getAttribute(delegateName, "SpecificationVersion");
                this.ImplementationName = (String)cmf.getAttribute(delegateName, "ImplementationName");
                this.ImplementationVendor = (String)cmf.getAttribute(delegateName, "ImplementationVendor");
                this.ImplementationVersion = (String)cmf.getAttribute(delegateName, "ImplementationVersion");
            }
            catch (Exception e) {
                if (!this.logger.finestOn()) break block6;
                this.logger.finest("constructor ", e);
            }
        }
    }

    public void noEvent() {
        this.sendEvent = false;
    }

    public void setLocalHost(String local) {
        if (local != null) {
            try {
                this.localHost = InetAddress.getByName(local);
                this.localHostName = local;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block49: {
            block50: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                if (!this.spy && this.sendEvent) {
                                    this.sendEvent(0);
                                }
                                try {
                                    while (!this.stopRequested) {
                                        try {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", " -------------------- Start Waiting -------------------- ");
                                            }
                                            if (this.spy) {
                                                revMsg = this.receiveMsg(this);
                                                if (!this.logger.finerOn()) continue;
                                                this.logger.finer("run ", "(SPY) receive : " + revMsg.printState());
                                                continue;
                                            }
                                            pdu = (DiscoveryPDU)this.receiveMsg(this);
                                            this.processMsg(pdu);
                                        }
                                        catch (InterruptedIOException e) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Stop execution ");
                                            }
                                            this.stopRequested = true;
                                        }
                                        catch (IOException e) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Not a discovering msg - continue - ");
                                            }
                                            if (!this.spy || !this.logger.finestOn()) continue;
                                            this.logger.finest("run ", e);
                                        }
                                        catch (ClassCastException e) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Not a discovering msg - continue - ");
                                            }
                                            if (!this.spy || !this.logger.finestOn()) continue;
                                            this.logger.finest("run ", e);
                                        }
                                        catch (ClassNotFoundException e) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Not a discovering msg - continue - ");
                                            }
                                            if (!this.spy || !this.logger.finestOn()) continue;
                                            this.logger.finest("run ", e);
                                        }
                                    }
                                    var4_7 = null;
                                    var5_9 = this.interrupted;
                                }
                                catch (Throwable var3_11) {
                                    block48: {
                                        var4_8 = null;
                                        var5_10 = this.interrupted;
                                        synchronized (var5_10) {
                                            this.interrupted = new Boolean(true);
                                            Thread.currentThread();
                                            Thread.interrupted();
                                            ** if (!this.sendEvent) goto lbl83
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            this.sendEvent(1);
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (this.logger.finerOn()) {
                                            this.logger.finer("run ", "Call leave group");
                                        }
                                        try {
                                            this.disconnectFromGroup();
                                        }
                                        catch (IOException e) {
                                            if (this.logger.finestOn()) {
                                                this.logger.finest("start ", e);
                                            }
                                        }
                                        catch (Exception e) {
                                            if (!this.logger.finestOn()) break block48;
                                            this.logger.finest("start ", e);
                                        }
                                    }
                                    this.close();
                                    throw var3_11;
                                }
                                synchronized (var5_9) {
                                    this.interrupted = new Boolean(true);
                                    Thread.currentThread();
                                    Thread.interrupted();
                                    if (!this.sendEvent) break block50;
                                }
                                this.sendEvent(1);
                                ** try [egrp 3[TRYBLOCK] [12 : 375->384)] { 
lbl108:
                                // 1 sources

                                Thread.sleep(100L);
                                break block51;
lbl110:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [13 : 386->395)] { 
lbl114:
                            // 1 sources

                            Thread.sleep(100L);
                            break block52;
lbl116:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 5[TRYBLOCK] [14 : 397->406)] { 
lbl120:
                        // 1 sources

                        Thread.sleep(100L);
                        break block53;
lbl122:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [15 : 408->417)] { 
lbl126:
                    // 1 sources

                    Thread.sleep(100L);
                    break block54;
lbl128:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ** try [egrp 7[TRYBLOCK] [16 : 419->428)] { 
lbl132:
                // 1 sources

                Thread.sleep(100L);
                break block50;
lbl134:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.logger.finerOn()) {
                this.logger.finer("run ", "Call leave group");
            }
            ** try [egrp 8[TRYBLOCK] [17, 18 : 451->458)] { 
lbl140:
            // 1 sources

            this.disconnectFromGroup();
            break block49;
lbl142:
            // 1 sources

            catch (IOException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("start ", e);
                }
            }
lbl146:
            // 1 sources

            catch (Exception e) {
                if (!this.logger.finestOn()) break block49;
                this.logger.finest("start ", e);
            }
        }
        this.close();
    }

    private void sendEvent(int state) {
        block3: {
            if (this.logger.finerOn()) {
                this.logger.finer("sendEvent ", "Format Event PDU");
            }
            ResponsePDU pdu = new ResponsePDU(this.mbeanServerName, this.SpecificationName, this.SpecificationVendor, this.SpecificationVersion, this.ImplementationName, this.ImplementationVendor, this.ImplementationVersion, this.discResponder.getUserData());
            this.formatPdu(pdu, null, true);
            pdu.setAgentState(state);
            try {
                this.sendMsg(pdu, this.multicastGroup, this.multicastPort);
            }
            catch (IOException e) {
                if (!this.logger.finerOn()) break block3;
                this.logger.finer("sendEvent ", "Unable to send event !");
                this.logger.finer("sendEvent ", e);
            }
        }
        this.discResponder.changeState(state);
    }

    private void processMsg(DiscoveryPDU rcvPDU) throws IOException {
        int receiverPort;
        InetAddress receiverInetAddr;
        block20: {
            if (rcvPDU == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("processMsg ", "received null pdu");
                }
                return;
            }
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "received pdu '" + rcvPDU.printState() + "'");
            }
            if (rcvPDU.getHost() != null) {
                try {
                    if (!Useful.isLocalHost(rcvPDU.getHost())) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("processMsg", "Got a message looking for MBeanServers on other machine: " + rcvPDU.getHost() + ", No answer is required ");
                        }
                        return;
                    }
                    if (this.logger.finerOn()) {
                        this.logger.finer("processMsg", " Request is for this host ('" + this.localHostName + "')");
                    }
                    break block20;
                }
                catch (Exception ee) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("processMsg", "Cannot decide whether the requested host " + this.localHostName + "is same as the local host. " + ee);
                    }
                    break block20;
                }
            }
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg", " Request is for all host ");
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("processMsg ", "Format response PDU");
        }
        ResponsePDU pdu = new ResponsePDU(this.mbeanServerName, this.SpecificationName, this.SpecificationVendor, this.SpecificationVersion, this.ImplementationName, this.ImplementationVendor, this.ImplementationVersion, this.discResponder.getUserData());
        this.formatPdu(pdu, rcvPDU, false);
        if (this.logger.finerOn()) {
            this.logger.finer("processMsg ", "Check point to point response");
        }
        if (rcvPDU.getReturnAddr()) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "Point to point response using  Port " + rcvPDU.getReturnPort() + " on Host " + rcvPDU.getReturnHost());
            }
            receiverInetAddr = rcvPDU.getReturnHost();
            receiverPort = rcvPDU.getReturnPort();
        } else {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg", "Use multicast socket for response");
            }
            receiverInetAddr = this.multicastGroup;
            receiverPort = this.multicastPort;
        }
        try {
            this.setTimeToLive(pdu.getTimeToLive());
            this.sendMsg(pdu, receiverInetAddr, receiverPort);
        }
        catch (IOException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "Unable to send response !");
            }
            throw e;
        }
    }

    private void formatPdu(ResponsePDU pdu, DiscoveryPDU rcvPDU, boolean evt) {
        if (!evt) {
            pdu.setTimeStamp(rcvPDU.getTimeStamp());
        } else {
            pdu.setTimeStamp("");
        }
        pdu.setEvent(evt);
        if (!evt) {
            pdu.setTimeToLive(rcvPDU.getTimeToLive());
        } else {
            pdu.setTimeToLive(this.ttl);
        }
        if (!evt) {
            pdu.setEmittedGroup(rcvPDU.getEmittedGroup());
        } else {
            pdu.setEmittedGroup(this.multicastGroup);
        }
        if (!evt) {
            if (rcvPDU.getHost() != null) {
                pdu.setHost(rcvPDU.getHost());
            } else {
                pdu.setHost(this.localHostName);
            }
        } else {
            pdu.setHost(this.localHostName);
        }
        boolean setAdp = evt;
        Object query = null;
        if (rcvPDU != null) {
            setAdp |= rcvPDU.getObjectRequired();
        }
        if (setAdp) {
            block59: {
                ObjectName objectName;
                ObjectName o;
                Iterator<ObjectName> i;
                Set<ObjectName> result;
                String val;
                ObjectName name;
                block58: {
                    block57: {
                        GenericHttpConnectorAddress addr;
                        int port;
                        String host;
                        block56: {
                            block55: {
                                name = null;
                                try {
                                    name = new ObjectName("*:*");
                                }
                                catch (MalformedObjectNameException e) {
                                    if (this.logger.finestOn()) {
                                        this.logger.finest("formatPdu ", e);
                                    }
                                    return;
                                }
                                val = "com.sun.jdmk.comm.RmiConnectorServer";
                                try {
                                    result = this.cmf.queryNames(name, Query.match(Query.classattr(), Query.value(val)));
                                    if (this.logger.finerOn()) {
                                        i = result.iterator();
                                        while (i.hasNext()) {
                                            o = i.next();
                                            this.logger.finer("formatPdu ", "Add\t'" + o + "' in response msg");
                                        }
                                    }
                                    i = result.iterator();
                                    while (i.hasNext()) {
                                        objectName = i.next();
                                        try {
                                            host = (String)this.cmf.getAttribute(objectName, "Host");
                                            port = (Integer)this.cmf.getAttribute(objectName, "Port");
                                            String serviceName = (String)this.cmf.getAttribute(objectName, "ServiceName");
                                            RmiConnectorAddress addr2 = new RmiConnectorAddress(host, port, serviceName);
                                            pdu.addObjectList(objectName, addr2);
                                        }
                                        catch (Exception e) {
                                            if (!this.logger.finestOn()) continue;
                                            this.logger.finest("formatPdu ", e);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    if (!this.logger.finerOn()) break block55;
                                    this.logger.finer("formatPdu ", "Unable to get Mbean for " + val);
                                    this.logger.finer("formatPdu ", e);
                                }
                            }
                            val = "com.sun.jdmk.comm.HttpConnectorServer";
                            try {
                                result = this.cmf.queryNames(name, Query.match(Query.classattr(), Query.value(val)));
                                if (this.logger.finerOn()) {
                                    i = result.iterator();
                                    while (i.hasNext()) {
                                        o = i.next();
                                        this.logger.finer("formatPdu ", "Add\t'" + o + "' in response msg");
                                    }
                                }
                                i = result.iterator();
                                while (i.hasNext()) {
                                    objectName = i.next();
                                    try {
                                        host = (String)this.cmf.getAttribute(objectName, "Host");
                                        port = (Integer)this.cmf.getAttribute(objectName, "Port");
                                        addr = new HttpConnectorAddress(host, port);
                                        pdu.addObjectList(objectName, addr);
                                    }
                                    catch (Exception e) {
                                        if (!this.logger.finestOn()) continue;
                                        this.logger.finest("formatPdu ", e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (!this.logger.finerOn()) break block56;
                                this.logger.finer("formatPdu ", "Unable to get Mbean for " + val);
                                this.logger.finer("formatPdu ", e);
                            }
                        }
                        val = "com.sun.jdmk.comm.HttpsConnectorServer";
                        try {
                            result = this.cmf.queryNames(name, Query.match(Query.classattr(), Query.value(val)));
                            if (this.logger.finerOn()) {
                                i = result.iterator();
                                while (i.hasNext()) {
                                    o = i.next();
                                    this.logger.finer("formatPdu ", "Add\t'" + o + "' in response msg");
                                }
                            }
                            i = result.iterator();
                            while (i.hasNext()) {
                                objectName = i.next();
                                try {
                                    host = (String)this.cmf.getAttribute(objectName, "Host");
                                    port = (Integer)this.cmf.getAttribute(objectName, "Port");
                                    addr = new HttpsConnectorAddress(host, port);
                                    pdu.addObjectList(objectName, addr);
                                }
                                catch (Exception e) {
                                    if (!this.logger.finestOn()) continue;
                                    this.logger.finest("formatPdu ", e);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!this.logger.finerOn()) break block57;
                            this.logger.finer("formatPdu ", "Unable to get Mbean for " + val);
                            this.logger.finer("formatPdu ", e);
                        }
                    }
                    val = "com.sun.jdmk.comm.HtmlAdaptorServer";
                    try {
                        result = this.cmf.queryNames(name, Query.match(Query.classattr(), Query.value(val)));
                        if (this.logger.finerOn()) {
                            i = result.iterator();
                            while (i.hasNext()) {
                                o = i.next();
                                this.logger.finer("formatPdu ", "Add\t'" + o + "' in response msg");
                            }
                        }
                        i = result.iterator();
                        while (i.hasNext()) {
                            objectName = i.next();
                            try {
                                pdu.addObjectList(objectName, null);
                            }
                            catch (Exception e) {
                                if (!this.logger.finestOn()) continue;
                                this.logger.finest("formatPdu ", e);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!this.logger.finerOn()) break block58;
                        this.logger.finer("formatPdu ", "Unable to get Mbean for " + val);
                        this.logger.finer("formatPdu ", e);
                    }
                }
                val = "com.sun.jdmk.comm.SnmpAdaptorServer";
                try {
                    result = this.cmf.queryNames(name, Query.match(Query.classattr(), Query.value(val)));
                    if (this.logger.finerOn()) {
                        i = result.iterator();
                        while (i.hasNext()) {
                            o = i.next();
                            this.logger.finer("formatPdu ", "Add\t'" + o + "' in response msg");
                        }
                    }
                    i = result.iterator();
                    while (i.hasNext()) {
                        objectName = i.next();
                        try {
                            pdu.addObjectList(objectName, null);
                        }
                        catch (Exception e) {
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("formatPdu ", e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.logger.finerOn()) break block59;
                    this.logger.finer("formatPdu ", "Unable to get Mbean for " + val);
                    this.logger.finer("formatPdu ", e);
                }
            }
            String s = "javax.management.remote.JMXConnectorServerMBean";
            Set<ObjectName> ns = this.cmf.queryNames(null, null);
            ArrayList<JMXServiceURL> list = new ArrayList<JMXServiceURL>();
            Iterator<ObjectName> iter = ns.iterator();
            while (iter.hasNext()) {
                ObjectName on = iter.next();
                try {
                    if (!this.cmf.isInstanceOf(on, "javax.management.remote.JMXConnectorServerMBean")) continue;
                    JMXServiceURL url = (JMXServiceURL)this.cmf.getAttribute(on, "Address");
                    list.add(url);
                    if (!this.logger.finerOn()) continue;
                    this.logger.finer("formatPdu ", "Add\t'" + url + "' in response msg");
                }
                catch (InstanceNotFoundException infe) {
                }
                catch (MBeanException me) {
                    if (!this.logger.traceOn()) continue;
                    this.logger.trace("formatPdu", "Failed to get address from the jmx remote server: " + on, me);
                }
                catch (Exception e) {
                    if (!this.logger.traceOn()) continue;
                    this.logger.trace("formatPdu", "Failed to get address from the jmx remote server: " + on, e);
                }
            }
            pdu.serverAddresses = list.toArray(new JMXServiceURL[list.size()]);
        }
    }
}

