/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.ClientHandler;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpMibContextName;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubBulkRequestHandler;
import com.sun.management.comm.SnmpSubNextRequestHandler;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpAckPdu;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpNull;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduBulkType;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownAccContrModelException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpRequestForwarder;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class SnmpV3RequestHandler
extends ClientHandler
implements SnmpDefinitions {
    private transient DatagramSocket socket = null;
    private transient DatagramPacket packet = null;
    private transient Vector mibs = null;
    private transient Hashtable contexts = null;
    private transient Hashtable forwarders = null;
    private transient Hashtable subs = null;
    private transient SnmpMibTree root;
    private transient Vector currentMibs = null;
    private transient SnmpMibTree currentRoot = null;
    private transient Object ipacl = null;
    private transient SnmpPduFactory pduFactory = null;
    private transient SnmpUserDataFactory userDataFactory = null;
    private transient SnmpEngineImpl engine = null;
    private transient SnmpMsgProcessingSubSystem msgProcSubSys = null;
    private transient SnmpAccessControlSubSystem accessSubSys = null;
    private transient SnmpV3AdaptorServer adaptor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpStatusException noSuchNameException = new SnmpStatusException(2);

    public SnmpV3RequestHandler(SnmpV3AdaptorServer server, SnmpEngine eng, int id, DatagramSocket s, DatagramPacket p, Hashtable contexts, Hashtable forwarders, SnmpMibTree tree, Vector m, Object a, SnmpPduFactory factory, SnmpUserDataFactory dataFactory, MBeanServer f, ObjectName n) {
        super(server, id, f, n);
        this.adaptor = server;
        this.engine = (SnmpEngineImpl)eng;
        this.msgProcSubSys = this.engine.getMsgProcessingSubSystem();
        this.accessSubSys = this.engine.getAccessControlSubSystem();
        this.contexts = contexts;
        this.forwarders = forwarders;
        this.socket = s;
        this.packet = p;
        this.root = tree;
        this.mibs = (Vector)m.clone();
        this.ipacl = a;
        this.pduFactory = factory;
        this.userDataFactory = dataFactory;
        if (this.logger.finestOn()) {
            this.logger.finest("SnmpV3RequestHandler", "userDataFactory : " + this.userDataFactory);
        }
    }

    public void doRun() {
        block11: {
            if (this.logger.finerOn()) {
                this.logger.finer("doRun", "Packet received:\n" + SnmpMsg.dumpHexBuffer(this.packet.getData(), 0, this.packet.getLength()));
            }
            DatagramPacket respPacket = this.makeResponsePacket(this.packet);
            if (this.logger.finerOn() && respPacket != null) {
                this.logger.finer("doRun", "Packet to be sent:\n" + SnmpMsg.dumpHexBuffer(respPacket.getData(), 0, respPacket.getLength()));
            }
            if (respPacket != null) {
                try {
                    this.socket.send(respPacket);
                }
                catch (SocketException e) {
                    if (this.logger.finestOn()) {
                        if (e.getMessage().equals(InterruptSysCallMsg)) {
                            this.logger.finest("doRun", "interrupted");
                        } else {
                            this.logger.finest("doRun", "i/o exception");
                            this.logger.finest("doRun", e);
                        }
                    }
                }
                catch (InterruptedIOException e) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "interrupted");
                    }
                }
                catch (Exception e) {
                    if (!this.logger.finestOn()) break block11;
                    this.logger.finest("doRun", "failure when sending response");
                    this.logger.finest("doRun", e);
                }
            }
        }
    }

    private SnmpRequestForwarder handleContextEngineId(SnmpIncomingRequest pendingReq) {
        SnmpEngineId eng = SnmpEngineId.createEngineId(pendingReq.getContextEngineId());
        SnmpRequestForwarder forwarder = null;
        if (!this.engine.getEngineId().equals(eng)) {
            if (this.logger.finerOn()) {
                this.logger.finer("handleContextEngineId", " The received contextEngineId is UNKNOWN:[" + eng + "]. Forward to registered proxy.");
            }
            if (eng != null) {
                forwarder = (SnmpRequestForwarder)this.forwarders.get(eng.toString());
            }
            if (forwarder == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("handleContextEngineId", " The received contextEngineId is not handled:[" + eng + "]");
                }
                pendingReq.noResponse();
            }
        }
        return forwarder;
    }

    private void handleContextName(SnmpIncomingRequest pendingReq) {
        if (pendingReq.getContextName() != null) {
            String name = new String(pendingReq.getContextName());
            if (pendingReq.getContextName().length != 0 && !name.equals("default")) {
                SnmpMibContextName context;
                if (this.logger.finerOn()) {
                    this.logger.finer("handleContextName", " The received contextName is :[" + name + "]");
                }
                if ((context = (SnmpMibContextName)this.contexts.get(name)) != null) {
                    this.currentRoot = context.root;
                    this.currentMibs = context.mibs;
                } else {
                    if (this.logger.finerOn()) {
                        this.logger.finer("handleContextName", " The received contextName is UNKNOWN:[" + name + "]");
                    }
                    this.adaptor.incSnmpUnknownContexts(1);
                    pendingReq.noResponse();
                }
            } else {
                this.currentRoot = this.root;
                this.currentMibs = this.mibs;
            }
        } else {
            this.currentRoot = this.root;
            this.currentMibs = this.mibs;
        }
    }

    private DatagramPacket makeResponsePacket(DatagramPacket reqPacket) {
        DatagramPacket respPacket = null;
        SnmpIncomingRequest pendingReq = null;
        int version = 0;
        try {
            version = SnmpMsg.getProtocolVersion(reqPacket.getData());
            pendingReq = this.msgProcSubSys.getIncomingRequest(version, this.pduFactory);
            pendingReq.decodeMessage(reqPacket.getData(), reqPacket.getLength(), reqPacket.getAddress(), reqPacket.getPort());
        }
        catch (SnmpUnknownMsgProcModelException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "Unknown Msg Processing Model:" + version);
                this.logger.finest("makeResponsePacket", x);
            }
            this.adaptor.incSnmpInBadVersions(1);
            this.adaptor.incSnmpInvalidMsgs(1);
            return null;
        }
        catch (SnmpUnknownSecModelException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "Unknown Security Model:" + version);
                this.logger.finest("makeResponsePacket", x);
            }
            this.adaptor.incSnmpUnknownSecurityModels(1);
            return null;
        }
        catch (SnmpBadSecurityLevelException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "Bad Security Level:" + version);
                this.logger.finest("makeResponsePacket", x);
            }
            this.adaptor.incSnmpInvalidMsgs(1);
            return null;
        }
        catch (SnmpStatusException x) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePacket", "packet decoding failed");
            }
            this.adaptor.incSnmpInASNParseErrs(1);
            return null;
        }
        if (pendingReq.isReport()) {
            try {
                reqPacket.setLength(pendingReq.encodeMessage(reqPacket.getData()));
                respPacket = reqPacket;
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    this.newTooBigMessage(pendingReq);
                    reqPacket.setLength(pendingReq.encodeMessage(reqPacket.getData()));
                    respPacket = reqPacket;
                }
                catch (SnmpTooBigException xx) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
            return respPacket;
        }
        if (pendingReq.isResponse()) {
            SnmpRequestForwarder forwarder = this.handleContextEngineId(pendingReq);
            if (forwarder != null) {
                this.makeResponseMessage(pendingReq, forwarder);
            } else if (pendingReq.isResponse()) {
                this.handleContextName(pendingReq);
                if (pendingReq.isResponse()) {
                    this.subs = new Hashtable(this.currentMibs.size());
                    this.makeResponseMessage(pendingReq, null);
                }
            }
        }
        if (pendingReq.isResponse()) {
            try {
                reqPacket.setLength(pendingReq.encodeMessage(reqPacket.getData()));
                respPacket = reqPacket;
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    this.newTooBigMessage(pendingReq);
                    reqPacket.setLength(pendingReq.encodeMessage(reqPacket.getData()));
                    respPacket = reqPacket;
                }
                catch (SnmpTooBigException xx) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                    }
                    this.adaptor.incSnmpSilentDrops(1);
                }
            }
        }
        return respPacket;
    }

    private void makeResponseMessage(SnmpIncomingRequest pendingReq, SnmpRequestForwarder forwarder) {
        Object userData;
        SnmpPdu reqPdu;
        block29: {
            reqPdu = null;
            userData = null;
            try {
                reqPdu = pendingReq.decodeSnmpPdu();
                if (reqPdu != null && this.userDataFactory != null) {
                    userData = this.userDataFactory.allocateUserData(reqPdu);
                }
            }
            catch (SnmpStatusException x) {
                reqPdu = null;
                this.adaptor.incSnmpInASNParseErrs(1);
                if (x.getStatus() == 243) {
                    this.adaptor.incSnmpInBadVersions(1);
                }
                if (!this.logger.finestOn()) break block29;
                this.logger.finest("makeResponseMessage", "message decoding failed");
            }
        }
        SnmpPdu respPdu = null;
        if (reqPdu != null) {
            respPdu = this.makeResponsePdu(pendingReq, reqPdu, userData, forwarder);
            try {
                if (this.userDataFactory != null) {
                    this.userDataFactory.releaseUserData(userData, respPdu);
                }
            }
            catch (SnmpStatusException x) {
                respPdu = null;
            }
        }
        if (respPdu != null) {
            try {
                pendingReq.encodeSnmpPdu(respPdu, this.packet.getData().length);
            }
            catch (SnmpStatusException x) {
                pendingReq.noResponse();
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponseMessage", "failure when encoding the response message");
                    this.logger.finest("makeResponseMessage", x);
                }
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("makeResponseMessage", "response message is too big");
                }
                try {
                    if (this.packet.getData().length <= 32) {
                        throw x;
                    }
                    int pos = x.getVarBindCount();
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponseMessage", "fail on element" + pos);
                    }
                    int old = 0;
                    while (true) {
                        try {
                            respPdu = this.reduceResponsePdu(reqPdu, respPdu, pos);
                            pendingReq.encodeSnmpPdu(respPdu, this.packet.getData().length - 32);
                        }
                        catch (SnmpTooBigException xx) {
                            if (this.logger.finestOn()) {
                                this.logger.finest("makeResponseMessage", "response message is still too big");
                            }
                            old = pos;
                            pos = xx.getVarBindCount();
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("makeResponseMessage", "fail on element" + pos);
                            if (pos != old) continue;
                            throw xx;
                        }
                        break;
                    }
                }
                catch (SnmpStatusException xx) {
                    pendingReq.noResponse();
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponseMessage", "failure when encoding the response message");
                        this.logger.finest("makeResponseMessage", xx);
                    }
                }
                catch (SnmpTooBigException xx) {
                    try {
                        respPdu = this.newTooBigPdu(reqPdu);
                        pendingReq.encodeSnmpPdu(respPdu, this.packet.getData().length);
                    }
                    catch (SnmpTooBigException xxx) {
                        pendingReq.noResponse();
                        if (this.logger.finestOn()) {
                            this.logger.finest("makeResponseMessage", "'too big' is 'too big' !!!");
                        }
                        this.adaptor.incSnmpSilentDrops(1);
                    }
                    catch (Exception xxx) {
                        pendingReq.noResponse();
                    }
                }
                catch (Exception xx) {
                    pendingReq.noResponse();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SnmpPdu makeResponsePdu(SnmpIncomingRequest pendingReq, SnmpPdu reqPdu, Object userData, SnmpRequestForwarder forwarder) {
        SnmpPdu respPdu = null;
        if (forwarder != null) {
            return this.makeForwardResponsePdu(pendingReq, reqPdu, forwarder);
        }
        this.adaptor.updateRequestCounters(reqPdu.type);
        if (reqPdu.varBindList != null) {
            this.adaptor.updateVarCounters(reqPdu.type, reqPdu.varBindList.length);
        }
        if (!this.checkPduType(reqPdu)) return respPdu;
        if (this.currentMibs.size() < 1) {
            if (!this.logger.finerOn()) return this.makeNoMibErrorPdu(reqPdu, userData);
            this.logger.finer("makeResponsePdu", "Request " + reqPdu.requestId + " received but no MIB registered.");
            return this.makeNoMibErrorPdu(reqPdu, userData);
        }
        if (this.logger.finestOn()) {
            this.logger.finer("makeResponsePdu", "Testing access for : Principal : " + pendingReq.getPrincipal() + " \n" + "Snmp version : " + reqPdu.version + " \n" + "Security level : " + pendingReq.getSecurityLevel() + " \n" + "Pdu type : " + reqPdu.type + " \n" + "Security model : " + pendingReq.getSecurityModel() + " \n" + " Access context : " + pendingReq.getAccessContext() + " \n");
        }
        try {
            this.accessSubSys.checkPduAccess(reqPdu.version, pendingReq.getPrincipal(), pendingReq.getSecurityLevel(), reqPdu.type, pendingReq.getSecurityModel(), pendingReq.getAccessContext(), reqPdu);
        }
        catch (SnmpStatusException e) {
            int err = -1;
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePdu", "authorization failed : " + e.getStatus());
            }
            switch (e.getStatus()) {
                case 2: {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePdu", " update noSuchName counter");
                    }
                    this.adaptor.updateErrorCounters(2);
                }
                case 4: {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePdu", " update bad community uses");
                    }
                    this.adaptor.incSnmpInBadCommunityUses(1);
                    InetAddressAcl acl = this.adaptor.getInetAddressAcl();
                    String ctxtString = new String(pendingReq.getAccessContext());
                    if (!acl.checkCommunity(ctxtString)) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("makeResponsePdu", "update bad community names");
                        }
                        this.adaptor.incSnmpInBadCommunityNames(1);
                    }
                    if (!this.adaptor.getAuthRespEnabled()) {
                        respPdu = null;
                        pendingReq.noResponse();
                    } else {
                        err = SnmpSubRequestHandler.mapErrorStatus(16, reqPdu.version, reqPdu.type);
                        respPdu = this.newErrorResponsePdu(reqPdu, err, 0);
                    }
                    if (!this.adaptor.getAuthTrapEnabled()) return respPdu;
                    try {
                        this.adaptor.snmpV1Trap(4, 0, new SnmpVarBindList());
                        return respPdu;
                    }
                    catch (Exception x) {
                        if (!this.logger.finestOn()) return respPdu;
                        this.logger.finest("makeResponsePdu", "failure when sending authentication trap");
                        this.logger.finest("makeResponsePdu", x);
                    }
                    return respPdu;
                }
                case 20: {
                    if (this.logger.finestOn()) {
                        this.logger.finest("makeResponsePdu", "No such context context. Dropping the request");
                    }
                    pendingReq.noResponse();
                    return null;
                }
            }
            if (this.logger.finestOn()) {
                this.logger.finest("makeResponsePdu", "AuthorizationError.");
            }
            err = SnmpSubRequestHandler.mapErrorStatus(16, reqPdu.version, reqPdu.type);
            if (!this.logger.finerOn()) return this.newErrorResponsePdu(reqPdu, err, 0);
            this.logger.finer("makeResponsePdu", "Mapped status : " + err);
            return this.newErrorResponsePdu(reqPdu, err, 0);
        }
        catch (SnmpUnknownAccContrModelException x) {
            if (!this.logger.finerOn()) return this.newErrorResponsePdu(reqPdu, 5, 0);
            this.logger.finer("makeResponsePdu", "SnmpUnknownAccContrModelException");
            return this.newErrorResponsePdu(reqPdu, 5, 0);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("makeResponsePdu", "Access Granted to " + pendingReq.getPrincipal());
        }
        switch (reqPdu.type) {
            case 160: 
            case 161: 
            case 163: {
                return this.makeGetSetResponsePdu(pendingReq, reqPdu, userData);
            }
            case 165: {
                return this.makeGetBulkResponsePdu(pendingReq, (SnmpPduBulkType)((Object)reqPdu), userData);
            }
        }
        return respPdu;
    }

    private SnmpPdu makeForwardResponsePdu(SnmpIncomingRequest pendingReq, SnmpPdu req, SnmpRequestForwarder forwarder) {
        try {
            return forwarder.forward(req);
        }
        catch (SnmpStatusException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeForwardResponsePdu", "Failure when forwarding, return null.");
            }
            return null;
        }
    }

    SnmpPdu makeErrorVarbindPdu(SnmpPdu req, int statusTag) {
        SnmpVarBind[] vblist = req.varBindList;
        int length = vblist.length;
        switch (statusTag) {
            case 130: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].setSnmpValue(SnmpVarBind.endOfMibView);
                }
                break;
            }
            case 128: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].setSnmpValue(SnmpVarBind.noSuchObject);
                }
                break;
            }
            case 129: {
                for (int i = 0; i < length; ++i) {
                    vblist[i].setSnmpValue(SnmpVarBind.noSuchInstance);
                }
                break;
            }
            default: {
                return this.newErrorResponsePdu(req, 5, 1);
            }
        }
        return this.newValidResponsePdu(req, vblist);
    }

    SnmpPdu makeNoMibErrorPdu(SnmpPdu req, Object userData) {
        if (req.version == 0) {
            return this.newErrorResponsePdu(req, 2, 1);
        }
        if (req.version == 1 || req.version == 3) {
            switch (req.type) {
                case 163: 
                case 253: {
                    return this.newErrorResponsePdu(req, 6, 1);
                }
                case 160: {
                    return this.makeErrorVarbindPdu(req, 128);
                }
                case 161: 
                case 165: {
                    return this.makeErrorVarbindPdu(req, 130);
                }
            }
        }
        return this.newErrorResponsePdu(req, 5, 1);
    }

    private SnmpPdu makeGetSetResponsePdu(SnmpIncomingRequest pendingReq, SnmpPdu req, Object userData) {
        if (req.varBindList == null) {
            return this.newValidResponsePdu(req, null);
        }
        SnmpPdu result = null;
        result = this.splitRequest(pendingReq, req);
        if (result != null) {
            return result;
        }
        int nbSubRequest = this.subs.size();
        if (nbSubRequest == 1) {
            return this.turboProcessingGetSet(req, userData);
        }
        result = this.executeSubRequest(req, userData);
        if (result != null) {
            return result;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("makeGetSetResponsePdu", "Build the unified response for request " + req.requestId);
        }
        return this.mergeResponses(req);
    }

    private SnmpPdu executeSubRequest(SnmpPdu req, Object userData) {
        SnmpSubRequestHandler sub;
        Enumeration e;
        int i;
        int errorStatus = 0;
        int nbSubRequest = this.subs.size();
        if (req.type == 163) {
            i = 0;
            e = this.subs.elements();
            while (e.hasMoreElements()) {
                sub = (SnmpSubRequestHandler)e.nextElement();
                sub.setUserData(userData);
                sub.type = 253;
                sub.run();
                sub.type = 163;
                if (sub.getErrorStatus() != 0) {
                    return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
                }
                ++i;
            }
        }
        i = 0;
        e = this.subs.elements();
        while (e.hasMoreElements()) {
            sub = (SnmpSubRequestHandler)e.nextElement();
            sub.setUserData(userData);
            sub.run();
            if (sub.getErrorStatus() != 0) {
                if (this.logger.finestOn()) {
                    this.logger.finest("executeSubRequest", "an error occurs");
                }
                int realIndex = sub.getErrorIndex() + 1;
                return this.newErrorResponsePdu(req, errorStatus, realIndex);
            }
            ++i;
        }
        return null;
    }

    private SnmpPdu turboProcessingGetSet(SnmpPdu req, Object userData) {
        int errorStatus = 0;
        SnmpSubRequestHandler sub = (SnmpSubRequestHandler)this.subs.elements().nextElement();
        sub.setUserData(userData);
        if (req.type == 163) {
            sub.type = 253;
            sub.run();
            sub.type = 163;
            errorStatus = sub.getErrorStatus();
            if (errorStatus != 0) {
                return this.newErrorResponsePdu(req, errorStatus, sub.getErrorIndex() + 1);
            }
        }
        sub.run();
        errorStatus = sub.getErrorStatus();
        if (errorStatus != 0) {
            if (this.logger.finestOn()) {
                this.logger.finest("turboProcessingGetSet", "an error occurs");
            }
            int realIndex = sub.getErrorIndex() + 1;
            return this.newErrorResponsePdu(req, errorStatus, realIndex);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("turboProcessingGetSet", "build the unified response for request " + req.requestId);
        }
        return this.mergeResponses(req);
    }

    private SnmpPdu makeGetBulkResponsePdu(SnmpIncomingRequest pendingReq, SnmpPduBulkType req, Object userData) {
        int t;
        int R;
        int M;
        SnmpVarBind[] respVarBindList = null;
        SnmpVarBind[] list = ((SnmpPdu)((Object)req)).varBindList;
        if (list == null) {
            return this.newValidResponsePdu((SnmpPdu)((Object)req), null);
        }
        int L = list.length;
        int N = Math.max(Math.min(req.getNonRepeaters(), L), 0);
        SnmpPdu result = this.splitBulkRequest(pendingReq, req, N, M = Math.max(req.getMaxRepetitions(), 0), R = L - N);
        if (result != null) {
            return result;
        }
        result = this.executeSubRequest((SnmpPdu)((Object)req), userData);
        if (result != null) {
            return result;
        }
        respVarBindList = this.mergeBulkResponses(N + M * R);
        for (t = respVarBindList.length; t > N && respVarBindList[t - 1].getSnmpValue().equals(SnmpVarBind.endOfMibView); --t) {
        }
        int m2 = t == N ? N + R : N + ((t - 1 - N) / R + 2) * R;
        if (m2 < respVarBindList.length) {
            SnmpVarBind[] truncatedList = new SnmpVarBind[m2];
            for (int i = 0; i < m2; ++i) {
                truncatedList[i] = respVarBindList[i];
            }
            respVarBindList = truncatedList;
        }
        return this.newValidResponsePdu((SnmpPdu)((Object)req), respVarBindList);
    }

    private boolean checkPduType(SnmpPdu pdu) {
        boolean result = true;
        if (pdu.type == 165 && pdu.version == 0 && this.logger.finestOn()) {
            this.logger.finest("checkPduType", "Received a getbulk in V1, rejecting the request");
            return false;
        }
        switch (pdu.type) {
            case 160: 
            case 161: 
            case 163: 
            case 165: {
                result = true;
                break;
            }
            default: {
                if (this.logger.finestOn()) {
                    this.logger.finest("checkPduType", "cannot respond to this kind of PDU");
                }
                result = false;
            }
        }
        return result;
    }

    private SnmpPdu newValidResponsePdu(SnmpPdu reqPdu, SnmpVarBind[] varBindList) {
        SnmpPdu result = null;
        SnmpAckPdu ackpdu = (SnmpAckPdu)((Object)reqPdu);
        result = ackpdu.getResponsePdu();
        result.varBindList = varBindList;
        this.adaptor.updateErrorCounters(((SnmpPduRequestType)((Object)result)).getErrorStatus());
        return result;
    }

    private SnmpPdu newErrorResponsePdu(SnmpPdu req, int s, int i) {
        SnmpPduRequestType result = (SnmpPduRequestType)((Object)this.newValidResponsePdu(req, null));
        result.setErrorStatus(s);
        result.setErrorIndex(i);
        ((SnmpPdu)((Object)result)).varBindList = req.varBindList;
        this.adaptor.updateErrorCounters(result.getErrorStatus());
        return (SnmpPdu)((Object)result);
    }

    private void newTooBigMessage(SnmpIncomingRequest pendingReq) throws SnmpTooBigException {
        Object result = null;
        SnmpPdu reqPdu = null;
        try {
            reqPdu = pendingReq.decodeSnmpPdu();
            if (reqPdu != null) {
                SnmpPdu respPdu = this.newTooBigPdu(reqPdu);
                pendingReq.encodeSnmpPdu(respPdu, this.packet.getData().length);
            }
        }
        catch (SnmpStatusException x) {
            throw new InternalError();
        }
    }

    private SnmpPdu newTooBigPdu(SnmpPdu req) {
        SnmpPdu result = this.newErrorResponsePdu(req, 1, 0);
        result.varBindList = null;
        return result;
    }

    private SnmpPdu reduceResponsePdu(SnmpPdu req, SnmpPdu resp, int acceptedVbCount) throws SnmpTooBigException {
        if (req.type != 165) {
            if (this.logger.finestOn()) {
                this.logger.finest("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(acceptedVbCount);
        }
        int vbCount = resp.varBindList.length;
        vbCount = acceptedVbCount >= 3 ? Math.min(acceptedVbCount - 1, resp.varBindList.length) : (acceptedVbCount == 1 ? 1 : resp.varBindList.length / 2);
        if (vbCount < 1) {
            if (this.logger.finestOn()) {
                this.logger.finest("reduceResponsePdu", "cannot remove anything");
            }
            throw new SnmpTooBigException(acceptedVbCount);
        }
        SnmpVarBind[] newVbList = new SnmpVarBind[vbCount];
        for (int i = 0; i < vbCount; ++i) {
            newVbList[i] = resp.varBindList[i];
        }
        if (this.logger.finestOn()) {
            this.logger.finest("reduceResponsePdu", resp.varBindList.length - newVbList.length + " items have been removed");
        }
        resp.varBindList = newVbList;
        return resp;
    }

    private SnmpPdu handleAccessException(int status, int index, SnmpPdu req, SnmpVarBind var, SnmpAdaptorServer snmpServer) {
        SnmpPdu pdu = null;
        int err = 0;
        if (req.version != 3) {
            block12: {
                if (!snmpServer.getAuthRespEnabled()) {
                    // empty if block
                }
                if (snmpServer.getAuthTrapEnabled()) {
                    try {
                        snmpServer.snmpV1Trap(4, 0, new SnmpVarBindList());
                    }
                    catch (Exception x) {
                        if (!this.logger.finestOn()) break block12;
                        this.logger.finest("handleAccessException", "failure when sending authentication trap");
                        this.logger.finest("handleAccessException", x);
                    }
                }
            }
            if (req.version == 0) {
                err = SnmpSubRequestHandler.mapErrorStatus(status, req.version, req.type);
                pdu = this.newErrorResponsePdu(req, err, index);
            } else {
                err = SnmpSubRequestHandler.mapErrorStatus(status, req.version, req.type);
                if (req.type == 163) {
                    pdu = this.newErrorResponsePdu(req, err, index);
                } else {
                    var.setSnmpValue(new SnmpNull(err));
                }
            }
        } else {
            err = SnmpSubRequestHandler.mapErrorStatus(status, req.version, req.type);
            if (req.type == 163) {
                pdu = this.newErrorResponsePdu(req, err, index);
            } else {
                var.setSnmpValue(new SnmpNull(err));
            }
        }
        return pdu;
    }

    private Object checkOidAccess(SnmpIncomingRequest pendingReq, SnmpPdu req, SnmpVarBind varBind, int index) {
        SnmpPdu pdu = null;
        try {
            this.accessSubSys.checkAccess(req.version, pendingReq.getPrincipal(), pendingReq.getSecurityLevel(), req.type, pendingReq.getSecurityModel(), pendingReq.getAccessContext(), varBind.getOid());
        }
        catch (SnmpStatusException e) {
            switch (e.getStatus()) {
                default: 
            }
            if (this.logger.finerOn()) {
                this.logger.finer("checkOidAccess", "SnmpStatusException : " + e.getStatus());
            }
            if (req.version == 0) {
                pdu = this.newErrorResponsePdu(req, 2, index + 1);
                return pdu;
            }
            return SnmpVarBind.noSuchInstance;
        }
        catch (SnmpUnknownAccContrModelException x) {
            pdu = this.newErrorResponsePdu(req, 5, index + 1);
        }
        return pdu;
    }

    private SnmpPdu splitRequest(SnmpIncomingRequest pendingReq, SnmpPdu req) {
        Object pdu = null;
        int nbAgents = this.currentMibs.size();
        if (this.logger.finerOn()) {
            this.logger.finer("splitRequest", "Nb agents : " + nbAgents);
        }
        SnmpSubRequestHandler sub = null;
        int nbReqs = req.varBindList.length;
        SnmpVarBind[] vars = req.varBindList;
        SnmpMibAgent agent = null;
        if (req.type == 161) {
            if (this.logger.finerOn()) {
                this.logger.finer("splitRequest", "Doing getNext on muliple agents");
            }
            Enumeration e = this.currentMibs.elements();
            while (e.hasMoreElements()) {
                SnmpSubNextRequestHandler subnext = null;
                SnmpMibAgent ag = (SnmpMibAgent)e.nextElement();
                subnext = new SnmpSubNextRequestHandler((SnmpEngine)this.engine, pendingReq, ag, req, this.currentRoot);
                this.subs.put(ag, subnext);
                if (!this.logger.finerOn()) continue;
                this.logger.finer("splitRequest", "Doing getNext on agent [" + ag + "]");
            }
            return null;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("splitRequest", "Access Granted to " + pendingReq.getPrincipal() + nbReqs);
        }
        Object err = null;
        for (int i = 0; i < nbReqs; ++i) {
            err = this.checkOidAccess(pendingReq, req, vars[i], i);
            if (err != null) {
                if (this.logger.finestOn()) {
                    this.logger.finest("splitRequest", "Access NOT granted for OID:" + vars[i].getOid());
                }
                if (err instanceof SnmpPdu) {
                    return (SnmpPdu)err;
                }
                vars[i].setSnmpValue((SnmpValue)err);
                continue;
            }
            if (this.logger.finestOn()) {
                this.logger.finest("splitRequest", "Access granted for OID : " + vars[i].getOid());
            }
            agent = this.currentRoot.getAgentMib(vars[i].getOid());
            if (this.logger.finerOn()) {
                this.logger.finer("splitRequest", "Found mib [" + agent + "] for oid " + vars[i].getOid());
            }
            if ((sub = (SnmpSubRequestHandler)this.subs.get(agent)) == null) {
                sub = new SnmpSubRequestHandler(this.engine, pendingReq, agent, req);
                this.subs.put(agent, sub);
            }
            sub.updateRequest(vars[i], i);
        }
        return null;
    }

    private SnmpPdu splitBulkRequest(SnmpIncomingRequest pendingReq, SnmpPduBulkType req, int nonRepeaters, int maxRepetitions, int R) {
        int nbAgents = this.currentMibs.size();
        if (nbAgents == 1) {
            SnmpMibAgent agent = (SnmpMibAgent)this.currentMibs.firstElement();
            this.subs.put(agent, new SnmpSubBulkRequestHandler(this.engine, pendingReq, agent, (SnmpPdu)((Object)req), nonRepeaters, maxRepetitions, R, this.currentRoot));
            return null;
        }
        Enumeration e = this.currentMibs.elements();
        while (e.hasMoreElements()) {
            SnmpSubBulkRequestHandler subbulk = null;
            SnmpMibAgent ag = (SnmpMibAgent)e.nextElement();
            subbulk = new SnmpSubBulkRequestHandler(this.engine, pendingReq, ag, (SnmpPdu)((Object)req), nonRepeaters, maxRepetitions, R, this.currentRoot);
            this.subs.put(ag, subbulk);
        }
        return null;
    }

    private SnmpPdu mergeResponses(SnmpPdu req) {
        if (req.type == 161) {
            return this.mergeNextResponses(req);
        }
        SnmpVarBind[] result = req.varBindList;
        Enumeration e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = (SnmpSubRequestHandler)e.nextElement();
            sub.updateResult(result);
        }
        return this.newValidResponsePdu(req, result);
    }

    private SnmpPdu mergeNextResponses(SnmpPdu req) {
        int max = req.varBindList.length;
        SnmpVarBind[] result = new SnmpVarBind[max];
        Enumeration e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = (SnmpSubRequestHandler)e.nextElement();
            sub.updateResult(result);
        }
        if (req.version == 1 || req.version == 3) {
            return this.newValidResponsePdu(req, result);
        }
        for (int i = 0; i < max; ++i) {
            SnmpValue val = result[i].getSnmpValue();
            if (val != SnmpVarBind.endOfMibView) continue;
            return this.newErrorResponsePdu(req, 2, i + 1);
        }
        return this.newValidResponsePdu(req, result);
    }

    private SnmpVarBind[] mergeBulkResponses(int size) {
        SnmpVarBind[] result = new SnmpVarBind[size];
        for (int i = size - 1; i >= 0; --i) {
            result[i] = new SnmpVarBind();
            result[i].setSnmpValue(SnmpVarBind.endOfMibView);
        }
        Enumeration e = this.subs.elements();
        while (e.hasMoreElements()) {
            SnmpSubRequestHandler sub = (SnmpSubRequestHandler)e.nextElement();
            sub.updateResult(result);
        }
        return result;
    }

    protected String makeDebugTag() {
        return "SnmpV3RequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "]";
    }

    ClassLogger makeLogger(String dbgTag) {
        return new ClassLogger("com.sun.jdmk.snmp.adaptor", dbgTag);
    }

    Thread createThread(Runnable r) {
        return null;
    }
}

