/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpPersistRowFileConsumer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SnmpPersistRowFile {
    File file = null;
    SnmpPersistRowFileConsumer consumer = null;
    String property = null;
    String delimitor = null;
    boolean parsing = true;
    boolean throwException = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpPersistRowFile");
    String dbgTag = "SnmpPersistRowFile";

    public SnmpPersistRowFile(String file, String property, String delimitor, SnmpPersistRowFileConsumer consumer) {
        if (file == null) {
            throw new IllegalArgumentException("Passed file is null");
        }
        this.file = new File(file);
        this.consumer = consumer;
        this.property = property;
        this.delimitor = delimitor;
    }

    public void enableException(boolean b) {
        this.throwException = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws FileNotFoundException, IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(this.file);
            this.cutInRows(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public FileWriter createWriter() throws FileNotFoundException, IOException {
        return new FileWriter(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void write(FileWriter writer, String val) throws IOException {
        this.write(writer, this.property, val);
    }

    public void write(FileWriter writer, String prop, String val) throws IOException {
        writer.write(prop + "=" + val);
    }

    public void releaseWriter(FileWriter writer) throws IOException {
        writer.close();
    }

    private void cutInRows(FileReader r) {
        int lineNumber;
        String row;
        BufferedReader in;
        block18: {
            in = new BufferedReader(r);
            row = null;
            lineNumber = 1;
            boolean storage = false;
            try {
                row = in.readLine();
            }
            catch (IOException ex) {
                if (!logger.finestOn()) break block18;
                logger.finest("cutInRows", ex);
            }
        }
        int i = 0;
        int line = 0;
        boolean err = false;
        while (row != null) {
            block20: {
                ++line;
                if (row.length() != 0 && row.startsWith(this.property + "=")) {
                    String userEntry = row.substring(row.indexOf("=") + 1);
                    StringTokenizer token = new StringTokenizer(userEntry, this.delimitor, this.parsing);
                    i = 0;
                    err = false;
                    Object context = this.consumer.rowBegin(row, line);
                    try {
                        while (token.hasMoreTokens()) {
                            block19: {
                                err = false;
                                String param = null;
                                try {
                                    param = token.nextToken();
                                    param = param.trim();
                                }
                                catch (NoSuchElementException e) {
                                    err = true;
                                    param = null;
                                }
                                if (param != null && param.equals(this.delimitor)) {
                                    param = null;
                                }
                                if (logger.finestOn()) {
                                    logger.finest("cutInRows", "value : " + param + " context : " + i);
                                }
                                this.consumer.treatToken(row, line, param, i, context, err);
                                if (this.parsing && param != null) {
                                    try {
                                        token.nextToken();
                                    }
                                    catch (NoSuchElementException e) {
                                        if (!logger.finestOn()) break block19;
                                        logger.finest("cutInRows", "Last token");
                                    }
                                }
                            }
                            ++i;
                        }
                        this.consumer.rowEnd(context, row, line);
                    }
                    catch (Exception e) {
                        if (logger.finestOn()) {
                            logger.finest("cutInRows", e);
                        }
                        if (!this.throwException) break block20;
                        throw new IllegalArgumentException(e.toString() + " ROW : [" + row + "]" + ", line :" + line);
                    }
                }
            }
            try {
                row = in.readLine();
                ++lineNumber;
            }
            catch (IOException e) {
                if (logger.finestOn()) {
                    logger.finest("cutRows", "Enable to read line :" + line);
                }
                row = null;
            }
        }
    }
}

