/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;

class PrincipalImpl
implements Principal,
Serializable {
    private static final long serialVersionUID = -4629687515796445309L;
    private InetAddress[] add = null;

    public PrincipalImpl() throws UnknownHostException {
        this.add = new InetAddress[1];
        this.add[0] = InetAddress.getLocalHost();
    }

    public PrincipalImpl(String hostName) throws UnknownHostException {
        if (PrincipalImpl.isLoopBackAddress(hostName)) {
            this.add = new InetAddress[1];
            this.add[0] = InetAddress.getLocalHost();
        } else {
            this.add = InetAddress.getAllByName(hostName);
        }
    }

    public PrincipalImpl(InetAddress address) {
        this.add = new InetAddress[1];
        try {
            this.add[0] = PrincipalImpl.isLoopBackAddress(address) ? InetAddress.getLocalHost() : address;
        }
        catch (UnknownHostException e) {
            this.add[0] = address;
        }
    }

    private static boolean isLoopBackAddress(String hostName) throws UnknownHostException {
        boolean loopback = PrincipalImpl.isLoopBackAddress(InetAddress.getByName(hostName));
        if (!loopback && hostName.equals("localhost")) {
            loopback = true;
        }
        return loopback;
    }

    private static boolean isLoopBackAddress(InetAddress address) {
        Class addressClass = InetAddress.class;
        Method loopback = null;
        try {
            loopback = addressClass.getDeclaredMethod("isLoopbackAddress", null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (loopback != null) {
            try {
                return (Boolean)loopback.invoke((Object)address, (Object[])null);
            }
            catch (Exception e) {
                throw new Error(e.toString());
            }
        }
        return address.getHostAddress().equals("127.0.0.1");
    }

    public String getName() {
        return this.add[0].toString();
    }

    public boolean equals(Object a) {
        if (a instanceof PrincipalImpl) {
            for (int i = 0; i < this.add.length; ++i) {
                if (!this.add[i].equals(((PrincipalImpl)a).getAddress())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.add[0].hashCode();
    }

    public String toString() {
        return "PrincipalImpl :" + this.add[0].toString();
    }

    public InetAddress getAddress() {
        return this.add[0];
    }

    public InetAddress[] getAddresses() {
        return this.add;
    }
}

