/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpSessionProvider;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import java.io.Serializable;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpProxy
extends SnmpMibAgent
implements Serializable {
    private static final long serialVersionUID = 5147896704225603584L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpProxy");
    public static final long defaultTimeout = 10000L;
    private transient SnmpEngine engine = null;
    private SnmpPeer peer = null;
    private String dbgTag = "SnmpProxy";
    private String mibName = null;
    private String oid = null;
    private long timeout = 10000L;
    private SnmpSessionProvider provider = null;
    private transient long[] rootOid = null;
    private boolean initialized = false;
    private boolean skipError = false;
    private boolean forwardOnCheck = false;
    private boolean hide = true;

    public SnmpProxy(SnmpEngine engine, SnmpPeer peer, String rootOid) throws SnmpStatusException, IllegalArgumentException {
        this.initializeProxy(engine, peer, rootOid, "SnmpProxy");
    }

    public SnmpProxy(SnmpEngine engine, SnmpPeer peer, String rootOid, String name) throws SnmpStatusException, IllegalArgumentException {
        this.initializeProxy(engine, peer, rootOid, name);
    }

    public void skipError(boolean skip) {
        this.skipError = skip;
    }

    public boolean skipError() {
        return this.skipError;
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public long getTimeout() {
        return this.syncGetTimeout();
    }

    public void setTimeout(long t) {
        this.syncSetTimeout(t);
    }

    public void init() throws IllegalAccessException {
        if (this.initialized) {
            return;
        }
        if (logger.finestOn()) {
            logger.finer("init", "init");
        }
        try {
            SnmpSession session = new SnmpSession(this.engine, "Snmp session", null);
            this.provider = new SnmpSessionProvider(this.peer, session);
        }
        catch (SnmpStatusException e) {
            if (logger.finerOn()) {
                logger.finer("init", e.toString());
            }
            throw new IllegalAccessException(e.toString());
        }
        this.initialized = true;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.init();
        return name;
    }

    private void initializeProxy(SnmpEngine engine, SnmpPeer peer, String strOid, String name) throws SnmpStatusException, IllegalArgumentException {
        if (engine == null) {
            new IllegalArgumentException("Engine can't be null");
        }
        if (logger.finerOn()) {
            logger.finer("initializeProxy", "initializing snmp proxy with : \nengine : " + engine + "\n" + "peer : " + peer.toString() + "\n" + "root OID : " + strOid + "\n" + "mib name : " + name + "\n");
        }
        this.engine = engine;
        this.oid = strOid;
        this.mibName = name;
        this.peer = peer;
    }

    public String getMibName() {
        return this.mibName;
    }

    public synchronized void get(SnmpMibRequest inRequest) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("get", "Sending get request to SNMP sub-agent");
        }
        this.provider.hideInvalidResponseError(this.hide);
        SnmpSession session = this.defineSession(inRequest);
        this.get(session.getDefaultPeer(), session, inRequest);
    }

    public synchronized void set(SnmpMibRequest inRequest) throws SnmpStatusException {
        if (!this.isSetRequestForwardedOnCheck()) {
            if (logger.finerOn()) {
                logger.finer("set", "Sending set request to SNMP sub-agent.");
            }
            this.provider.hideInvalidResponseError(this.hide);
            SnmpSession session = this.provider.getDefaultSession();
            SnmpParams params = this.translateParameters(inRequest);
            params.setProtocolVersion(session.getDefaultPeer().getParams().getProtocolVersion());
            session.getDefaultPeer().setParams(params);
            this.set(session.getDefaultPeer(), session, inRequest);
        } else if (logger.finerOn()) {
            logger.finer("set", "Doing nothing, set already done on check.");
        }
    }

    public synchronized void forwardSetRequestOnCheck(boolean check) {
        this.forwardOnCheck = check;
    }

    public synchronized boolean isSetRequestForwardedOnCheck() {
        return this.forwardOnCheck;
    }

    public synchronized void hideInvalidResponseError(boolean hide) {
        this.hide = hide;
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.hide;
    }

    public synchronized void check(SnmpMibRequest inRequest) throws SnmpStatusException {
        this.provider.hideInvalidResponseError(this.hide);
        if (this.isSetRequestForwardedOnCheck()) {
            if (logger.finerOn()) {
                logger.finer("check", "Sending set request to SNMP sub-agent.");
            }
            SnmpSession session = this.provider.getDefaultSession();
            SnmpParams params = this.translateParameters(inRequest);
            params.setProtocolVersion(session.getDefaultPeer().getParams().getProtocolVersion());
            session.getDefaultPeer().setParams(params);
            this.set(session.getDefaultPeer(), session, inRequest);
        } else if (logger.finerOn()) {
            logger.finer("check", "Nothing to do, set forwarded on set");
        }
    }

    public synchronized void getNext(SnmpMibRequest inRequest) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("getNext", "Sending getNext request to SNMP sub-agent.");
        }
        this.provider.hideInvalidResponseError(this.hide);
        SnmpSession session = this.defineSession(inRequest);
        this.getNext(session.getDefaultPeer(), session, inRequest);
    }

    public synchronized void getBulk(SnmpMibRequest request, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        int vers = request.getVersion();
        if (vers == 0) {
            if (logger.finerOn()) {
                logger.finer("getBulk", "Receive a getBulk in SnmpV1 protocol for sub-agent.");
            }
            throw new SnmpStatusException(5, 0);
        }
        this.provider.hideInvalidResponseError(this.hide);
        if (logger.finerOn()) {
            logger.finer("getBulk", "Sending getBulk (using getNext) request to SNMP sub-agent.");
        }
        this.getBulkWithGetNext(request, nonRepeat, maxRepeat);
    }

    public long[] getRootOid() {
        if (logger.finerOn()) {
            logger.finer("getRootOid", "Root oid to return : " + this.oid);
        }
        this.rootOid = this.resolveOidString(this.oid);
        return this.rootOid;
    }

    public final SnmpPeer getPeer() {
        return this.peer;
    }

    protected boolean handleReport(SnmpRequest request) {
        return false;
    }

    protected SnmpParams translateParameters(SnmpMibRequest request) throws SnmpStatusException {
        SnmpPdu pdu = request.getPdu();
        if (pdu == null) {
            return new SnmpParameters("public", "private");
        }
        SnmpParameters params = new SnmpParameters("public", "private");
        if (logger.finestOn()) {
            logger.finest("translateParameters", "From version : " + pdu.version);
        }
        switch (pdu.version) {
            case 0: 
            case 1: {
                SnmpPduPacket pack = (SnmpPduPacket)pdu;
                if (pack.community == null) break;
                params.setRdCommunity(new String(pack.community));
                params.setWrCommunity(new String(pack.community));
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (!logger.finerOn()) break;
                logger.finer("translateParameters", "Unsupported snmp protocol version :" + pdu.version);
            }
        }
        return params;
    }

    protected synchronized void get(SnmpPeer peer, SnmpSession session, SnmpMibRequest inRequest) throws SnmpStatusException {
        boolean retry = true;
        SnmpRequest request = null;
        SnmpVarBindList varbindlist = new SnmpVarBindList("SnmpProxy varbind list", inRequest.getSubList());
        while (retry) {
            boolean completed;
            if (logger.finestOn()) {
                logger.finest("get", "get(SnmpPeer " + peer + ",\n" + "SnmpSession " + session + ",\n" + "SnmpMibRequest " + inRequest + ")");
            }
            request = session.snmpGetRequest(peer, null, varbindlist);
            if (logger.finestOn()) {
                logger.finest("get(session, request)", "\nRequest:\n" + request.toString());
            }
            if (!(completed = request.waitForCompletion(this.getTimeout()))) {
                if (logger.finestOn()) {
                    logger.finest("get(session, request)", "Request timed out.");
                }
                throw new SnmpStatusException(5, 0);
            }
            if (request.isReport()) {
                retry = this.handleReport(request);
                if (!retry) {
                    throw new SnmpStatusException(5);
                }
                if (!logger.finestOn()) continue;
                logger.finest("get", "Retrying");
                continue;
            }
            retry = false;
        }
        int errorStatus = request.getErrorStatus();
        int errorIndex = request.getErrorIndex() + 1;
        if (errorStatus != 0) {
            if (logger.finestOn()) {
                logger.finest("get(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString(errorStatus) + "\nError index :" + errorIndex);
            }
            throw new SnmpStatusException(errorStatus, errorIndex);
        }
        if (session.snmpOptions.isPduFixedOnError()) {
            this.moveFixResult(request, inRequest);
        } else {
            this.moveResult(request, inRequest);
        }
    }

    protected synchronized void getNext(SnmpPeer peer, SnmpSession session, SnmpMibRequest inRequest) throws SnmpStatusException {
        boolean retry = true;
        SnmpRequest request = null;
        SnmpVarBindList varbindlist = new SnmpVarBindList("SnmpProxy varbind list", inRequest.getSubList());
        while (retry) {
            boolean completed;
            if (logger.finestOn()) {
                logger.finest("get", "getnext(SnmpPeer " + peer + ",\n" + "SnmpSession " + session + ",\n" + "SnmpMibRequest " + inRequest + ")");
            }
            if (!(completed = (request = session.snmpGetNextRequest(peer, null, varbindlist)).waitForCompletion(this.getTimeout()))) {
                if (!this.skipError) {
                    if (logger.finestOn()) {
                        logger.finest("get(session, request)", "Request timed out.");
                    }
                    throw new SnmpStatusException(5, 0);
                }
                if (logger.finestOn()) {
                    logger.finest("getNext(session, request)", "Skipping error : timeout.");
                }
                return;
            }
            if (request.isReport()) {
                retry = this.handleReport(request);
                if (!retry) {
                    throw new SnmpStatusException(5);
                }
                if (!logger.finestOn()) continue;
                logger.finest("get", "Retrying");
                continue;
            }
            retry = false;
        }
        int errorStatus = request.getErrorStatus();
        int errorIndex = request.getErrorIndex() + 1;
        if (errorStatus != 0) {
            if (this.skipError) {
                if (logger.finestOn()) {
                    logger.finest("getNext(session, request)", "Skipping error : " + errorStatus);
                }
                Enumeration l = inRequest.getElements();
                while (l.hasMoreElements()) {
                    SnmpVarBind varbind = (SnmpVarBind)l.nextElement();
                    varbind.setSnmpValue(SnmpVarBind.endOfMibView);
                }
                return;
            }
            if (logger.finestOn()) {
                logger.finest("getNext(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString(errorStatus) + "\nError index :" + errorIndex);
            }
            throw new SnmpStatusException(errorStatus, errorIndex);
        }
        if (session.snmpOptions.isPduFixedOnError()) {
            this.moveFixGetNextResult(request, inRequest);
        } else {
            this.moveGetNextResult(request, inRequest);
        }
    }

    protected synchronized void set(SnmpPeer peer, SnmpSession session, SnmpMibRequest inRequest) throws SnmpStatusException {
        boolean retry = true;
        SnmpRequest request = null;
        SnmpVarBindList varbindlist = new SnmpVarBindList("SnmpProxy varbind list", inRequest.getSubList());
        while (retry) {
            boolean completed;
            if (logger.finestOn()) {
                logger.finest("get", "getnext(SnmpPeer " + peer + ",\n" + "SnmpSession " + session + ",\n" + "SnmpMibRequest " + inRequest + ")");
            }
            if (!(completed = (request = session.snmpSetRequest(peer, null, varbindlist)).waitForCompletion(this.getTimeout()))) {
                if (logger.finestOn()) {
                    logger.finest("set(session, request)", "Request timed out.");
                }
                throw new SnmpStatusException(5, 0);
            }
            if (request.isReport()) {
                retry = this.handleReport(request);
                if (!logger.finestOn()) continue;
                logger.finest("get", "Retrying");
                continue;
            }
            retry = false;
        }
        int errorStatus = request.getErrorStatus();
        int errorIndex = request.getErrorIndex() + 1;
        if (errorStatus != 0) {
            if (logger.finestOn()) {
                logger.finest("set(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString(errorStatus) + "\nError index :" + errorIndex);
            }
            throw new SnmpStatusException(errorStatus, errorIndex);
        }
        this.moveResult(request, inRequest);
    }

    private synchronized void syncSetTimeout(long t) {
        this.timeout = t;
    }

    private synchronized long syncGetTimeout() {
        return this.timeout;
    }

    private SnmpSession defineSession(SnmpMibRequest inRequest) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("defineSession", inRequest.toString());
        }
        int vers = inRequest.getVersion();
        SnmpSession session = this.provider.getSession(vers);
        SnmpParams params = null;
        params = this.translateParameters(inRequest);
        if (params == null) {
            throw new SnmpStatusException("Unable to define parameters to send to distant peer.");
        }
        params.setProtocolVersion(session.getDefaultPeer().getParams().getProtocolVersion());
        session.getDefaultPeer().setParams(params);
        return session;
    }

    private void handleException(SnmpVarBind varres, int index) throws SnmpStatusException {
        int status = varres.status;
        if (status != 2) {
            if (status == 2 || status == 3 || status == 5) {
                throw new SnmpStatusException(status, index + 1);
            }
            throw new SnmpStatusException(2, index + 1);
        }
    }

    private void handleCounter64(SnmpVarBind varres, int index) throws SnmpStatusException {
        if (varres.getSnmpValue() instanceof SnmpCounter64) {
            throw new SnmpStatusException(2, index);
        }
    }

    private void moveResult(SnmpRequest request, SnmpMibRequest inRequest) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("moveResult", "Result to move with no error");
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Enumeration l = inRequest.getElements();
        int index = 0;
        Enumeration e = result.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind varres = (SnmpVarBind)e.nextElement();
            SnmpVarBind varbind = (SnmpVarBind)l.nextElement();
            if (inRequest.getVersion() == 0) {
                this.handleException(varres, index);
                this.handleCounter64(varres, index);
            }
            varbind.setSnmpValue(varres.getSnmpValue());
            ++index;
            if (!logger.finestOn()) continue;
            logger.finest("moveResult", "\nVarResult : " + varres.toString() + "\nVarResult status: " + varres.status + "\nVarBind : " + varbind.toString() + "\nVarBind status: " + varbind.status);
        }
    }

    private void moveFixResult(SnmpRequest request, SnmpMibRequest inRequest) {
        if (logger.finestOn()) {
            logger.finest("moveFixResult", "Result to move with errors");
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Enumeration l = inRequest.getElements();
        Enumeration e = result.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind varres = (SnmpVarBind)e.nextElement();
            SnmpVarBind varbind = (SnmpVarBind)l.nextElement();
            if (varres.status == 4 || varres.status == 3) {
                varbind.setSnmpValue(SnmpVarBind.noSuchInstance);
            } else {
                varbind.setSnmpValue(varres.getSnmpValue());
            }
            if (!logger.finestOn()) continue;
            logger.finest("moveResult", "\nVarResult : " + varres.toString() + "\nVarResult status: " + varres.status + "\nVarBind : " + varbind.toString() + "\nVarBind status: " + varbind.status);
        }
    }

    private void moveGetNextResult(SnmpRequest request, SnmpMibRequest inRequest) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("moveGetNextResult", "Result to move with no error");
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Enumeration l = inRequest.getElements();
        int index = 0;
        Enumeration e = result.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind varres = (SnmpVarBind)e.nextElement();
            SnmpVarBind varbind = (SnmpVarBind)l.nextElement();
            if (inRequest.getVersion() == 0) {
                this.handleException(varres, index);
                this.handleCounter64(varres, index);
            }
            varbind.setSnmpValue(varres.getSnmpValue());
            varbind.setOid(varres.getOid(), false);
            ++index;
            if (!logger.finestOn()) continue;
            logger.finest("moveGetNextResult", "\nVarResult : " + varres.toString() + "\nVarResult status: " + varres.status + "\nVarBind : " + varbind.toString() + "\nVarBind status: " + varbind.status);
        }
    }

    private void moveFixGetNextResult(SnmpRequest request, SnmpMibRequest inRequest) {
        if (logger.finestOn()) {
            logger.finest("moveFixGetNextResult", "Result to move with errors");
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Enumeration l = inRequest.getElements();
        Enumeration e = result.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind varres = (SnmpVarBind)e.nextElement();
            SnmpVarBind varbind = (SnmpVarBind)l.nextElement();
            varbind.setOid(varres.getOid(), false);
            if (varres.status == 5) {
                varbind.setSnmpValue(SnmpVarBind.endOfMibView);
            } else {
                varbind.setSnmpValue(varres.getSnmpValue());
            }
            if (!logger.finestOn()) continue;
            logger.finest("moveResult", "\nVarResult : " + varres.toString() + "\nVarResult status: " + varres.status + "\nVarBind : " + varbind.toString() + "\nVarBind status: " + varbind.status);
        }
    }

    private long[] resolveOidString(String s) {
        SnmpOid oid = new SnmpOid(s);
        return oid.longValue();
    }
}

