/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpEncryptionPair;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmPrivException;
import com.sun.management.snmp.usm.SnmpUsmPrivPair;
import com.sun.management.snmp.usm.SnmpUsmSecurityCache;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;

class SnmpUsmPrivModule {
    SnmpUserSecurityModel model = null;
    SnmpUsmLcd lcd = null;
    SnmpUsmExceptionGenerator genExp = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmPrivModule");
    String dbgTag = "SnmpUsmPrivModule";

    SnmpUsmPrivModule(SnmpUserSecurityModel model, SnmpUsmLcd lcd, SnmpUsmExceptionGenerator genExp) {
        this.model = model;
        this.lcd = lcd;
        this.genExp = genExp;
    }

    SnmpDecryptedPdu decrypt(SnmpMsgProcessingSubSystem sys, int version, SnmpUsmSecurityParameters params, SnmpUsmSecurityCache usmcache, byte[] encryptedPdu, byte msgFlags) throws SnmpSecurityException, SnmpStatusException {
        byte[] data = null;
        try {
            data = this.decrypt(usmcache, params, encryptedPdu);
            return sys.decode(version, data);
        }
        catch (SnmpUsmPrivException e) {
            if (logger.finestOn()) {
                logger.finest("decrypt", e.toString());
            }
            this.genExp.genDecryptionException(msgFlags, params);
        }
        catch (SnmpUsmPrivAlgorithmException ea) {
            if (logger.finestOn()) {
                logger.finest("decrypt", ea.toString());
            }
            this.genExp.genSecurityLevelException(null, null, msgFlags, params);
        }
        catch (SnmpUsmUserNameException ex) {
            if (logger.finestOn()) {
                logger.finest("decrypt", ex.toString());
            }
            this.genExp.genUserNameException(null, null, msgFlags, params);
        }
        catch (SnmpUsmEngineIdException e) {
            this.genExp.genEngineIdException(null, null, msgFlags, params);
        }
        catch (SnmpUsmException e) {
            if (logger.finestOn()) {
                logger.finest("decrypt", e.toString());
            }
            this.genExp.genDecryptionException(msgFlags, params);
        }
        catch (SnmpUnknownMsgProcModelException x) {
            if (logger.finestOn()) {
                logger.finest("decrypt", x.toString());
            }
            this.genExp.genDecryptionException(msgFlags, params);
        }
        catch (Exception x) {
            if (logger.finestOn()) {
                logger.finest("decrypt", x.toString());
            }
            this.genExp.genDecryptionException(msgFlags, params);
        }
        return null;
    }

    private byte[] decrypt(SnmpUsmSecurityCache cache, SnmpUsmSecurityParameters params, byte[] encryptedData) throws SnmpUsmException {
        SnmpUsmPrivPair privPair = null;
        if (logger.finerOn()) {
            logger.finer("decrypt", " userName : " + params.getUserName());
        }
        privPair = this.lcd.getUserPrivPair(params.getAuthoritativeEngineId(), params.getUserName());
        if (cache != null) {
            cache.priv = privPair;
        }
        SnmpEncryptionPair pair = new SnmpEncryptionPair();
        pair.encryptedData = encryptedData;
        pair.parameters = params.getPrivParameters();
        byte[] data = privPair.algo.decrypt(privPair.key, pair);
        return data;
    }

    byte[] encrypt(SnmpUsmSecurityCache cache, SnmpUsmSecurityParameters params, byte[] data, int length) throws SnmpUsmException {
        SnmpUsmPrivPair privPair = null;
        if (logger.finerOn()) {
            logger.finer("encrypt", " userName : " + params.getUserName());
        }
        if (cache != null) {
            if (cache.priv != null) {
                privPair = cache.priv;
            } else {
                cache.priv = privPair = this.lcd.getUserPrivPair(params.getAuthoritativeEngineId(), params.getUserName());
            }
        } else {
            privPair = this.lcd.getUserPrivPair(params.getAuthoritativeEngineId(), params.getUserName());
        }
        SnmpEncryptionPair encPair = privPair.algo.encrypt(privPair.key, data, length);
        params.setPrivParameters(encPair.parameters);
        return encPair.encryptedData;
    }
}

