/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmMibTable;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.management.snmp.usm.usmmib.TableUsmUserTable;
import com.sun.management.snmp.usm.usmmib.UsmUserEntryImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TableUsmUserTableImpl
extends TableUsmUserTable
implements SnmpUsmMibTable {
    private static final long serialVersionUID = -1488698159987685211L;
    public static final int MAX_USM_USER_NAME_LENGTH = 32;
    SnmpUsmLcd lcd = null;
    SnmpEngine engine = null;
    Hashtable templates = new Hashtable();
    String dbgTag = "TableUsmUserTableImpl";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "TableUsmUserTableImpl");

    public Object createUsmUserEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Byte[] aUsmUserEngineID, String aUsmUserName) throws SnmpStatusException {
        byte[] engineId = new byte[aUsmUserEngineID.length];
        for (int i = 0; i < aUsmUserEngineID.length; ++i) {
            engineId[i] = aUsmUserEngineID[i];
        }
        if (logger.finestOn()) {
            logger.finest("createUsmUserEntryMBean", "Creating new user : " + aUsmUserName);
        }
        if (aUsmUserName == null || aUsmUserName.length() > 32) {
            if (logger.finestOn()) {
                logger.finest("createUsmUserEntryMBean", "Invalid userName : " + aUsmUserName);
            }
            throw new SnmpStatusException(10);
        }
        SnmpUsmSecureUser user = null;
        user = this.lcd.createNewUser(engineId, aUsmUserName);
        user.setStorageType(3);
        user.setAuthAlgorithm("1.3.6.1.6.3.10.1.1.1.0");
        user.setPrivAlgorithm("1.3.6.1.6.3.10.1.2.1.0");
        UsmUserEntryImpl entry = this.createUsmUserEntry(this.engine, this.theMib, this.lcd, user, meta);
        return entry;
    }

    UsmUserEntryImpl getCloneFromUser(String oid) throws SnmpStatusException {
        UsmUserEntryImpl original = null;
        if (logger.finestOn()) {
            logger.finest("getCloneFromUser", "cloneFromUser : " + oid);
        }
        if ((original = (UsmUserEntryImpl)this.templates.get(oid)) == null) {
            SnmpOid snmpOid = new SnmpOid(oid);
            original = (UsmUserEntryImpl)this.meta.getEntry(snmpOid);
        }
        if (logger.finestOn()) {
            logger.finest("getCloneFromUser", "cloneFromUser : " + original);
        }
        return original;
    }

    protected UsmUserEntryImpl createUsmUserEntry(SnmpEngine engine, SnmpMib mib, SnmpUsmLcd lcd, SnmpUsmSecureUser user, SnmpMibTable tableMeta) {
        return new UsmUserEntryImpl(engine, this.theMib, lcd, user, this);
    }

    public void userAdded(SnmpUsmSecureUser user) {
        block4: {
            if (logger.finestOn()) {
                logger.finest("userAdded", "engineId : " + user.getEngineId().toString() + "\nname : " + user.getName() + "\nsecurityName : " + user.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm(user.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm(user.getPrivPair().algo) + "\nstorageType : " + user.getStorageType());
            }
            UsmUserEntryImpl entry = new UsmUserEntryImpl(this.engine, this.theMib, this.lcd, user, this);
            if (this.server != null) {
                entry.addInMBeanServer(this.server);
            }
            try {
                this.addEntry(entry);
            }
            catch (SnmpStatusException s) {
                if (!logger.finestOn()) break block4;
                logger.finest("userAdded", s);
            }
        }
    }

    public void userUpdated(SnmpUsmSecureUser user) {
        block7: {
            SnmpOid oid;
            block6: {
                if (logger.finestOn()) {
                    logger.finest("userUpdated", "engineId : " + user.getEngineId().toString() + "\nname : " + user.getName() + "\nsecurityName : " + user.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm(user.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm(user.getPrivPair().algo) + "\nsorageType : " + user.getStorageType());
                }
                oid = null;
                byte[] engineid = user.getEngineId().getBytes();
                Byte[] ret = new Byte[engineid.length];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new Byte(engineid[i]);
                }
                try {
                    oid = this.buildOidFromIndexVal(ret, user.getName());
                }
                catch (SnmpStatusException s) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("userUpdated", s);
                }
            }
            try {
                UsmUserEntryImpl entry = (UsmUserEntryImpl)this.meta.getEntry(oid);
                entry.setUser(user);
            }
            catch (SnmpStatusException s) {
                if (!logger.finestOn()) break block7;
                logger.finest("userUpdated", s);
            }
        }
    }

    public void userRemoved(SnmpUsmSecureUser user) {
        UsmUserEntryImpl entry;
        block4: {
            if (logger.finestOn()) {
                logger.finest("userUpdated", "engineId : " + user.getEngineId().toString() + "\nname : " + user.getName() + "\nsecurityName : " + user.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm(user.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm(user.getPrivPair().algo) + "\nsorageType : " + user.getStorageType());
            }
            entry = new UsmUserEntryImpl(this.engine, this.theMib, this.lcd, user, this);
            try {
                this.removeEntry(entry);
            }
            catch (SnmpStatusException s) {
                if (!logger.finestOn()) break block4;
                logger.finest("userRemoved", s);
            }
        }
        if (this.server != null) {
            entry.removeFromMBeanServer(this.server);
        }
    }

    public TableUsmUserTableImpl(SnmpEngine engine, SnmpMib myMib, SnmpUsmLcd lcd) {
        super(myMib);
        this.init(lcd, engine);
    }

    public TableUsmUserTableImpl(SnmpEngine engine, SnmpMib myMib, MBeanServer server, SnmpUsmLcd lcd) {
        super(myMib, server);
        this.init(lcd, engine);
    }

    public void addEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("addEntryCb", "");
        }
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        super.removeEntryCb(pos, row, name, entry, meta);
        if (logger.finestOn()) {
            logger.finest("removeEntryCb", "");
        }
        this.lcd.removeUser(((UsmUserEntryImpl)entry).getUser().getEngineId(), ((UsmUserEntryImpl)entry).getUser().getName(), false);
    }

    private void init(SnmpUsmLcd lcd, SnmpEngine engine) {
        this.lcd = lcd;
        this.engine = engine;
        lcd.setMibTable(this);
        Enumeration users = lcd.getAllUsers();
        while (users.hasMoreElements()) {
            String templateUserOid;
            UsmUserEntryImpl entry;
            block14: {
                SnmpUsmSecureUser user;
                block12: {
                    user = (SnmpUsmSecureUser)users.nextElement();
                    entry = this.createUsmUserEntry(engine, this.theMib, lcd, user, this.meta);
                    try {
                        entry.setUsmUserStatus(new EnumUsmUserStatus("active"));
                    }
                    catch (Exception e) {
                        if (!logger.finestOn()) break block12;
                        logger.finest("init", e);
                    }
                }
                if (logger.finestOn()) {
                    logger.finest("init", "Adding :" + user.getEngineId().toString() + "/" + user.getName());
                }
                if (!user.isTemplate()) {
                    block13: {
                        try {
                            this.addEntry(entry);
                            if (logger.finestOn()) {
                                logger.finest("init", "Added :" + user.getEngineId().toString() + "/" + user.getName());
                            }
                        }
                        catch (SnmpStatusException s) {
                            if (!logger.finestOn()) break block13;
                            logger.finest("init", s);
                        }
                    }
                    if (this.server == null) continue;
                    entry.addInMBeanServer(this.server);
                    continue;
                }
                if (logger.finestOn()) {
                    logger.finest("init", "Template user detected :" + user.getEngineId().toString() + "/" + user.getName());
                }
                templateUserOid = null;
                try {
                    SnmpIndex index = this.buildSnmpIndex(entry);
                    templateUserOid = "1.3.6.1.6.3.15.1.2.2.1.3." + this.buildOidFromIndex(index).toString();
                    if (logger.finestOn()) {
                        logger.finest("init", "template user oid :" + templateUserOid);
                    }
                    entry.setUsmUserStatus(new EnumUsmUserStatus("active"));
                }
                catch (SnmpStatusException s) {
                    if (!logger.finestOn()) break block14;
                    logger.finest("init", s);
                }
            }
            this.templates.put(templateUserOid, entry);
        }
    }

    private String convertAuthAlgorithm(SnmpUsmAlgorithm algo) {
        if (algo == null) {
            return "usmNoAuthProtocol";
        }
        return algo.getAlgorithm();
    }

    private String convertPrivAlgorithm(SnmpUsmAlgorithm algo) {
        if (algo == null) {
            return "usmNoPrivProtocol";
        }
        return algo.getAlgorithm();
    }
}

