/*
 * Decompiled with CFR 0.152.
 */
package javax.validation;

import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.DefaultValidationProviderResolver;
import javax.validation.bootstrap.GenericBootstrap;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ValidationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation {
    public static ValidatorFactory buildDefaultValidatorFactory() {
        return Validation.byDefaultProvider().configure().buildValidatorFactory();
    }

    public static GenericBootstrap byDefaultProvider() {
        return new GenericBootstrapImpl();
    }

    public static <T extends Configuration<T>> ProviderSpecificBootstrap<T> byProvider(Class<T> configurationType) {
        return new ProviderSpecificBootstrapImpl<T>(configurationType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericBootstrapImpl
    implements GenericBootstrap,
    BootstrapState {
        private ValidationProviderResolver resolver;

        private GenericBootstrapImpl() {
        }

        @Override
        public GenericBootstrap providerResolver(ValidationProviderResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @Override
        public ValidationProviderResolver getValidationProviderResolver() {
            return this.resolver;
        }

        @Override
        public Configuration<?> configure() {
            ValidationProviderResolver resolver;
            ValidationProviderResolver validationProviderResolver = resolver = this.resolver == null ? new DefaultValidationProviderResolver() : this.resolver;
            if (resolver.getValidationProviders().size() == 0) {
                throw new ValidationException("Unable to find a default provider");
            }
            return resolver.getValidationProviders().get(0).createGenericConfiguration(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderSpecificBootstrapImpl<T extends Configuration<T>>
    implements ProviderSpecificBootstrap<T> {
        private Class<T> configurationType;
        private ValidationProviderResolver resolver;

        public ProviderSpecificBootstrapImpl(Class<T> configurationType) {
            this.configurationType = configurationType;
        }

        @Override
        public ProviderSpecificBootstrap<T> providerResolver(ValidationProviderResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @Override
        public T configure() {
            if (this.configurationType == null) {
                throw new ValidationException("builder is mandatory. Use Validation.byDefaultProvider() to use the generic provider discovery mechanism");
            }
            if (this.resolver == null) {
                this.resolver = new DefaultValidationProviderResolver();
            }
            for (ValidationProvider provider : this.resolver.getValidationProviders()) {
                if (!provider.isSuitable(this.configurationType)) continue;
                GenericBootstrapImpl state = new GenericBootstrapImpl();
                state.providerResolver(this.resolver);
                return provider.createSpecializedConfiguration(state, this.configurationType);
            }
            throw new ValidationException("Unable to find provider: " + this.configurationType);
        }
    }
}

