/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.Holder;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigurationException;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.Element;
import org.jvnet.tiger_types.Types;

public final class ConfigModel {
    public final Inhabitant<? extends ConfigInjector> injector;
    final Map<String, AttributeLeaf> attributes = new HashMap<String, AttributeLeaf>();
    final Map<String, Property> elements = new HashMap<String, Property>();
    final Map<Method, Method> duckMethods = new HashMap<Method, Method>();
    final List<String> contracts;
    final Set<String> symbolSpaces;
    final String tagName;
    public final Holder<ClassLoader> classLoaderHolder = new Holder<ClassLoader>(){

        public ClassLoader get() {
            return ((ConfigInjector)ConfigModel.this.injector.get()).getClass().getClassLoader();
        }
    };
    public final Holder<Class> classHolder = new Holder<Class>(){
        Class type = null;

        public synchronized Class get() {
            if (this.type == null) {
                try {
                    this.type = ((ClassLoader)ConfigModel.this.classLoaderHolder.get()).loadClass(ConfigModel.this.targetTypeName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return this.type;
        }
    };
    public final String targetTypeName;
    public final String keyedAs;
    public final String key;
    private static final String ELEMENT_NAME_PREFIX = ConfigInjector.class.getName() + ':';

    public String getTagName() {
        return this.tagName;
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return (Class)this.classHolder.get();
    }

    public Set<String> getLeafElementNames() {
        HashSet<String> results = new HashSet<String>();
        for (Map.Entry<String, Property> prop : this.elements.entrySet()) {
            if (!prop.getValue().isLeaf()) continue;
            results.add(prop.getKey());
        }
        return Collections.unmodifiableSet(results);
    }

    public Set<String> getElementNames() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public Property getElement(String elementName) {
        return this.elements.get(elementName);
    }

    public Property getElementFromXMlName(String xmlName) {
        Property cmp = this.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    void inject(Dom dom, Object target) {
        try {
            ((ConfigInjector)this.injector.get()).inject(dom, target);
        }
        catch (ConfigurationException e) {
            e.setLocation(dom.getLocation());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getDuckMethod(Method method) throws ClassNotFoundException, NoSuchMethodException {
        Map<Method, Method> map = this.duckMethods;
        synchronized (map) {
            Method duckMethod = this.duckMethods.get(method);
            if (duckMethod != null) {
                return duckMethod;
            }
            Class<?> clz = method.getDeclaringClass();
            Class<?> duck = clz.getClassLoader().loadClass(clz.getName() + "$Duck");
            Class<?>[] types = method.getParameterTypes();
            Class[] paramTypes = new Class[types.length + 1];
            System.arraycopy(types, 0, paramTypes, 1, types.length);
            paramTypes[0] = clz;
            duckMethod = duck.getMethod(method.getName(), paramTypes);
            this.duckMethods.put(method, duckMethod);
            return duckMethod;
        }
    }

    public Property toProperty(Method method) {
        String an;
        String en;
        String name = method.getName();
        Element e = method.getAnnotation(Element.class);
        if (e != null && (en = e.value()).length() > 0) {
            return this.elements.get(en);
        }
        Attribute a = method.getAnnotation(Attribute.class);
        if (a != null && (an = a.value()).length() > 0) {
            return this.attributes.get(an);
        }
        for (String p : Dom.PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        name = this.camelCaseToXML(name);
        return this.findIgnoreCase(name);
    }

    public String trimPrefix(String name) {
        for (String p : Dom.PROPERTY_PREFIX) {
            if (!name.startsWith(p)) continue;
            name = name.substring(p.length());
            break;
        }
        return name.toLowerCase().charAt(0) + name.substring(1);
    }

    public String camelCaseToXML(String camelCase) {
        StringBuilder buf = new StringBuilder(camelCase.length() + 5);
        for (String t : Dom.TOKENIZER.split(camelCase)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    public ConfigModel(DomDocument document, Inhabitant<? extends ConfigInjector> injector, MultiMap<String, String> description) {
        if (description == null) {
            throw new ComponentException("%s doesn't have any metadata", new Object[]{injector.type()});
        }
        document.models.put(injector, this);
        this.injector = injector;
        String targetTypeName = null;
        String indexTypeName = null;
        String key = null;
        for (Map.Entry e : description.entrySet()) {
            String value;
            String name = (String)e.getKey();
            String string = value = ((List)e.getValue()).size() > 0 ? (String)((List)e.getValue()).get(0) : null;
            if (name.startsWith("@")) {
                String attributeName = name.substring(1);
                String dv = ConfigModel.getMetadataFieldKeyedAs((List)e.getValue(), "default:");
                String dt = ConfigModel.getMetadataFieldKeyedAs((List)e.getValue(), "datatype:");
                AttributeLeaf leaf = null;
                leaf = dv == null ? (((List)e.getValue()).contains("reference") ? new ReferenceAttributeLeaf(attributeName, dt) : new AttributeLeaf(attributeName, dt)) : new AttributeLeafWithDefaultValue(attributeName, dt, dv);
                this.attributes.put(attributeName, leaf);
                continue;
            }
            if (name.startsWith("<")) {
                if (((List)e.getValue()).size() <= 0) continue;
                String elementName = name.substring(1, name.length() - 1);
                this.elements.put(elementName, this.parseValue(elementName, document, (List)e.getValue()));
                continue;
            }
            if (name.equals("target")) {
                targetTypeName = value;
                continue;
            }
            if (name.equals("keyed-as")) {
                indexTypeName = value;
                continue;
            }
            if (!name.equals("key")) continue;
            key = value;
        }
        if (targetTypeName == null) {
            throw new ComponentException("%s doesn't have the mandatory '%s' metadata", new Object[]{injector.type(), "target"});
        }
        if (key == null ^ indexTypeName == null) {
            throw new ComponentException("%s has inconsistent '%s=%s' and '%s=%s' metadata", new Object[]{"key", key, "target", indexTypeName});
        }
        this.targetTypeName = targetTypeName;
        this.keyedAs = indexTypeName;
        this.key = key;
        this.contracts = description.get((Object)"target-contracts");
        this.symbolSpaces = new HashSet<String>(description.get((Object)"symbolSpaces"));
        String tagName = null;
        for (String v : description.get((Object)"index")) {
            if (!v.startsWith(ELEMENT_NAME_PREFIX)) continue;
            tagName = v.substring(ELEMENT_NAME_PREFIX.length());
        }
        this.tagName = tagName;
    }

    public Property findIgnoreCase(String xmlName) {
        Property a = this.attributes.get(xmlName);
        if (a != null) {
            return a;
        }
        a = this.elements.get(xmlName);
        if (a != null) {
            return a;
        }
        a = this._findIgnoreCase(xmlName, this.attributes);
        if (a != null) {
            return a;
        }
        return this._findIgnoreCase(xmlName, this.elements);
    }

    private Property _findIgnoreCase(String name, Map<String, ? extends Property> map) {
        for (Map.Entry<String, ? extends Property> i : map.entrySet()) {
            if (!i.getKey().equalsIgnoreCase(name)) continue;
            return i.getValue();
        }
        return null;
    }

    private Property parseValue(String elementName, DomDocument document, List<String> values) {
        Property prop;
        String value;
        String string = value = values.size() > 0 ? values.get(0) : null;
        if (value == null) {
            return null;
        }
        boolean collection = false;
        if (value.startsWith("collection:")) {
            collection = true;
            value = value.substring(11);
        }
        boolean reference = values.contains("reference");
        if (value.equals("leaf")) {
            prop = collection ? new CollectionLeaf(elementName) : (reference ? new ReferenceElementLeaf(elementName) : new SingleLeaf(elementName));
        } else {
            ConfigModel model = document.buildModel(value);
            prop = collection ? new CollectionNode(model, elementName) : new SingleNode(model, elementName);
        }
        for (String s : values) {
            if (!s.startsWith("@")) continue;
            String annotationType = s.substring(1);
            prop.annotations.add(annotationType);
        }
        return prop;
    }

    private static String getMetadataFieldKeyedAs(List<String> strings, String name) {
        if (strings == null || strings.size() == 0 || name == null) {
            return null;
        }
        String dv = null;
        for (String s : strings) {
            if (!s.startsWith(name)) continue;
            dv = s.substring(name.length());
            break;
        }
        return dv;
    }

    static final class ReferenceElementLeaf
    extends Leaf {
        public ReferenceElementLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String id = dom.leafElement(this.xmlName);
            Class type = Types.erasure((Type)returnType);
            Object candidate = dom.getHabitat().getComponent(type, id);
            if (candidate != null) {
                return type.cast(candidate);
            }
            dom = dom.getSymbolSpaceRoot(id);
            return type.cast(dom.resolveReference(id, type.getName()).get());
        }

        @Override
        public void set(Dom dom, Object arg) {
            if (arg == null) {
                dom.removeLeafElement(this.xmlName, dom.leafElement(this.xmlName));
            } else {
                dom.setLeafElements(this.xmlName, ((Dom)arg).getKey());
            }
        }
    }

    static final class SingleLeaf
    extends Leaf {
        SingleLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String v = dom.leafElement(this.xmlName);
            return SingleLeaf.convertLeafValue(Types.erasure((Type)returnType), v);
        }

        @Override
        public void set(Dom dom, Object arg) {
            if (arg == null) {
                dom.removeLeafElement(this.xmlName, dom.leafElement(this.xmlName));
            } else {
                dom.setLeafElements(this.xmlName, arg.toString());
            }
        }
    }

    static final class ReferenceAttributeLeaf
    extends AttributeLeaf {
        ReferenceAttributeLeaf(String xmlName, String dataType) {
            super(xmlName, dataType);
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String id = dom.attribute(this.xmlName);
            if (id == null) {
                return null;
            }
            Class type = Types.erasure((Type)returnType);
            Object candidate = dom.getHabitat().getComponent(type, id);
            if (candidate != null) {
                return type.cast(candidate);
            }
            dom = dom.getSymbolSpaceRoot(id);
            return type.cast(dom.resolveReference(id, type.getName()).get());
        }

        @Override
        public void set(Dom dom, Object arg) {
            Dom target = (Dom)arg;
            dom.attribute(this.xmlName, arg == null ? null : target.getKey());
        }
    }

    static final class AttributeLeafWithDefaultValue
    extends AttributeLeaf {
        public final String dv;

        AttributeLeafWithDefaultValue(String xmlName, String dataType, String dv) {
            super(xmlName, dataType);
            this.dv = dv;
        }

        @Override
        public Object get(Dom dom, Type rt) {
            Object value = super.get(dom, rt);
            if (value == null) {
                return this.dv;
            }
            return value;
        }

        @Override
        public String getDefaultValue() {
            return this.dv;
        }
    }

    static class AttributeLeaf
    extends Leaf {
        public final String dataType;

        AttributeLeaf(String xmlName, String dataType) {
            super(xmlName);
            this.dataType = dataType;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        public boolean isReference() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            String v = dom.attribute(this.xmlName);
            return AttributeLeaf.convertLeafValue(Types.erasure((Type)returnType), v);
        }

        @Override
        public void set(Dom dom, Object arg) {
            dom.attribute(this.xmlName, arg == null ? null : arg.toString());
        }

        public String getDefaultValue() {
            return null;
        }
    }

    static final class CollectionLeaf
    extends Leaf {
        CollectionLeaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public Object get(final Dom dom, Type returnType) {
            final List<String> v = dom.leafElements(this.xmlName);
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("List needs to be parameterized");
            }
            final Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)returnType, (int)0));
            return new AbstractList<Object>(){

                @Override
                public Object get(int index) {
                    return Leaf.convertLeafValue(itemType, (String)v.get(index));
                }

                @Override
                public void add(int index, Object element) {
                    dom.addLeafElement(CollectionLeaf.this.xmlName, element.toString());
                    v.add(index, element.toString());
                }

                @Override
                public Object remove(int index) {
                    dom.removeLeafElement(CollectionLeaf.this.xmlName, (String)v.get(index));
                    return v.remove(index);
                }

                @Override
                public Object set(int index, Object element) {
                    dom.changeLeafElement(CollectionLeaf.this.xmlName, (String)v.get(index), element.toString());
                    return v.set(index, element.toString());
                }

                @Override
                public int size() {
                    return v.size();
                }
            };
        }

        @Override
        public void set(Dom dom, Object arg) {
            if (!(arg instanceof List)) {
                throw new UnsupportedOperationException();
            }
            String[] strings = new String[((List)arg).size()];
            dom.setLeafElements(this.xmlName, ((List)arg).toArray(strings));
        }
    }

    static abstract class Leaf
    extends Property {
        private static final Set<String> BOOLEAN_TRUE = new HashSet<String>(Arrays.asList("true", "yes", "on", "1"));

        public Leaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        protected static Object convertLeafValue(Class<?> returnType, String v) {
            if (v == null) {
                return null;
            }
            if (returnType == String.class) {
                return v;
            }
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return Integer.valueOf(v);
            }
            if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                return BOOLEAN_TRUE.contains(v);
            }
            throw new IllegalArgumentException("Don't know how to handle " + returnType);
        }
    }

    static final class SingleNode
    extends Node {
        SingleNode(ConfigModel model, String xmlName) {
            super(model, xmlName);
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public Object get(Dom dom, Type returnType) {
            Dom v = dom.nodeElement(this.xmlName);
            if (v == null) {
                return null;
            }
            if (returnType == Dom.class) {
                return v;
            }
            Class rt = Types.erasure((Type)returnType);
            if (ConfigBeanProxy.class.isAssignableFrom(rt)) {
                return v.createProxy();
            }
            throw new IllegalArgumentException("Invalid type " + returnType + " for " + this.xmlName);
        }

        @Override
        public void set(Dom dom, Object arg) {
            Dom child = this.toDom(arg);
            if (child == null) {
                dom.setNodeElements(this.xmlName, new Dom[0]);
            } else {
                dom.setNodeElements(this.xmlName, child);
            }
        }
    }

    static final class CollectionNode
    extends Node {
        CollectionNode(ConfigModel model, String xmlName) {
            super(model, xmlName);
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public Object get(final Dom dom, Type returnType) {
            List<Dom> v;
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("List needs to be parameterized");
            }
            Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)returnType, (int)0));
            List<Dom> list = v = "*".equals(this.xmlName) ? dom.domNodeByTypeElements(itemType) : dom.nodeElements(this.xmlName);
            if (itemType == Dom.class) {
                return v;
            }
            if (ConfigBeanProxy.class.isAssignableFrom(itemType)) {
                return new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return ((Dom)v.get(index)).createProxy();
                    }

                    @Override
                    public void add(int index, Object element) {
                        Dom child = Dom.unwrap((ConfigBeanProxy)element);
                        dom.insertAfter(index == 0 ? null : (Dom)v.get(index - 1), CollectionNode.this.xmlName, child);
                        v.add(index, child);
                    }

                    @Override
                    public Object remove(int index) {
                        Dom child = (Dom)v.get(index);
                        dom.removeChild(child);
                        v.remove(index);
                        return child.createProxy();
                    }

                    @Override
                    public Object set(int index, Object element) {
                        Dom child = Dom.unwrap((ConfigBeanProxy)element);
                        dom.replaceChild((Dom)v.get(index), CollectionNode.this.xmlName, child);
                        return v.set(index, child).createProxy();
                    }

                    @Override
                    public int size() {
                        return v.size();
                    }
                };
            }
            return new AbstractList(){

                @Override
                public Object get(int index) {
                    return ((Dom)v.get(index)).get();
                }

                @Override
                public int size() {
                    return v.size();
                }
            };
        }

        @Override
        public void set(Dom dom, Object _arg) {
            if (!(_arg instanceof List)) {
                throw new IllegalArgumentException("Expecting a list but found " + _arg);
            }
            List arg = (List)_arg;
            Dom[] values = new Dom[arg.size()];
            int i = 0;
            for (Object o : arg) {
                values[i++] = this.toDom(o);
            }
            dom.setNodeElements(this.xmlName, values);
        }
    }

    public static abstract class Node
    extends Property {
        final ConfigModel model;

        public Node(ConfigModel model, String xmlName) {
            super(xmlName);
            this.model = model;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public ConfigModel getModel() {
            return this.model;
        }

        protected final Dom toDom(Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Dom) {
                return (Dom)arg;
            }
            if (arg instanceof ConfigBeanProxy) {
                return Dom.unwrap((ConfigBeanProxy)arg);
            }
            throw new IllegalArgumentException("Unexpected type " + arg.getClass() + " for " + this.xmlName);
        }
    }

    public static abstract class Property {
        public final List<String> annotations = new ArrayList<String>();
        public final String xmlName;

        protected Property(String xmlName) {
            this.xmlName = xmlName;
        }

        public final String xmlName() {
            return this.xmlName;
        }

        public abstract boolean isLeaf();

        public abstract boolean isCollection();

        public abstract Object get(Dom var1, Type var2);

        public abstract void set(Dom var1, Object var2);

        public List<String> getAnnotations() {
            return this.annotations;
        }
    }
}

