/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.applicationimpl;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConverterPropertyEditorBase;
import com.sun.faces.application.ConverterPropertyEditorFactory;
import com.sun.faces.application.ViewMemberInstanceFactoryMetadataMap;
import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.DateTimeConverter;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstanceFactory {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String CONTEXT = "context";
    private static final String COMPONENT_EXPRESSION = "componentExpression";
    private static final String COMPONENT_TYPE = "componentType";
    private static final String COMPONENT_CLASS = "componentClass";
    private static final Map<String, Class<?>[]> STANDARD_CONV_ID_TO_TYPE_MAP = new HashMap<String, Class<?>[]>(8, 1.0f);
    private static final Map<Class<?>, String> STANDARD_TYPE_TO_CONV_ID_MAP = new HashMap(16, 1.0f);
    private final String[] STANDARD_BY_TYPE_CONVERTER_CLASSES = new String[]{"java.math.BigDecimal", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Enum"};
    private Map<Class<?>, Object> converterTypeMap;
    private boolean registerPropertyEditors;
    private boolean passDefaultTimeZone;
    private TimeZone systemTimeZone;
    private ViewMemberInstanceFactoryMetadataMap<String, Object> componentMap;
    private ViewMemberInstanceFactoryMetadataMap<String, Object> behaviorMap;
    private ViewMemberInstanceFactoryMetadataMap<String, Object> converterIdMap;
    private ViewMemberInstanceFactoryMetadataMap<String, Object> validatorMap;
    private Set<String> defaultValidatorIds;
    private volatile Map<String, String> defaultValidatorInfo;
    private final ApplicationAssociate associate;
    private BeanManager beanManager;

    public InstanceFactory(ApplicationAssociate applicationAssociate) {
        this.associate = applicationAssociate;
        this.componentMap = new ViewMemberInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
        this.converterIdMap = new ViewMemberInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
        this.converterTypeMap = new ConcurrentHashMap();
        this.validatorMap = new ViewMemberInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
        this.defaultValidatorIds = new LinkedHashSet<String>();
        this.behaviorMap = new ViewMemberInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
        WebConfiguration webConfig = WebConfiguration.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        this.registerPropertyEditors = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.RegisterConverterPropertyEditors);
        this.passDefaultTimeZone = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DateTimeConverterUsesSystemTimezone);
        if (this.passDefaultTimeZone) {
            this.systemTimeZone = TimeZone.getDefault();
        }
    }

    public void addComponent(String componentType, String componentClass) {
        Util.notNull(COMPONENT_TYPE, componentType);
        Util.notNull(COMPONENT_CLASS, componentClass);
        if (LOGGER.isLoggable(Level.FINE) && this.componentMap.containsKey(componentType)) {
            LOGGER.log(Level.FINE, "componentType {0} has already been registered.  Replacing existing component class type {1} with {2}.", new Object[]{componentType, this.componentMap.get(componentType), componentClass});
        }
        this.componentMap.put(componentType, componentClass);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("added component of type ''{0}'' and class ''{1}''", componentType, componentClass));
        }
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType) throws FacesException {
        Util.notNull(COMPONENT_EXPRESSION, componentExpression);
        Util.notNull(CONTEXT, context);
        Util.notNull(COMPONENT_TYPE, componentType);
        return this.createComponentApplyAnnotations(context, componentExpression, componentType, null, true);
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        Util.notNull(COMPONENT_TYPE, componentType);
        return this.createComponentApplyAnnotations(FacesContext.getCurrentInstance(), componentType, null, true);
    }

    public UIComponent createComponent(FacesContext context, Resource componentResource, ExpressionFactory expressionFactory) throws FacesException {
        Resource scriptComponentResource;
        String componentType;
        BeanDescriptor componentBeanDescriptor;
        ValueExpression valueExpression;
        Util.notNull(CONTEXT, context);
        Util.notNull("componentResource", componentResource);
        UIComponent result = null;
        Application app = context.getApplication();
        ViewDeclarationLanguage vdl = app.getViewHandler().getViewDeclarationLanguage(context, context.getViewRoot().getViewId());
        BeanInfo componentMetadata = vdl.getComponentMetadata(context, componentResource);
        if (componentMetadata != null && (valueExpression = (ValueExpression)(componentBeanDescriptor = componentMetadata.getBeanDescriptor()).getValue("jakarta.faces.component.COMPOSITE_COMPONENT_TYPE")) != null && !Util.isEmpty(componentType = (String)valueExpression.getValue(context.getELContext()))) {
            result = app.createComponent(componentType);
        }
        if (result == null && (scriptComponentResource = vdl.getScriptComponentResource(context, componentResource)) != null) {
            result = this.createComponentFromScriptResource(context, scriptComponentResource, componentResource);
        }
        if (result == null) {
            String packageName = componentResource.getLibraryName();
            Object className = componentResource.getResourceName();
            className = packageName + "." + ((String)className).substring(0, ((String)className).lastIndexOf(46));
            try {
                Class clazz = (Class)this.componentMap.get(className);
                if (clazz == null) {
                    clazz = Util.loadClass((String)className, this);
                }
                if (clazz != ComponentResourceClassNotFound.class) {
                    if (!this.associate.isDevModeEnabled()) {
                        this.componentMap.put((String)className, clazz);
                    }
                    result = (UIComponent)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
                if (!this.associate.isDevModeEnabled()) {
                    this.componentMap.put((String)className, ComponentResourceClassNotFound.class);
                }
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException ie) {
                throw new FacesException(ie);
            }
        }
        if (result == null) {
            result = app.createComponent("jakarta.faces.NamingContainer");
        }
        result.setRendererType("jakarta.faces.Composite");
        Map<String, Object> attrs = result.getAttributes();
        attrs.put("jakarta.faces.application.Resource.ComponentResource", componentResource);
        attrs.put("jakarta.faces.component.BEANINFO_KEY", componentMetadata);
        this.associate.getAnnotationManager().applyComponentAnnotations(context, result);
        this.pushDeclaredDefaultValuesToAttributesMap(context, componentMetadata, attrs, result, expressionFactory);
        return result;
    }

    public UIComponent createComponent(FacesContext context, String componentType, String rendererType) {
        Util.notNull(CONTEXT, context);
        Util.notNull(COMPONENT_TYPE, componentType);
        return this.createComponentApplyAnnotations(context, componentType, rendererType, true);
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType, String rendererType) {
        Util.notNull(COMPONENT_EXPRESSION, componentExpression);
        Util.notNull(CONTEXT, context);
        Util.notNull(COMPONENT_TYPE, componentType);
        return this.createComponentApplyAnnotations(context, componentExpression, componentType, rendererType, true);
    }

    public Iterator<String> getComponentTypes() {
        return this.componentMap.keySet().iterator();
    }

    public void addBehavior(String behaviorId, String behaviorClass) {
        Util.notNull("behaviorId", behaviorId);
        Util.notNull("behaviorClass", behaviorClass);
        if (LOGGER.isLoggable(Level.FINE) && this.behaviorMap.containsKey(behaviorId)) {
            LOGGER.log(Level.FINE, "behaviorId {0} has already been registered.  Replacing existing behavior class type {1} with {2}.", new Object[]{behaviorId, this.behaviorMap.get(behaviorId), behaviorClass});
        }
        this.behaviorMap.put(behaviorId, behaviorClass);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("added behavior of type ''{0}'' class ''{1}''", behaviorId, behaviorClass));
        }
    }

    public Behavior createBehavior(String behaviorId) throws FacesException {
        Util.notNull("behaviorId", behaviorId);
        Behavior behavior = this.createCDIBehavior(behaviorId);
        if (behavior != null) {
            return behavior;
        }
        behavior = (Behavior)this.newThing(behaviorId, this.behaviorMap);
        Util.notNullNamedObject(behavior, behaviorId, "faces.cannot_instantiate_behavior_error");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("created behavior of type ''{0}''", behaviorId));
        }
        this.associate.getAnnotationManager().applyBehaviorAnnotations(FacesContext.getCurrentInstance(), behavior);
        return behavior;
    }

    public Iterator<String> getBehaviorIds() {
        return this.behaviorMap.keySet().iterator();
    }

    public void addConverter(String converterId, String converterClass) {
        Util.notNull("converterId", converterId);
        Util.notNull("converterClass", converterClass);
        if (LOGGER.isLoggable(Level.FINE) && this.converterIdMap.containsKey(converterId)) {
            LOGGER.log(Level.FINE, "converterId {0} has already been registered.  Replacing existing converter class type {1} with {2}.", new Object[]{converterId, this.converterIdMap.get(converterId), converterClass});
        }
        this.converterIdMap.put(converterId, converterClass);
        Class<?>[] types = STANDARD_CONV_ID_TO_TYPE_MAP.get(converterId);
        if (types != null) {
            for (Class<?> clazz : types) {
                this.converterTypeMap.put(clazz, converterClass);
                this.addPropertyEditorIfNecessary(clazz);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("added converter of type ''{0}'' and class ''{1}''", converterId, converterClass));
        }
    }

    public void addConverter(Class<?> targetClass, String converterClass) {
        Util.notNull("targetClass", targetClass);
        Util.notNull("converterClass", converterClass);
        String converterId = STANDARD_TYPE_TO_CONV_ID_MAP.get(targetClass);
        if (converterId != null) {
            this.addConverter(converterId, converterClass);
        } else {
            if (LOGGER.isLoggable(Level.FINE) && this.converterTypeMap.containsKey(targetClass)) {
                LOGGER.log(Level.FINE, "converter target class {0} has already been registered.  Replacing existing converter class type {1} with {2}.", new Object[]{targetClass.getName(), this.converterTypeMap.get(targetClass), converterClass});
            }
            this.converterTypeMap.put(targetClass, converterClass);
            this.addPropertyEditorIfNecessary(targetClass);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("added converter of class type ''{0}''", converterClass));
        }
    }

    public Converter<?> createConverter(String converterId) {
        Util.notNull("converterId", converterId);
        Converter converter = this.createCDIConverter(converterId);
        if (converter != null) {
            return converter;
        }
        converter = (Converter)this.newThing(converterId, this.converterIdMap);
        Util.notNullNamedObject(converter, converterId, "faces.cannot_instantiate_converter_error");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("created converter of type ''{0}''", converterId));
        }
        if (this.passDefaultTimeZone && converter instanceof DateTimeConverter) {
            ((DateTimeConverter)converter).setTimeZone(this.systemTimeZone);
        }
        this.associate.getAnnotationManager().applyConverterAnnotations(FacesContext.getCurrentInstance(), converter);
        return converter;
    }

    public Converter createConverter(Class<?> targetClass) {
        Class<?> superclass;
        Util.notNull("targetClass", targetClass);
        Converter returnVal = null;
        BeanManager beanManager = this.getBeanManager();
        returnVal = CdiUtils.createConverter(beanManager, targetClass);
        if (returnVal != null) {
            return returnVal;
        }
        returnVal = (Converter)this.newConverter(targetClass, this.converterTypeMap, targetClass);
        if (returnVal != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            if (this.passDefaultTimeZone && returnVal instanceof DateTimeConverter) {
                ((DateTimeConverter)returnVal).setTimeZone(this.systemTimeZone);
            }
            this.associate.getAnnotationManager().applyConverterAnnotations(FacesContext.getCurrentInstance(), returnVal);
            return returnVal;
        }
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                returnVal = this.createConverterBasedOnClass(interfaces[i], targetClass);
                if (returnVal == null) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
                }
                if (this.passDefaultTimeZone && returnVal instanceof DateTimeConverter) {
                    ((DateTimeConverter)returnVal).setTimeZone(this.systemTimeZone);
                }
                this.associate.getAnnotationManager().applyConverterAnnotations(FacesContext.getCurrentInstance(), returnVal);
                return returnVal;
            }
        }
        if ((superclass = targetClass.getSuperclass()) != null && (returnVal = this.createConverterBasedOnClass(superclass, targetClass)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            if (this.passDefaultTimeZone && returnVal instanceof DateTimeConverter) {
                ((DateTimeConverter)returnVal).setTimeZone(this.systemTimeZone);
            }
            this.associate.getAnnotationManager().applyConverterAnnotations(FacesContext.getCurrentInstance(), returnVal);
            return returnVal;
        }
        return returnVal;
    }

    public Iterator<String> getConverterIds() {
        return this.converterIdMap.keySet().iterator();
    }

    public Iterator<Class<?>> getConverterTypes() {
        return this.converterTypeMap.keySet().iterator();
    }

    public void addValidator(String validatorId, String validatorClass) {
        Util.notNull("validatorId", validatorId);
        Util.notNull("validatorClass", validatorClass);
        if (LOGGER.isLoggable(Level.FINE) && this.validatorMap.containsKey(validatorId)) {
            LOGGER.log(Level.FINE, "validatorId {0} has already been registered.  Replacing existing validator class type {1} with {2}.", new Object[]{validatorId, this.validatorMap.get(validatorId), validatorClass});
        }
        this.validatorMap.put(validatorId, validatorClass);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("added validator of type ''{0}'' class ''{1}''", validatorId, validatorClass));
        }
    }

    public Validator<?> createValidator(String validatorId) throws FacesException {
        Util.notNull("validatorId", validatorId);
        Validator validator = this.createCDIValidator(validatorId);
        if (validator != null) {
            return validator;
        }
        validator = (Validator)this.newThing(validatorId, this.validatorMap);
        Util.notNullNamedObject(validator, validatorId, "faces.cannot_instantiate_validator_error");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("created validator of type ''{0}''", validatorId));
        }
        this.associate.getAnnotationManager().applyValidatorAnnotations(FacesContext.getCurrentInstance(), validator);
        return validator;
    }

    public Iterator<String> getValidatorIds() {
        return this.validatorMap.keySet().iterator();
    }

    public synchronized void addDefaultValidatorId(String validatorId) {
        Util.notNull("validatorId", validatorId);
        this.defaultValidatorInfo = null;
        this.defaultValidatorIds.add(validatorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultValidatorInfo() {
        if (this.defaultValidatorInfo == null) {
            InstanceFactory instanceFactory = this;
            synchronized (instanceFactory) {
                if (this.defaultValidatorInfo == null) {
                    this.defaultValidatorInfo = new LinkedHashMap<String, String>();
                    if (!this.defaultValidatorIds.isEmpty()) {
                        for (String id : this.defaultValidatorIds) {
                            Object result = this.validatorMap.get(id);
                            if (null == result) continue;
                            String validatorClass = result instanceof Class ? ((Class)result).getName() : result.toString();
                            this.defaultValidatorInfo.put(id, validatorClass);
                        }
                    }
                }
            }
            this.defaultValidatorInfo = Collections.unmodifiableMap(this.defaultValidatorInfo);
        }
        return this.defaultValidatorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIComponent createComponentFromScriptResource(FacesContext context, Resource scriptComponentResource, Resource componentResource) {
        UIComponent result;
        block8: {
            result = null;
            String className = scriptComponentResource.getResourceName();
            int lastDot = className.lastIndexOf(46);
            className = className.substring(0, lastDot);
            try {
                Class componentClass = (Class)this.componentMap.get(className);
                if (componentClass == null) {
                    componentClass = Util.loadClass(className, this);
                }
                if (!this.associate.isDevModeEnabled()) {
                    this.componentMap.put(className, componentClass);
                }
                result = (UIComponent)componentClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        if (result != null) {
            result.getAttributes().put("jakarta.faces.application.Resource.ComponentResource", componentResource);
            context.getAttributes().put("com.sun.faces.composite.this.library", componentResource.getLibraryName());
            try {
                this.associate.getAnnotationManager().applyComponentAnnotations(context, result);
            }
            finally {
                context.getAttributes().remove("com.sun.faces.composite.this.library");
            }
        }
        return result;
    }

    private UIComponent createComponentApplyAnnotations(FacesContext ctx, ValueExpression componentExpression, String componentType, String rendererType, boolean applyAnnotations) {
        UIComponent c;
        try {
            c = (UIComponent)componentExpression.getValue(ctx.getELContext());
            if (c == null) {
                c = this.createComponentApplyAnnotations(ctx, componentType, rendererType, applyAnnotations);
                componentExpression.setValue(ctx.getELContext(), (Object)c);
            } else if (applyAnnotations) {
                this.applyAnnotations(ctx, rendererType, c);
            }
        }
        catch (Exception ex) {
            throw new FacesException(ex);
        }
        return c;
    }

    private UIComponent createComponentApplyAnnotations(FacesContext ctx, String componentType, String rendererType, boolean applyAnnotations) {
        UIComponent component;
        try {
            component = (UIComponent)this.newThing(componentType, this.componentMap);
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "faces.cannot_instantiate_component_error", componentType);
            }
            throw new FacesException(ex);
        }
        Util.notNullNamedObject(component, componentType, "faces.cannot_instantiate_component_error");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, MessageFormat.format("Created component with component type of ''{0}''", componentType));
        }
        if (applyAnnotations) {
            this.applyAnnotations(ctx, rendererType, component);
        }
        return component;
    }

    private void applyAnnotations(FacesContext ctx, String rendererType, UIComponent c) {
        if (c != null && ctx != null) {
            this.associate.getAnnotationManager().applyComponentAnnotations(ctx, c);
            if (rendererType != null) {
                RenderKit rk = ctx.getRenderKit();
                Renderer r = null;
                if (rk != null && (r = rk.getRenderer(c.getFamily(), rendererType)) != null) {
                    c.setRendererType(rendererType);
                    this.associate.getAnnotationManager().applyRendererAnnotations(ctx, r, c);
                }
                if ((rk == null || r == null) && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to create Renderer with rendererType {0} for component with component type of {1}", new Object[]{rendererType, c.getFamily()});
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T newThing(String key, ViewMemberInstanceFactoryMetadataMap<String, Object> map) {
        Object result;
        Class clazz;
        block10: {
            Object value = map.get(key);
            if (value == null) {
                return null;
            }
            assert (value instanceof String || value instanceof Class);
            if (value instanceof String) {
                String cValue = (String)value;
                try {
                    clazz = Util.loadClass(cValue, value);
                    if (!this.associate.isDevModeEnabled()) {
                        map.put(key, clazz);
                    }
                    assert (clazz != null);
                    break block10;
                }
                catch (Exception e) {
                    throw new FacesException(e.getMessage(), e);
                }
            }
            clazz = (Class)value;
        }
        try {
            result = clazz.newInstance();
        }
        catch (Throwable t) {
            void previousT;
            do {
                previousT = t;
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unable to load class: ", t);
            } while (null != (t = t.getCause()));
            t = previousT;
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", clazz.getName()), t);
        }
        return result;
    }

    private void pushDeclaredDefaultValuesToAttributesMap(FacesContext context, BeanInfo componentMetadata, Map<String, Object> attrs, UIComponent component, ExpressionFactory expressionFactory) {
        HashSet<String> attributesWithDeclaredDefaultValues = null;
        PropertyDescriptor[] propertyDescriptors = null;
        for (PropertyDescriptor propertyDescriptor : componentMetadata.getPropertyDescriptors()) {
            BeanDescriptor beanDescriptor;
            Object defaultValue = propertyDescriptor.getValue("default");
            if (defaultValue == null) continue;
            String key = propertyDescriptor.getName();
            boolean isLiteralText = false;
            if (defaultValue instanceof ValueExpression && (isLiteralText = ((ValueExpression)defaultValue).isLiteralText())) {
                defaultValue = ((ValueExpression)defaultValue).getValue(context.getELContext());
            }
            if (propertyDescriptor.getValue("method-signature") != null && propertyDescriptor.getValue("type") == null) continue;
            if (attributesWithDeclaredDefaultValues == null && (attributesWithDeclaredDefaultValues = (Collection)(beanDescriptor = componentMetadata.getBeanDescriptor()).getValue("jakarta.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES")) == null) {
                attributesWithDeclaredDefaultValues = new HashSet<String>();
                beanDescriptor.setValue("jakarta.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES", attributesWithDeclaredDefaultValues);
            }
            attributesWithDeclaredDefaultValues.add(key);
            if (!isLiteralText) continue;
            try {
                if (propertyDescriptors == null) {
                    propertyDescriptors = Introspector.getBeanInfo(component.getClass()).getPropertyDescriptors();
                }
            }
            catch (IntrospectionException e) {
                throw new FacesException(e);
            }
            defaultValue = this.convertValueToTypeIfNecessary(key, defaultValue, propertyDescriptors, expressionFactory);
            attrs.put(key, defaultValue);
        }
    }

    private Object convertValueToTypeIfNecessary(String name, Object value, PropertyDescriptor[] propertyDescriptors, ExpressionFactory expressionFactory) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.getName().equals(name)) continue;
            value = expressionFactory.coerceToType(value, propertyDescriptor.getPropertyType());
            break;
        }
        return value;
    }

    private void addPropertyEditorIfNecessary(Class<?> targetClass) {
        if (!this.registerPropertyEditors) {
            return;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(targetClass);
        if (editor != null) {
            return;
        }
        String className = targetClass.getName();
        if (targetClass.isPrimitive()) {
            return;
        }
        for (String standardClass : this.STANDARD_BY_TYPE_CONVERTER_CLASSES) {
            if (standardClass.indexOf(className) == -1) continue;
            return;
        }
        Class<? extends ConverterPropertyEditorBase> editorClass = ConverterPropertyEditorFactory.getDefaultInstance().definePropertyEditorClassFor(targetClass);
        if (editorClass != null) {
            PropertyEditorManager.registerEditor(targetClass, editorClass);
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning(MessageFormat.format("definePropertyEditorClassFor({0}) returned null.", targetClass.getName()));
        }
    }

    private Converter createConverterBasedOnClass(Class<?> targetClass, Class<?> baseClass) {
        Class<?> superclass;
        Converter returnVal = (Converter)this.newConverter(targetClass, this.converterTypeMap, baseClass);
        if (returnVal != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            return returnVal;
        }
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                returnVal = this.createConverterBasedOnClass(interfaces[i], null);
                if (returnVal == null) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
                }
                return returnVal;
            }
        }
        if ((superclass = targetClass.getSuperclass()) != null && (returnVal = this.createConverterBasedOnClass(superclass, targetClass)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Created converter of type ''{0}''", returnVal.getClass().getName()));
            }
            return returnVal;
        }
        return returnVal;
    }

    protected Object newConverter(Class<?> key, Map<Class<?>, Object> map, Class<?> targetClass) {
        Class clazz;
        Object result;
        block15: {
            assert (key != null && map != null);
            result = null;
            Object value = map.get(key);
            if (value == null) {
                return null;
            }
            assert (value instanceof String || value instanceof Class);
            if (value instanceof String) {
                String cValue = (String)value;
                try {
                    clazz = Util.loadClass(cValue, value);
                    if (!this.associate.isDevModeEnabled()) {
                        map.put(key, clazz);
                    }
                    assert (clazz != null);
                    break block15;
                }
                catch (Exception e) {
                    throw new FacesException(e.getMessage(), e);
                }
            }
            clazz = (Class)value;
        }
        Constructor<?> ctor = ReflectionUtils.lookupConstructor(clazz, Class.class);
        Exception cause = null;
        if (ctor != null) {
            try {
                result = ctor.newInstance(targetClass);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                cause = e;
            }
        } else {
            try {
                result = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                cause = e;
            }
        }
        if (null != cause) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", clazz.getName()), cause);
        }
        return result;
    }

    private BeanManager getBeanManager() {
        if (this.beanManager == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.beanManager = Util.getCdiBeanManager(facesContext);
        }
        return this.beanManager;
    }

    private Behavior createCDIBehavior(String behaviorId) {
        return CdiUtils.createBehavior(this.getBeanManager(), behaviorId);
    }

    private Converter<?> createCDIConverter(String converterId) {
        return CdiUtils.createConverter(this.getBeanManager(), converterId);
    }

    private Validator<?> createCDIValidator(String validatorId) {
        return CdiUtils.createValidator(this.getBeanManager(), validatorId);
    }

    static {
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Byte", new Class[]{Byte.TYPE, Byte.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Boolean", new Class[]{Boolean.TYPE, Boolean.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Character", new Class[]{Character.TYPE, Character.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Short", new Class[]{Short.TYPE, Short.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Integer", new Class[]{Integer.TYPE, Integer.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Long", new Class[]{Long.TYPE, Long.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Float", new Class[]{Float.TYPE, Float.class});
        STANDARD_CONV_ID_TO_TYPE_MAP.put("jakarta.faces.Double", new Class[]{Double.TYPE, Double.class});
        for (Map.Entry<String, Class<?>[]> entry : STANDARD_CONV_ID_TO_TYPE_MAP.entrySet()) {
            Class<?>[] types = entry.getValue();
            String key = entry.getKey();
            for (Class<?> clazz : types) {
                STANDARD_TYPE_TO_CONV_ID_MAP.put(clazz, key);
            }
        }
    }

    private static final class ComponentResourceClassNotFound {
        private ComponentResourceClassNotFound() {
        }
    }
}

