/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.component;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.facelets.tag.IterationStatus;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.Util;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.model.ArrayDataModel;
import jakarta.faces.model.DataModel;
import jakarta.faces.model.IterableDataModel;
import jakarta.faces.model.ListDataModel;
import jakarta.faces.model.ResultSetDataModel;
import jakarta.faces.model.ScalarDataModel;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIRepeat
extends UINamingContainer {
    public static final String COMPONENT_TYPE = "facelets.ui.Repeat";
    public static final String COMPONENT_FAMILY = "facelets";
    private static final DataModel EMPTY_MODEL = new ListDataModel(Collections.emptyList());
    private Object value;
    private transient DataModel model;
    private String var;
    private String varStatus;
    private int index = -1;
    private Integer begin;
    private Integer end;
    private Integer step;
    private Integer size;
    private transient StringBuffer buffer;
    private transient Object origValueOfVar;
    private transient Object origValueOfVarStatus;
    private Map<String, SavedState> childState;
    private static final SavedState NULL_STATE = new SavedState();

    public UIRepeat() {
        this.setRendererType(COMPONENT_TYPE);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public Integer getEnd() {
        if (this.end != null) {
            return this.end;
        }
        ValueExpression ve = this.getValueExpression("end");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        if (this.size != null) {
            return this.size;
        }
        ValueExpression ve = this.getValueExpression("size");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOffset(Integer offset) {
        this.begin = offset;
    }

    public Integer getOffset() {
        if (this.begin != null) {
            return this.begin;
        }
        ValueExpression ve = this.getValueExpression("offset");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBegin(Integer begin) {
        this.begin = begin;
    }

    public Integer getBegin() {
        if (this.begin != null) {
            return this.begin;
        }
        ValueExpression ve = this.getValueExpression("begin");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public Integer getStep() {
        if (this.step != null) {
            return this.step;
        }
        ValueExpression ve = this.getValueExpression("step");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    private void resetDataModel(FacesContext context) {
        if (Util.isNestedInIterator(context, this)) {
            this.setDataModel(null);
        }
    }

    private void setDataModel(DataModel model) {
        this.model = model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataModel getDataModel() {
        if (this.model != null) return this.model;
        Object val = this.getValue();
        if (val == null) {
            Integer begin = this.getBegin();
            Integer end = this.getEnd();
            if (end == null) {
                if (begin != null) throw new IllegalArgumentException("end");
                this.model = EMPTY_MODEL;
                return this.model;
            } else {
                int e;
                int b = begin == null ? 0 : begin;
                int d = b < (e = end.intValue()) ? 1 : (b > e ? -1 : 0);
                int s = Math.abs(e - b) + 1;
                Integer[] array = new Integer[s];
                for (int i = 0; i < s; ++i) {
                    array[i] = b + i * d;
                }
                this.model = new ArrayDataModel<Integer>(array);
                this.setBegin(0);
                this.setEnd(s);
            }
            return this.model;
        } else if (val instanceof DataModel) {
            this.model = (DataModel)val;
            return this.model;
        } else if (val instanceof List) {
            this.model = new ListDataModel((List)val);
            return this.model;
        } else if (Object[].class.isAssignableFrom(val.getClass())) {
            this.model = new ArrayDataModel<Object>((Object[])val);
            return this.model;
        } else if (val instanceof ResultSet) {
            this.model = new ResultSetDataModel((ResultSet)val);
            return this.model;
        } else if (val instanceof Iterable) {
            this.model = new IterableDataModel((Iterable)val);
            return this.model;
        } else if (val instanceof Map) {
            this.model = new IterableDataModel(((Map)val).entrySet());
            return this.model;
        } else {
            DataModel<?> dataModel = CdiUtils.createDataModel(val.getClass());
            if (dataModel != null) {
                dataModel.setWrappedData(val);
                this.model = dataModel;
                return this.model;
            } else {
                this.model = new ScalarDataModel<Object>(val);
            }
        }
        return this.model;
    }

    public Object getValue() {
        ValueExpression ve;
        if (this.value == null && (ve = this.getValueExpression("value")) != null) {
            return ve.getValue(this.getFacesContext().getELContext());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private StringBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        return this.buffer;
    }

    @Override
    public String getClientId(FacesContext faces) {
        String id = super.getClientId(faces);
        if (this.index >= 0) {
            id = this.getBuffer().append(id).append(UIRepeat.getSeparatorChar(faces)).append(this.index).toString();
        }
        return id;
    }

    private void captureOrigValue(FacesContext ctx) {
        if (this.var != null || this.varStatus != null) {
            Map<String, Object> attrs = ctx.getExternalContext().getRequestMap();
            if (this.var != null) {
                this.origValueOfVar = attrs.get(this.var);
            }
            if (this.varStatus != null) {
                this.origValueOfVarStatus = attrs.get(this.varStatus);
            }
        }
    }

    private void restoreOrigValue(FacesContext ctx) {
        if (this.var != null || this.varStatus != null) {
            Map<String, Object> attrs = ctx.getExternalContext().getRequestMap();
            if (this.var != null) {
                if (this.origValueOfVar != null) {
                    attrs.put(this.var, this.origValueOfVar);
                } else {
                    attrs.remove(this.var);
                }
            }
            if (this.varStatus != null) {
                if (this.origValueOfVarStatus != null) {
                    attrs.put(this.varStatus, this.origValueOfVarStatus);
                } else {
                    attrs.remove(this.varStatus);
                }
            }
        }
    }

    private Map<String, SavedState> getChildState() {
        if (this.childState == null) {
            this.childState = new HashMap<String, SavedState>();
        }
        return this.childState;
    }

    private void clearChildState() {
        this.childState = null;
    }

    private void saveChildState(FacesContext ctx) {
        if (this.getChildCount() > 0) {
            for (UIComponent uiComponent : this.getChildren()) {
                this.saveChildState(ctx, uiComponent);
            }
        }
    }

    private void removeChildState(FacesContext ctx) {
        if (this.getChildCount() > 0) {
            for (UIComponent uiComponent : this.getChildren()) {
                this.removeChildState(ctx, uiComponent);
            }
            if (this.childState != null) {
                this.childState.remove(this.getClientId(ctx));
            }
        }
    }

    private void removeChildState(FacesContext faces, UIComponent c) {
        String id = c.getId();
        c.setId(id);
        Iterator<UIComponent> itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.removeChildState(faces, itr.next());
        }
        if (this.childState != null) {
            this.childState.remove(c.getClientId(faces));
        }
    }

    private void saveChildState(FacesContext faces, UIComponent c) {
        if (c instanceof EditableValueHolder && !c.isTransient()) {
            String clientId = c.getClientId(faces);
            SavedState ss = this.getChildState().get(clientId);
            if (ss == null) {
                ss = new SavedState();
                this.getChildState().put(clientId, ss);
            }
            ss.populate((EditableValueHolder)((Object)c));
        }
        Iterator<UIComponent> itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.saveChildState(faces, itr.next());
        }
    }

    private void restoreChildState(FacesContext ctx) {
        if (this.getChildCount() > 0) {
            for (UIComponent uiComponent : this.getChildren()) {
                this.restoreChildState(ctx, uiComponent);
            }
        }
    }

    private void restoreChildState(FacesContext faces, UIComponent c) {
        String id = c.getId();
        c.setId(id);
        if (c instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)((Object)c);
            String clientId = c.getClientId(faces);
            SavedState ss = this.getChildState().get(clientId);
            if (ss != null) {
                ss.apply(evh);
            } else {
                NULL_STATE.apply(evh);
            }
        }
        Iterator<UIComponent> itr = c.getFacetsAndChildren();
        while (itr.hasNext()) {
            this.restoreChildState(faces, itr.next());
        }
    }

    private boolean keepSaved(FacesContext context) {
        return this.hasErrorMessages(context) || Util.isNestedInIterator(context, this);
    }

    private boolean hasErrorMessages(FacesContext context) {
        FacesMessage.Severity sev = context.getMaximumSeverity();
        return sev != null && FacesMessage.SEVERITY_ERROR.compareTo(sev) <= 0;
    }

    private void setIndex(FacesContext ctx, int index) {
        DataModel localModel = this.getDataModel();
        if (this.index != -1 && localModel.isRowAvailable()) {
            this.saveChildState(ctx);
        } else if (this.index >= 0 && this.childState != null) {
            this.removeChildState(ctx);
        }
        this.index = index;
        localModel.setRowIndex(index);
        if (this.index != -1 && this.var != null && localModel.isRowAvailable()) {
            Map<String, Object> attrs = ctx.getExternalContext().getRequestMap();
            attrs.put(this.var, localModel.getRowData());
        }
        if (this.index != -1 && localModel.isRowAvailable()) {
            this.restoreChildState(ctx);
        }
    }

    private void updateIterationStatus(FacesContext ctx, IterationStatus status) {
        if (this.varStatus != null) {
            Map<String, Object> attrs = ctx.getExternalContext().getRequestMap();
            attrs.put(this.varStatus, status);
        }
    }

    private boolean isIndexAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public void process(FacesContext faces, PhaseId phase) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel(faces);
        if (PhaseId.RENDER_RESPONSE.equals(phase) && !this.hasErrorMessages(faces)) {
            this.clearChildState();
        }
        this.captureOrigValue(faces);
        this.setIndex(faces, -1);
        try {
            if (this.getChildCount() > 0) {
                Integer size;
                Integer begin = this.getBegin();
                Integer step = this.getStep();
                Integer end = this.getEnd();
                Integer offset = this.getOffset();
                if (null != offset && offset > 0) {
                    begin = offset;
                }
                if (null != (size = this.getSize())) {
                    end = size;
                }
                String rendererType = this.getRendererType();
                Renderer renderer = null;
                if (rendererType != null) {
                    renderer = this.getRenderer(faces);
                }
                int rowCount = this.getDataModel().getRowCount();
                int i = begin != null ? begin : 0;
                int e = end != null ? end : rowCount;
                int s = step != null ? step : 1;
                this.validateIterationControlValues(rowCount, i, e);
                if (null != size && size > 0) {
                    e = size - 1;
                }
                this.setIndex(faces, i);
                this.updateIterationStatus(faces, new IterationStatus(true, i + s > e || rowCount == 1, i, begin, end, step));
                while (i <= e && this.isIndexAvailable()) {
                    if (PhaseId.RENDER_RESPONSE.equals(phase) && renderer != null) {
                        renderer.encodeChildren(faces, this);
                    } else {
                        for (UIComponent c : this.getChildren()) {
                            if (PhaseId.APPLY_REQUEST_VALUES.equals(phase)) {
                                c.processDecodes(faces);
                                continue;
                            }
                            if (PhaseId.PROCESS_VALIDATIONS.equals(phase)) {
                                c.processValidators(faces);
                                continue;
                            }
                            if (PhaseId.UPDATE_MODEL_VALUES.equals(phase)) {
                                c.processUpdates(faces);
                                continue;
                            }
                            if (!PhaseId.RENDER_RESPONSE.equals(phase)) continue;
                            c.encodeAll(faces);
                        }
                    }
                    this.setIndex(faces, i += s);
                    this.updateIterationStatus(faces, new IterationStatus(false, i + s >= e, i, begin, end, step));
                }
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        finally {
            this.setIndex(faces, -1);
            this.restoreOrigValue(faces);
        }
        if (PhaseId.RENDER_RESPONSE.equals(phase)) {
            this.resetClientIds(this);
        }
    }

    private void resetClientIds(UIComponent component) {
        Iterator<UIComponent> iterator = component.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent child = iterator.next();
            this.resetClientIds(child);
            child.setId(child.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeOnComponent(FacesContext faces, String clientId, ContextCallback callback) throws FacesException {
        String id = super.getClientId(faces);
        if (clientId.equals(id)) {
            this.pushComponentToEL(faces, this);
            try {
                callback.invokeContextCallback(faces, this);
            }
            finally {
                this.popComponentFromEL(faces);
            }
            return true;
        }
        if (clientId.startsWith(id)) {
            int prevIndex = this.index;
            int idxStart = clientId.indexOf(UIRepeat.getSeparatorChar(faces), id.length());
            if (idxStart != -1 && Character.isDigit(clientId.charAt(idxStart + 1))) {
                int idxEnd = clientId.indexOf(UIRepeat.getSeparatorChar(faces), idxStart + 1);
                if (idxEnd != -1) {
                    int newIndex = Integer.parseInt(clientId.substring(idxStart + 1, idxEnd));
                    boolean found = false;
                    try {
                        this.captureOrigValue(faces);
                        this.setIndex(faces, newIndex);
                        if (this.isIndexAvailable()) {
                            found = super.invokeOnComponent(faces, clientId, callback);
                        }
                    }
                    finally {
                        this.setIndex(faces, prevIndex);
                        this.restoreOrigValue(faces);
                    }
                    return found;
                }
            } else {
                return super.invokeOnComponent(faces, clientId, callback);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block12: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            boolean visitRows = this.requiresRowIteration(context);
            int oldIndex = -1;
            if (visitRows) {
                oldIndex = this.index;
                this.captureOrigValue(facesContext);
                this.setIndex(facesContext, -1);
            }
            this.setDataModel(null);
            this.pushComponentToEL(facesContext, null);
            try {
                VisitResult result = context.invokeVisitCallback(this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT || !this.doVisitChildren(context)) break block12;
                if (!visitRows) {
                    for (UIComponent kid : this.getChildren()) {
                        if (!kid.visitTree(context, callback)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    break block12;
                }
                if (this.visitChildren(context, callback)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
                if (visitRows) {
                    this.setIndex(facesContext, oldIndex);
                    this.restoreOrigValue(facesContext);
                }
            }
        }
        return false;
    }

    private boolean requiresRowIteration(VisitContext ctx) {
        boolean shouldIterate;
        boolean bl = shouldIterate = !ctx.getHints().contains((Object)VisitHint.SKIP_ITERATION);
        if (!shouldIterate) {
            FacesContext faces = ctx.getFacesContext();
            String sourceId = RenderKitUtils.PredefinedPostbackParameter.BEHAVIOR_SOURCE_PARAM.getValue(faces);
            boolean containsSource = sourceId != null ? sourceId.startsWith(super.getClientId(faces) + UIRepeat.getSeparatorChar(faces)) : false;
            return containsSource;
        }
        return shouldIterate;
    }

    private boolean doVisitChildren(VisitContext context) {
        if (this.requiresRowIteration(context)) {
            this.setIndex(context.getFacesContext(), -1);
        }
        Collection<String> idsToVisit = context.getSubtreeIdsToVisit(this);
        assert (idsToVisit != null);
        return !idsToVisit.isEmpty();
    }

    private void validateIterationControlValues(int rowCount, int begin, int end) {
        if (rowCount == 0) {
            return;
        }
        if (begin > rowCount) {
            throw new FacesException("Iteration start index is greater than the number of available rows.");
        }
        if (begin > end) {
            throw new FacesException("Iteration start index is greater than the end index.");
        }
        if (end > rowCount) {
            throw new FacesException("Iteration end index is greater than the number of available rows.");
        }
    }

    private boolean visitChildren(VisitContext context, VisitCallback callback) {
        int i;
        Integer begin = this.getBegin();
        Integer end = this.getEnd();
        Integer step = this.getStep();
        int rowCount = this.getDataModel().getRowCount();
        int e = end != null ? end : rowCount;
        int s = step != null ? step : 1;
        this.validateIterationControlValues(rowCount, i, e);
        FacesContext faces = context.getFacesContext();
        this.setIndex(faces, i);
        this.updateIterationStatus(faces, new IterationStatus(true, i + s > e || rowCount == 1, i, begin, end, step));
        for (i = begin != null ? begin : 0; i < e && this.isIndexAvailable(); i += s) {
            this.setIndex(faces, i);
            this.updateIterationStatus(faces, new IterationStatus(false, i + s >= e, i, begin, end, step));
            for (UIComponent kid : this.getChildren()) {
                if (!kid.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this.keepSaved(faces)) {
            this.childState = null;
        }
        this.process(faces, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(faces);
    }

    @Override
    public void processUpdates(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel(faces);
        this.process(faces, PhaseId.UPDATE_MODEL_VALUES);
    }

    @Override
    public void processValidators(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.resetDataModel(faces);
        Application app = faces.getApplication();
        app.publishEvent(faces, PreValidateEvent.class, this);
        this.process(faces, PhaseId.PROCESS_VALIDATIONS);
        app.publishEvent(faces, PostValidateEvent.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof IndexedEvent) {
            IndexedEvent idxEvent = (IndexedEvent)event;
            FacesEvent target = idxEvent.getTarget();
            FacesContext ctx = target.getFacesContext();
            this.resetDataModel(ctx);
            int prevIndex = this.index;
            UIComponent source = target.getComponent();
            UIComponent compositeParent = null;
            try {
                int rowCount = this.getDataModel().getRowCount();
                int idx = idxEvent.getIndex();
                this.setIndex(ctx, idx);
                Integer begin = this.getBegin();
                Integer end = this.getEnd();
                Integer step = this.getStep();
                int b = begin != null ? begin : 0;
                int e = end != null ? end : rowCount;
                int s = step != null ? step : 1;
                this.updateIterationStatus(ctx, new IterationStatus(idx == b, idx + s >= e || rowCount == 1, idx, begin, end, step));
                if (!this.isIndexAvailable()) return;
                if (!UIComponent.isCompositeComponent(source)) {
                    compositeParent = UIComponent.getCompositeComponentParent(source);
                }
                if (compositeParent != null) {
                    compositeParent.pushComponentToEL(ctx, null);
                }
                source.pushComponentToEL(ctx, null);
                source.broadcast(target);
                return;
            }
            finally {
                source.popComponentFromEL(ctx);
                if (compositeParent != null) {
                    compositeParent.popComponentFromEL(ctx);
                }
                this.updateIterationStatus(ctx, null);
                this.setIndex(ctx, prevIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        super.queueEvent(new IndexedEvent(this, event, this.index));
    }

    @Override
    public void restoreState(FacesContext faces, Object object) {
        if (faces == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        this.childState = (Map)state[1];
        this.begin = (Integer)state[2];
        this.end = (Integer)state[3];
        this.step = (Integer)state[4];
        this.var = (String)state[5];
        this.varStatus = (String)state[6];
        this.value = state[7];
    }

    @Override
    public Object saveState(FacesContext faces) {
        this.resetClientIds(this);
        if (faces == null) {
            throw new NullPointerException();
        }
        Object[] state = new Object[]{super.saveState(faces), this.childState, this.begin, this.end, this.step, this.var, this.varStatus, this.value};
        return state;
    }

    @Override
    public void encodeChildren(FacesContext faces) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.setDataModel(null);
        if (!this.keepSaved(faces)) {
            this.childState = null;
        }
        this.process(faces, PhaseId.RENDER_RESPONSE);
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer;
        if (this.getRendererType() != null && (renderer = this.getRenderer(this.getFacesContext())) != null) {
            return renderer.getRendersChildren();
        }
        return true;
    }

    private static final class IndexedEvent
    extends FacesEvent {
        private static final long serialVersionUID = 1L;
        private final FacesEvent target;
        private final int index;

        public IndexedEvent(UIRepeat owner, FacesEvent target, int index) {
            super(owner);
            this.target = target;
            this.index = index;
        }

        @Override
        public PhaseId getPhaseId() {
            return this.target.getPhaseId();
        }

        @Override
        public void setPhaseId(PhaseId phaseId) {
            this.target.setPhaseId(phaseId);
        }

        @Override
        public boolean isAppropriateListener(FacesListener listener) {
            return this.target.isAppropriateListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processListener(FacesListener listener) {
            UIRepeat owner = (UIRepeat)this.getComponent();
            int prevIndex = owner.index;
            FacesContext ctx = FacesContext.getCurrentInstance();
            try {
                owner.setIndex(ctx, this.index);
                if (owner.isIndexAvailable()) {
                    this.target.processListener(listener);
                }
            }
            finally {
                owner.setIndex(ctx, prevIndex);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public FacesEvent getTarget() {
            return this.target;
        }
    }

    private static final class SavedState
    implements Serializable {
        private Object submittedValue;
        private static final long serialVersionUID = 2920252657338389849L;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        private SavedState() {
        }

        Object getSubmittedValue() {
            return this.submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this.submittedValue = submittedValue;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        boolean isLocalValueSet() {
            return this.localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this.localValueSet = localValueSet;
        }

        public String toString() {
            return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
        }

        public void populate(EditableValueHolder evh) {
            this.value = evh.getLocalValue();
            this.valid = evh.isValid();
            this.submittedValue = evh.getSubmittedValue();
            this.localValueSet = evh.isLocalValueSet();
        }

        public void apply(EditableValueHolder evh) {
            evh.setValue(this.value);
            evh.setValid(this.valid);
            evh.setSubmittedValue(this.submittedValue);
            evh.setLocalValueSet(this.localValueSet);
        }
    }
}

