/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.istack.tools.MaskingClassLoader;
import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.xjc.SecureLoader;
import com.sun.tools.xjc.XJCFacade;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;

class ClassLoaderBuilder {
    private static String[] maskedPackages = new String[]{"com.sun.tools.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom.", "com.sun.xml.bind."};
    private static String[] toolPackages = new String[]{"com.sun.tools.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom."};
    public static final boolean noHack = Boolean.getBoolean(XJCFacade.class.getName() + ".nohack");

    ClassLoaderBuilder() {
    }

    protected static ClassLoader createProtectiveClassLoader(ClassLoader cl, String v) throws ClassNotFoundException, MalformedURLException {
        if (noHack) {
            return cl;
        }
        boolean mustang = false;
        if (SecureLoader.getClassClassLoader(JAXBContext.class) == null) {
            mustang = true;
            ArrayList<String> mask = new ArrayList<String>(Arrays.asList(maskedPackages));
            mask.add("javax.xml.bind.");
            cl = new MaskingClassLoader(cl, mask);
            URL apiUrl = cl.getResource("javax/xml/bind/JAXBPermission.class");
            if (apiUrl == null) {
                throw new ClassNotFoundException("There's no JAXB 2.2 API in the classpath");
            }
            cl = new URLClassLoader(new URL[]{ParallelWorldClassLoader.toJarUrl((URL)apiUrl)}, cl);
        }
        if ("1.0".equals(v)) {
            if (!mustang) {
                cl = new MaskingClassLoader(cl, toolPackages);
            }
            cl = new ParallelWorldClassLoader(cl, "1.0/");
        } else if (mustang) {
            cl = new ParallelWorldClassLoader(cl, "");
        }
        return cl;
    }
}

