/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.tools.txw2.SchemaBuilder;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.builder.relaxng.SchemaBuilderImpl;
import com.sun.tools.txw2.model.Leaf;
import com.sun.tools.txw2.model.NodeSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.kohsuke.rngom.ast.util.CheckingSchemaBuilder;
import org.kohsuke.rngom.dt.CascadingDatatypeLibraryFactory;
import org.kohsuke.rngom.dt.builtin.BuiltinDatatypeLibraryFactory;
import org.kohsuke.rngom.parse.IllegalSchemaException;
import org.kohsuke.rngom.parse.Parseable;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;

class RELAXNGLoader
implements SchemaBuilder {
    private final Parseable parseable;

    public RELAXNGLoader(Parseable parseable) {
        this.parseable = parseable;
    }

    @Override
    public NodeSet build(TxwOptions options) throws IllegalSchemaException {
        SchemaBuilderImpl stage1 = new SchemaBuilderImpl(options.codeModel);
        DatatypeLibraryLoader loader = new DatatypeLibraryLoader(this.getClass().getClassLoader());
        Leaf pattern = (Leaf)this.parseable.parse((org.kohsuke.rngom.ast.builder.SchemaBuilder)new CheckingSchemaBuilder((org.kohsuke.rngom.ast.builder.SchemaBuilder)stage1, (ErrorHandler)options.errorListener, (DatatypeLibraryFactory)new CascadingDatatypeLibraryFactory((DatatypeLibraryFactory)new BuiltinDatatypeLibraryFactory((DatatypeLibraryFactory)loader), (DatatypeLibraryFactory)loader)));
        return new NodeSet(options, pattern);
    }

    private static final class DatatypeLibraryLoader
    implements DatatypeLibraryFactory {
        private final Service service;

        private DatatypeLibraryLoader(ClassLoader cl) {
            this.service = new Service(DatatypeLibraryFactory.class, cl);
        }

        public DatatypeLibrary createDatatypeLibrary(String uri) {
            Enumeration e = this.service.getProviders();
            while (e.hasMoreElements()) {
                DatatypeLibraryFactory factory = (DatatypeLibraryFactory)e.nextElement();
                DatatypeLibrary library = factory.createDatatypeLibrary(uri);
                if (library == null) continue;
                return library;
            }
            return null;
        }

        private static class Service {
            private final Class serviceClass;
            private Enumeration configFiles;
            private Enumeration classNames = null;
            private final Vector providers = new Vector();
            private ClassLoader cl;
            private static final int START = 0;
            private static final int IN_NAME = 1;
            private static final int IN_COMMENT = 2;

            public Service(Class cls, ClassLoader cl) {
                this.cl = cl;
                this.serviceClass = cls;
                String resName = "META-INF/services/" + this.serviceClass.getName();
                try {
                    this.configFiles = cl.getResources(resName);
                }
                catch (IOException e) {
                    this.configFiles = new Vector().elements();
                }
            }

            public Enumeration getProviders() {
                return new ProviderEnumeration();
            }

            private synchronized boolean moreProviders() {
                while (true) {
                    if (this.classNames == null) {
                        if (!this.configFiles.hasMoreElements()) {
                            return false;
                        }
                        this.classNames = Service.parseConfigFile((URL)this.configFiles.nextElement());
                        continue;
                    }
                    while (this.classNames.hasMoreElements()) {
                        String className = (String)this.classNames.nextElement();
                        try {
                            Class<?> cls = this.cl.loadClass(className);
                            Object obj = cls.newInstance();
                            if (!this.serviceClass.isInstance(obj)) continue;
                            this.providers.addElement(obj);
                            return true;
                        }
                        catch (ClassNotFoundException e) {
                        }
                        catch (InstantiationException e) {
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (LinkageError linkageError) {
                        }
                    }
                    this.classNames = null;
                }
            }

            private static Enumeration parseConfigFile(URL url) {
                try {
                    int n;
                    Reader r;
                    InputStream in = url.openStream();
                    try {
                        r = new InputStreamReader(in, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        r = new InputStreamReader(in, "UTF8");
                    }
                    r = new BufferedReader(r);
                    Vector<String> tokens = new Vector<String>();
                    StringBuffer tokenBuf = new StringBuffer();
                    int state = 0;
                    while ((n = r.read()) >= 0) {
                        char c = (char)n;
                        switch (c) {
                            case '\n': 
                            case '\r': {
                                state = 0;
                                break;
                            }
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '#': {
                                state = 2;
                                break;
                            }
                            default: {
                                if (state == 2) break;
                                state = 1;
                                tokenBuf.append(c);
                            }
                        }
                        if (tokenBuf.length() == 0 || state == 1) continue;
                        tokens.addElement(tokenBuf.toString());
                        tokenBuf.setLength(0);
                    }
                    if (tokenBuf.length() != 0) {
                        tokens.addElement(tokenBuf.toString());
                    }
                    return tokens.elements();
                }
                catch (IOException e) {
                    return null;
                }
            }

            private class ProviderEnumeration
            implements Enumeration {
                private int nextIndex = 0;

                private ProviderEnumeration() {
                }

                @Override
                public boolean hasMoreElements() {
                    return this.nextIndex < Service.this.providers.size() || Service.this.moreProviders();
                }

                public Object nextElement() {
                    try {
                        return Service.this.providers.elementAt(this.nextIndex++);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new NoSuchElementException();
                    }
                }
            }
        }
    }
}

