/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.URI;
import org.glassfish.jersey.netty.httpserver.JerseyHttp2ServerHandler;
import org.glassfish.jersey.netty.httpserver.JerseyServerHandler;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.server.ResourceConfig;

class HttpVersionChooser
extends ApplicationProtocolNegotiationHandler {
    private final URI baseUri;
    private final NettyHttpContainer container;
    private final ResourceConfig resourceConfig;

    HttpVersionChooser(URI baseUri, NettyHttpContainer container, ResourceConfig resourceConfig) {
        super("http/1.1");
        this.baseUri = baseUri;
        this.container = container;
        this.resourceConfig = resourceConfig;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            ctx.pipeline().addLast(new ChannelHandler[]{Http2MultiplexCodecBuilder.forServer((ChannelHandler)new JerseyHttp2ServerHandler(this.baseUri, this.container, this.resourceConfig)).build()});
            return;
        }
        if ("http/1.1".equals(protocol)) {
            ctx.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec(), new ChunkedWriteHandler(), new JerseyServerHandler(this.baseUri, this.container, this.resourceConfig)});
            return;
        }
        throw new IllegalStateException("Unknown protocol: " + protocol);
    }
}

