/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.inject.internal;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.Sse;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

class InjectExtension
implements Extension {
    private static final LazyValue<Set<Class<?>>> JERSEY_BOUND_INJECTABLES = Values.lazy(() -> InjectExtension.sumNonJerseyBoundInjectables());

    InjectExtension() {
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType<?> processAnnotatedType, BeanManager beanManager) {
        Class baseClass = (Class)processAnnotatedType.getAnnotatedType().getBaseType();
        if (Application.class.isAssignableFrom(baseClass) && Configuration.class.isAssignableFrom(baseClass) && !baseClass.isAnnotationPresent(Alternative.class)) {
            processAnnotatedType.veto();
        }
    }

    private void beforeDiscoveryObserver(@Observes BeforeBeanDiscovery bbf, BeanManager beanManager) {
        CdiComponentProvider cdiComponentProvider = (CdiComponentProvider)beanManager.getExtension(CdiComponentProvider.class);
        cdiComponentProvider.addHK2DepenendencyCheck(InjectExtension::isHK2Dependency);
    }

    private static final boolean isHK2Dependency(Class<?> clazz) {
        return ((Set)JERSEY_BOUND_INJECTABLES.get()).contains(clazz);
    }

    private static Set<Class<?>> sumNonJerseyBoundInjectables() {
        HashSet injectables = new HashSet();
        injectables.add(Application.class);
        injectables.add(Configuration.class);
        injectables.add(ContainerRequestContext.class);
        injectables.add(HttpHeaders.class);
        injectables.add(ParamConverterProvider.class);
        injectables.add(Providers.class);
        injectables.add(Request.class);
        injectables.add(ResourceContext.class);
        injectables.add(ResourceInfo.class);
        injectables.add(SecurityContext.class);
        injectables.add(Sse.class);
        injectables.add(UriInfo.class);
        InjectExtension.addOptionally("javax.servlet.http.HttpServletRequest", injectables);
        InjectExtension.addOptionally("javax.servlet.http.HttpServletResponse", injectables);
        InjectExtension.addOptionally("javax.servlet.ServletConfig", injectables);
        InjectExtension.addOptionally("javax.servlet.ServletContext", injectables);
        InjectExtension.addOptionally("javax.servlet.FilterConfig", injectables);
        return injectables;
    }

    private static void addOptionally(String className, Set<Class<?>> set) {
        Class optionalClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)className));
        if (optionalClass != null) {
            set.add(optionalClass);
        }
    }
}

