/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.glassfish.jersey.microprofile.restclient.RestClientProducer;

public class RestClientExtension
implements Extension {
    private Set<Class<?>> interfaces = new HashSet();

    public void collectClientRegistrations(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        Class typeDef = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (!typeDef.isInterface()) {
            throw new DeploymentException("RegisterRestClient annotation has to be on interface! " + typeDef + " is not interface.");
        }
        this.interfaces.add(typeDef);
    }

    public void restClientRegistration(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        this.interfaces.forEach(type -> abd.addBean((Bean)new RestClientProducer((Class<?>)type, bm)));
    }
}

