/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.injector;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Provider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.glassfish.jersey.inject.cdi.se.injector.InjectionUtils;
import org.glassfish.jersey.inject.cdi.se.injector.JerseyProxyResolver;
import org.glassfish.jersey.internal.inject.Injectee;
import org.glassfish.jersey.internal.inject.InjecteeImpl;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

public class JerseyConstructorInjectionPoint<T>
extends ConstructorInjectionPoint<T> {
    private final JerseyProxyResolver proxyResolver = new JerseyProxyResolver();
    private List<Supplier<Object>> cachedSuppliers;
    private Object[] cachedProxies;

    public JerseyConstructorInjectionPoint(EnhancedAnnotatedConstructor<T> constructor, Bean<T> bean, BeanManagerImpl manager, Collection<InjectionResolver> resolvers) {
        super(constructor, null, constructor.getJavaClass(), InjectionPointFactory.instance(), manager);
        List<InjecteeToSupplier> valueSuppliers = this.createValueSuppliers(constructor.getJavaMember(), this.getParameterInjectionPoints(), resolvers);
        if (this.proxyResolver.isPrixiable(bean.getScope())) {
            this.cachedProxies = this.generateProxies(valueSuppliers);
        } else {
            this.cachedSuppliers = valueSuppliers.stream().map(is -> ((InjecteeToSupplier)is).supplier).collect(Collectors.toList());
        }
    }

    public Object[] getParameterValues(BeanManagerImpl manager, CreationalContext<?> ctx, CreationalContext<?> ctxTransient) {
        if (this.cachedProxies == null) {
            return this.generateValues(this.cachedSuppliers);
        }
        return this.cachedProxies;
    }

    private Object[] generateValues(List<Supplier<Object>> suppliers) {
        Object[] parameterValues = new Object[this.getParameterInjectionPoints().size()];
        for (int i = 0; i < parameterValues.length; ++i) {
            parameterValues[i] = suppliers.get(i).get();
        }
        return parameterValues;
    }

    private Object[] generateProxies(List<InjecteeToSupplier> suppliers) {
        Object[] proxies = new Object[suppliers.size()];
        for (int i = 0; i < proxies.length; ++i) {
            final InjecteeToSupplier injecteeToSupplier = suppliers.get(i);
            proxies[i] = injecteeToSupplier.injectee.isProvider() ? new Provider<Object>(){

                public Object get() {
                    return injecteeToSupplier.supplier.get();
                }
            } : this.proxyResolver.noCachedProxy(injecteeToSupplier.injectee, injecteeToSupplier.supplier);
        }
        return proxies;
    }

    private List<InjecteeToSupplier> createValueSuppliers(Constructor<T> constructor, List<ParameterInjectionPoint<?, T>> params, Collection<InjectionResolver> resolvers) {
        ArrayList<InjecteeToSupplier> suppliers = new ArrayList<InjecteeToSupplier>();
        Map<? extends Class<?>, InjectionResolver> injectAnnotations = InjectionUtils.mapAnnotationToResolver(resolvers);
        for (int i = 0; i < params.size(); ++i) {
            Parameter parameter = params.get(i).getAnnotated().getJavaParameter();
            InjectionResolver resolver = InjectionUtils.findResolver(injectAnnotations, parameter);
            Injectee injectee = this.parameterToInjectee(constructor, parameter, i);
            suppliers.add(new InjecteeToSupplier(injectee, () -> resolver.resolve(injectee)));
        }
        return suppliers;
    }

    private Injectee parameterToInjectee(Constructor<T> constructor, Parameter parameter, int position) {
        InjecteeImpl injectee = new InjecteeImpl();
        injectee.setParent(constructor);
        if (parameter.getParameterizedType() instanceof ParameterizedType && InjectionUtils.isProvider(parameter.getParameterizedType())) {
            ParameterizedType paramType = (ParameterizedType)parameter.getParameterizedType();
            injectee.setRequiredType(paramType.getActualTypeArguments()[0]);
            injectee.setProvider(true);
        } else {
            injectee.setRequiredType(parameter.getType());
        }
        injectee.setPosition(position);
        return injectee;
    }

    private static class InjecteeToSupplier {
        private final Injectee injectee;
        private final Supplier<Object> supplier;

        private InjecteeToSupplier(Injectee injectee, Supplier<Object> supplier) {
            this.injectee = injectee;
            this.supplier = supplier;
        }
    }
}

