
package org.glassfish.jersey.jettison.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.jettison.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERROR_WRITING_JSON_OBJECT() {
        return MESSAGE_FACTORY.getMessage("error.writing.json.object");
    }

    /**
     * Error writing JSON object.
     * 
     */
    public static String ERROR_WRITING_JSON_OBJECT() {
        return LOCALIZER.localize(localizableERROR_WRITING_JSON_OBJECT());
    }

    public static Localizable localizableERROR_WRITING_JSON_ARRAY() {
        return MESSAGE_FACTORY.getMessage("error.writing.json.array");
    }

    /**
     * Error writing JSON array.
     * 
     */
    public static String ERROR_WRITING_JSON_ARRAY() {
        return LOCALIZER.localize(localizableERROR_WRITING_JSON_ARRAY());
    }

    public static Localizable localizableERROR_PARSING_JSON_ARRAY() {
        return MESSAGE_FACTORY.getMessage("error.parsing.json.array");
    }

    /**
     * Error parsing JSON array.
     * 
     */
    public static String ERROR_PARSING_JSON_ARRAY() {
        return LOCALIZER.localize(localizableERROR_PARSING_JSON_ARRAY());
    }

    public static Localizable localizableERROR_PARSING_JSON_OBJECT() {
        return MESSAGE_FACTORY.getMessage("error.parsing.json.object");
    }

    /**
     * Error parsing JSON object.
     * 
     */
    public static String ERROR_PARSING_JSON_OBJECT() {
        return LOCALIZER.localize(localizableERROR_PARSING_JSON_OBJECT());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
