/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth1;

import java.util.Arrays;

public final class AccessToken {
    private final String token;
    private final byte[] accessTokenSecret;

    public AccessToken(String token, String accessTokenSecret) {
        this.token = token;
        this.accessTokenSecret = accessTokenSecret.getBytes();
    }

    public AccessToken(String token, byte[] accessTokenSecret) {
        this.token = token;
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getToken() {
        return this.token;
    }

    public String getAccessTokenSecret() {
        return new String(this.accessTokenSecret);
    }

    public byte[] getAccessTokenSecretAsByteArray() {
        return this.accessTokenSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (!Arrays.equals(this.accessTokenSecret, that.accessTokenSecret)) {
            return false;
        }
        return this.token.equals(that.token);
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + Arrays.hashCode(this.accessTokenSecret);
        return result;
    }
}

