/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.oauth1.signature;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.glassfish.jersey.oauth1.signature.Base64;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureMethod;
import org.glassfish.jersey.uri.UriComponent;

public final class HmaSha1Method
implements OAuth1SignatureMethod {
    public static final String NAME = "HMAC-SHA1";
    private static final String SIGNATURE_ALGORITHM = "HmacSHA1";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String sign(String baseString, OAuth1Secrets secrets) {
        byte[] key;
        Mac mac;
        try {
            mac = Mac.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        StringBuilder buf = new StringBuilder();
        String secret = secrets.getConsumerSecret();
        if (secret != null) {
            buf.append(UriComponent.encode((String)secret, (UriComponent.Type)UriComponent.Type.UNRESERVED));
        }
        buf.append('&');
        secret = secrets.getTokenSecret();
        if (secret != null) {
            buf.append(UriComponent.encode((String)secret, (UriComponent.Type)UriComponent.Type.UNRESERVED));
        }
        try {
            key = buf.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
        SecretKeySpec spec = new SecretKeySpec(key, SIGNATURE_ALGORITHM);
        try {
            mac.init(spec);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        return Base64.encode(mac.doFinal(baseString.getBytes()));
    }

    @Override
    public boolean verify(String elements, OAuth1Secrets secrets, String signature) {
        return this.sign(elements, secrets).equals(signature);
    }
}

