/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.crypto.dsig.internal;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;

public class HmacSHA1 {
    private static final int SHA1_BLOCK = 64;
    private byte[] key_opad;
    private MessageDigest digest;
    private int byte_length;

    public void init(Key key, int length) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("The key should not be null");
        }
        try {
            this.digest = MessageDigest.getInstance("SHA1");
            this.initialize(key);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException("SHA1 not supported");
        }
        this.byte_length = length > 0 ? length / 8 : -1;
    }

    public void update(byte[] data) {
        this.digest.update(data);
    }

    public void update(byte data) {
        this.digest.update(data);
    }

    public void update(byte[] data, int offset, int len) {
        this.digest.update(data, offset, len);
    }

    public byte[] sign() throws SignatureException {
        if (this.byte_length == 0) {
            throw new SignatureException("length should be -1 or greater than zero, but is " + this.byte_length);
        }
        byte[] value = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.key_opad);
        this.digest.update(value);
        byte[] result = this.digest.digest();
        if (this.byte_length > 0 && result.length > this.byte_length) {
            byte[] truncated = new byte[this.byte_length];
            System.arraycopy(result, 0, truncated, 0, this.byte_length);
            result = truncated;
        }
        return result;
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return MessageDigest.isEqual(signature, this.sign());
    }

    private void initialize(Key key) {
        byte[] rawKey = key.getEncoded();
        byte[] normalizedKey = new byte[64];
        if (rawKey.length > 64) {
            this.digest.reset();
            rawKey = this.digest.digest(rawKey);
        }
        System.arraycopy(rawKey, 0, normalizedKey, 0, rawKey.length);
        for (int i = rawKey.length; i < 64; ++i) {
            normalizedKey[i] = 0;
        }
        byte[] key_ipad = new byte[64];
        this.key_opad = new byte[64];
        for (int i = 0; i < 64; ++i) {
            key_ipad[i] = (byte)(normalizedKey[i] ^ 0x36);
            this.key_opad[i] = (byte)(normalizedKey[i] ^ 0x5C);
        }
        this.digest.reset();
        this.digest.update(key_ipad);
    }
}

