/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.xmlfilter;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.xmlfilter.FilteringStateMachine;
import com.sun.xml.ws.xmlfilter.Invocation;
import com.sun.xml.ws.xmlfilter.ProcessingStateChange;
import com.sun.xml.ws.xmlfilter.XmlFilteringUtils;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public final class MexImportFilteringStateMachine
implements FilteringStateMachine {
    private static final Logger LOGGER = Logger.getLogger(MexImportFilteringStateMachine.class);
    private static final String MEX_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/09/mex";
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final QName WSDL_IMPORT_ELEMENT = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    private static final QName IMPORT_NAMESPACE_ATTIBUTE = new QName("http://schemas.xmlsoap.org/wsdl/", "namespace");
    private int depth;
    private StateMachineMode currentMode = StateMachineMode.INACTIVE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingStateChange getStateChange(Invocation invocation, XMLStreamWriter writer) {
        LOGGER.entering(invocation);
        ProcessingStateChange resultingState = ProcessingStateChange.NO_CHANGE;
        try {
            switch (invocation.getMethodType()) {
                case WRITE_START_ELEMENT: {
                    if (this.currentMode == StateMachineMode.INACTIVE) {
                        if (!this.startBuffering(invocation, writer)) break;
                        resultingState = ProcessingStateChange.START_BUFFERING;
                        this.currentMode = StateMachineMode.BUFFERING;
                        break;
                    }
                    ++this.depth;
                    break;
                }
                case WRITE_END_ELEMENT: {
                    if (this.currentMode == StateMachineMode.INACTIVE) break;
                    if (this.depth == 0) {
                        resultingState = this.currentMode == StateMachineMode.BUFFERING ? ProcessingStateChange.STOP_BUFFERING : ProcessingStateChange.STOP_FILTERING;
                        this.currentMode = StateMachineMode.INACTIVE;
                        break;
                    }
                    --this.depth;
                    break;
                }
                case WRITE_ATTRIBUTE: {
                    if (this.currentMode != StateMachineMode.BUFFERING || !this.startFiltering(invocation, writer)) break;
                    resultingState = ProcessingStateChange.START_FILTERING;
                    this.currentMode = StateMachineMode.FILTERING;
                    break;
                }
                case CLOSE: {
                    switch (this.currentMode.ordinal()) {
                        case 1: {
                            resultingState = ProcessingStateChange.STOP_BUFFERING;
                            break;
                        }
                        case 2: {
                            resultingState = ProcessingStateChange.STOP_FILTERING;
                        }
                    }
                    this.currentMode = StateMachineMode.INACTIVE;
                    break;
                }
            }
            ProcessingStateChange processingStateChange = resultingState;
            return processingStateChange;
        }
        finally {
            LOGGER.exiting((Object)resultingState);
        }
    }

    private boolean startFiltering(Invocation invocation, XMLStreamWriter writer) {
        XmlFilteringUtils.AttributeInfo attributeInfo = XmlFilteringUtils.getAttributeNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        return IMPORT_NAMESPACE_ATTIBUTE.equals(attributeInfo.getName()) && MEX_NAMESPACE.equals(attributeInfo.getValue());
    }

    private boolean startBuffering(Invocation invocation, XMLStreamWriter writer) {
        QName elementName = XmlFilteringUtils.getElementNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        return WSDL_IMPORT_ELEMENT.equals(elementName);
    }

    private static enum StateMachineMode {
        INACTIVE,
        BUFFERING,
        FILTERING;

    }
}

