/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.activation.nativeimage;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.angus.activation.MailcapFile;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class AngusActivationFeature
implements Feature {
    private static final boolean ENABLED = AngusActivationFeature.getOption("angus.activation.native-image.enable", true);
    private static final boolean DEBUG = AngusActivationFeature.getOption("angus.activation.native-image.trace", false);
    private static final List<String> RESOURCES = new ArrayList<String>(){
        {
            this.add("META-INF/mailcap");
            this.add("META-INF/mailcap.default");
        }
    };

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ENABLED;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        HashSet commands = new HashSet();
        for (String resource : RESOURCES) {
            AngusActivationFeature.log(() -> "looking for " + resource);
            try {
                Enumeration<URL> urls = access.getApplicationClassLoader().getResources(resource);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    AngusActivationFeature.log(() -> "processing " + String.valueOf(url));
                    InputStream is = url.openStream();
                    try {
                        MailcapFile mf = new MailcapFile(is);
                        for (String mimeType : mf.getMimeTypes()) {
                            Map<String, List<String>> map = mf.getMailcapList(mimeType);
                            if (map != null) {
                                map.values().forEach(list -> list.forEach(commands::add));
                            }
                            if ((map = mf.getMailcapFallbackList(mimeType)) == null) continue;
                            map.values().forEach(list -> list.forEach(commands::add));
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        commands.forEach(command -> {
            Class cls = access.findClassByName(command);
            if (cls != null) {
                AngusActivationFeature.log(() -> "Registering " + String.valueOf(cls));
                try {
                    RuntimeReflection.register((Class[])new Class[]{cls});
                    RuntimeReflection.register((Executable[])new Executable[]{cls.getConstructor(new Class[0])});
                }
                catch (NoSuchMethodException e) {
                    AngusActivationFeature.log(() -> "\tno constructor for " + String.valueOf(cls));
                }
            } else {
                AngusActivationFeature.log(() -> "Class for '" + command + "' not found");
            }
        });
    }

    private static boolean getOption(String name, boolean def) {
        String prop = System.getProperty(name);
        if (prop == null) {
            return def;
        }
        return Boolean.parseBoolean(name);
    }

    private static void log(Supplier<String> msg) {
        if (DEBUG) {
            System.out.println(msg.get());
        }
    }
}

