/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.glassfish.pfl.tf.spi.EnhancedClassDataBase;
import org.glassfish.pfl.tf.spi.TimingPointType;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.spi.annotation.Description;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.glassfish.pfl.tf.spi.annotation.MethodMonitorGroup;
import org.objectweb.asm.Type;

public class EnhancedClassDataReflectiveImpl
extends EnhancedClassDataBase {
    private final Class<?> currentClass;

    private boolean isMMAnnotation(Annotation an) {
        return an.annotationType().isAnnotationPresent(MethodMonitorGroup.class);
    }

    private void processClassAnnotations() {
        Annotation[] classAnnotations = this.currentClass.getAnnotations();
        if (classAnnotations != null) {
            for (Annotation an : classAnnotations) {
                String aname = Type.getInternalName(an.annotationType());
                if (!this.isMMAnnotation(an)) continue;
                this.annoNamesForClass.add(aname);
            }
            ArrayList acnames = new ArrayList(this.annoNamesForClass);
            Collections.sort(acnames);
            int ctr = 0;
            for (String aname : acnames) {
                this.annoToHolderName.put(aname, "__$mm$__" + ctr);
                ++ctr;
            }
            if (this.util.getDebug()) {
                this.util.msg("Enhancing class " + this.currentClass.getName());
                this.util.msg("\tannoNamesForClass = " + String.valueOf(this.annoNamesForClass));
                this.util.msg("\tannoToHolderName = " + String.valueOf(this.annoToHolderName));
            }
        }
    }

    private void scanMethods() {
        Method[] methods = this.currentClass.getDeclaredMethods();
        HashMap<String, Object> mmnToDescriptions = new HashMap<String, Object>();
        HashMap<String, TimingPointType> mmnToTPT = new HashMap<String, TimingPointType>();
        HashMap<String, String> mmnToTPN = new HashMap<String, String>();
        HashMap<String, String> mmnToAnnotationName = new HashMap<String, String>();
        for (Method mn : methods) {
            String mname = mn.getName();
            String mdesc = this.util.getFullMethodDescriptor(mn);
            String monitoredMethodMMAnno = null;
            String shortClassName = this.className;
            int index = shortClassName.lastIndexOf(47);
            if (index >= 0) {
                shortClassName = this.className.substring(index + 1);
            }
            Object description = "Timer for method " + mname + " in class " + shortClassName;
            TimingPointType tpt = TimingPointType.BOTH;
            String tpName = mname;
            boolean hasMethodInfoAnno = false;
            Annotation[] annotations = mn.getDeclaredAnnotations();
            if (annotations == null) continue;
            for (Annotation an : annotations) {
                String aname = Type.getInternalName(an.annotationType());
                if (aname.equals(DESCRIPTION_NAME)) {
                    Description desc = (Description)an;
                    if (desc.value().length() <= 0) continue;
                    description = desc.value();
                    continue;
                }
                if (aname.equals(INFO_METHOD_NAME)) {
                    tpt = TimingPointType.NONE;
                    if (!this.util.hasAccess(mn.getModifiers(), 2)) {
                        this.util.error("Method " + mdesc + " for Class " + this.currentClass.getName() + " is a non-private @InfoMethod, which is not allowed");
                    }
                    hasMethodInfoAnno = true;
                    InfoMethod im = (InfoMethod)an;
                    tpt = im.tpType();
                    if (tpt == TimingPointType.NONE) continue;
                    String tpn = im.tpName();
                    if (tpn.length() == 0) {
                        this.util.error("Method " + mdesc + " for Class " + this.currentClass.getName() + " is an info method with timing point type " + String.valueOf((Object)tpt) + " but no tpName was specified");
                        continue;
                    }
                    tpName = tpn;
                    continue;
                }
                if (this.annoNamesForClass.contains(aname)) {
                    if (monitoredMethodMMAnno == null) {
                        monitoredMethodMMAnno = aname;
                        continue;
                    }
                    this.util.error("Method " + mdesc + " for Class " + this.currentClass.getName() + "has multiple MM annotations");
                    continue;
                }
                if (!this.isMMAnnotation(an)) continue;
                this.util.error("Method " + mdesc + " for Class " + this.currentClass.getName() + " has an MM annotation " + String.valueOf(an) + " which is not present on its class");
            }
            if (hasMethodInfoAnno && monitoredMethodMMAnno != null) {
                this.util.error("Method " + mdesc + " for Class " + this.currentClass.getName() + " has both @InfoMethod annotation and a MM annotation");
            }
            boolean isStatic = this.util.hasAccess(mn.getModifiers(), 8);
            if (hasMethodInfoAnno && isStatic) {
                this.util.error("Method " + mdesc + " for Class " + this.currentClass.getName() + " is a static method, but must not be");
            }
            if (mname.equals("<init>")) {
                if (hasMethodInfoAnno) {
                    this.util.error("Constructors must not have an @InfoMethod annotations");
                } else if (monitoredMethodMMAnno != null) {
                    this.util.error("Constructors must not have an MM annotation");
                }
            }
            mmnToAnnotationName.put(mname, monitoredMethodMMAnno);
            if (!hasMethodInfoAnno && monitoredMethodMMAnno == null) continue;
            this.methodNames.add(mname);
            mmnToDescriptions.put(mname, description);
            mmnToTPT.put(mname, tpt);
            mmnToTPN.put(mname, tpName);
            if (hasMethodInfoAnno) {
                this.infoMethodDescs.add(mdesc);
                continue;
            }
            this.mmMethodDescs.add(mdesc);
            this.methodToAnno.put(mdesc, monitoredMethodMMAnno);
        }
        Collections.sort(this.methodNames);
        for (String str : this.methodNames) {
            this.methodDescriptions.add((String)mmnToDescriptions.get(str));
            this.methodTPTs.add((TimingPointType)((Object)mmnToTPT.get(str)));
            this.methodTPNames.add((String)mmnToTPN.get(str));
            this.methodAnnoList.add((String)mmnToAnnotationName.get(str));
        }
        if (this.util.getDebug()) {
            this.util.msg("\tinfoMethodSignature = " + String.valueOf(this.infoMethodDescs));
            this.util.msg("\tmmMethodSignature = " + String.valueOf(this.mmMethodDescs));
            this.util.msg("\tmethodNames = " + String.valueOf(this.methodNames));
            this.util.msg("\tmethodToAnno = " + String.valueOf(this.methodToAnno));
            this.util.msg("\tmethodDescriptions = " + String.valueOf(this.methodDescriptions));
            this.util.msg("\tmethodTPTs = " + String.valueOf(this.methodTPTs));
            this.util.msg("\tmethodTPTs = " + String.valueOf(this.methodTPNames));
        }
    }

    public EnhancedClassDataReflectiveImpl(Util util, Class<?> cn) {
        super(util, null);
        this.currentClass = cn;
        this.className = cn.getName();
        this.processClassAnnotations();
        this.scanMethods();
    }
}

