/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import org.glassfish.pfl.tf.timer.spi.Timer;

public class TimerEvent {
    private Timer timer;
    private TimerEventType etype;
    private long time;

    public String toString() {
        return "TimerEvent[" + String.valueOf((Object)this.etype) + " " + this.timer.name() + "@" + this.time / 1000L + "]";
    }

    public TimerEvent(TimerEvent te) {
        this(te.timer(), te.type());
        this.time = te.time();
    }

    public TimerEvent(Timer timer, TimerEventType etype) {
        long time = System.nanoTime();
        this.internalSetData(timer, etype, time);
    }

    public TimerEvent(Timer timer, TimerEventType etype, long time) {
        this.internalSetData(timer, etype, time);
    }

    public void update(Timer timer, TimerEventType etype, long time) {
        this.internalSetData(timer, etype, time);
    }

    private void internalSetData(Timer timer, TimerEventType etype, long time) {
        this.timer = timer;
        this.etype = etype;
        this.time = time;
    }

    public void incrementTime(long update) {
        this.time += update;
    }

    public Timer timer() {
        return this.timer;
    }

    public TimerEventType type() {
        return this.etype;
    }

    public long time() {
        return this.time;
    }

    public static enum TimerEventType {
        ENTER,
        EXIT;

    }
}

