/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal.index.modules;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.reachability.internal.UncheckedIOException;
import org.graalvm.reachability.internal.index.modules.ModuleEntry;
import org.graalvm.reachability.internal.index.modules.ModuleToConfigDirectoryIndex;

public class JsonModuleToConfigDirectoryIndex
implements ModuleToConfigDirectoryIndex {
    private final Path rootPath;
    private final Map<String, Set<Path>> index;

    public JsonModuleToConfigDirectoryIndex(Path rootPath) {
        this.rootPath = rootPath;
        this.index = this.parseIndexFile(rootPath);
    }

    private Map<String, Set<Path>> parseIndexFile(Path rootPath) {
        Path indexFile = rootPath.resolve("index.json");
        try {
            String fileContent = Files.readString(indexFile);
            JSONArray json = new JSONArray(fileContent);
            ArrayList<ModuleEntry> entries = new ArrayList<ModuleEntry>();
            for (int i = 0; i < json.length(); ++i) {
                entries.add(this.fromJson(json.getJSONObject(i)));
            }
            Map<String, List<ModuleEntry>> moduleToEntries = entries.stream().collect(Collectors.groupingBy(ModuleEntry::getModule));
            HashMap<String, Set<Path>> index = new HashMap<String, Set<Path>>(moduleToEntries.size());
            for (Map.Entry<String, List<ModuleEntry>> entry : moduleToEntries.entrySet()) {
                String key = entry.getKey();
                Set dirs = entry.getValue().stream().flatMap(module -> Stream.concat(Stream.of(module.getModuleDirectory()), module.getRequires().stream().flatMap(e -> {
                    List moduleEntries = (List)moduleToEntries.get(e);
                    if (moduleEntries == null) {
                        throw new IllegalStateException("Module " + module.getModule() + " requires module " + e + " which is not found in index");
                    }
                    return moduleEntries.stream().map(ModuleEntry::getModuleDirectory);
                }))).filter(Objects::nonNull).map(rootPath::resolve).collect(Collectors.toSet());
                index.put(key, dirs);
            }
            return index;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ModuleEntry fromJson(JSONObject json) {
        String module = json.optString("module", null);
        String moduleDirectory = json.optString("directory", null);
        List<String> requires = this.readRequires(json.optJSONArray("requires"));
        return new ModuleEntry(module, moduleDirectory, requires);
    }

    private List<String> readRequires(JSONArray array) {
        ArrayList<String> requires = new ArrayList<String>();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                requires.add(array.getString(i));
            }
        }
        return requires;
    }

    @Override
    public Set<Path> findConfigurationDirectories(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        if (!this.index.containsKey(key)) {
            return Collections.emptySet();
        }
        return this.index.get(key);
    }
}

