/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.DefaultArtifactQuery;

public class DefaultQuery
implements Query {
    private boolean useLatest = false;
    private final List<Consumer<? super Query.ArtifactQuery>> artifactsQueries = new ArrayList<Consumer<? super Query.ArtifactQuery>>();

    @Override
    public void forArtifacts(String ... gavCoordinates) {
        for (String coordinates : gavCoordinates) {
            this.forArtifact(q -> q.gav(coordinates));
        }
    }

    @Override
    public void forArtifact(Consumer<? super Query.ArtifactQuery> config) {
        this.artifactsQueries.add(config);
    }

    @Override
    public void useLatestConfigWhenVersionIsUntested() {
        this.useLatest = true;
    }

    List<DefaultArtifactQuery> getArtifacts() {
        return this.artifactsQueries.stream().map(spec -> {
            DefaultArtifactQuery query = new DefaultArtifactQuery();
            if (this.useLatest) {
                query.useLatestConfigWhenVersionIsUntested();
            }
            spec.accept(query);
            return query;
        }).collect(Collectors.toList());
    }
}

