/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graalvm.reachability.DirectoryConfiguration;
import org.graalvm.reachability.GraalVMReachabilityMetadataRepository;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.DefaultQuery;
import org.graalvm.reachability.internal.index.artifacts.SingleModuleJsonVersionToConfigDirectoryIndex;
import org.graalvm.reachability.internal.index.artifacts.VersionToConfigDirectoryIndex;
import org.graalvm.reachability.internal.index.modules.FileSystemModuleToConfigDirectoryIndex;

public class FileSystemRepository
implements GraalVMReachabilityMetadataRepository {
    private final FileSystemModuleToConfigDirectoryIndex moduleIndex;
    private final Logger logger;
    private final Map<Path, VersionToConfigDirectoryIndex> artifactIndexes;
    private final Path rootDirectory;
    private static final String[] SUPPORTED_FORMATS = new String[]{".zip", ".tar.gz", ".tar.bz2"};

    public FileSystemRepository(Path rootDirectory) {
        this(rootDirectory, new Logger(){});
    }

    public FileSystemRepository(Path rootDirectory, Logger logger) {
        this.moduleIndex = new FileSystemModuleToConfigDirectoryIndex(rootDirectory);
        this.logger = logger;
        this.artifactIndexes = new ConcurrentHashMap<Path, VersionToConfigDirectoryIndex>();
        this.rootDirectory = rootDirectory;
    }

    public static String getArchiveFormat(String path) {
        String normalizedPath = path.toLowerCase();
        for (String format : SUPPORTED_FORMATS) {
            if (!normalizedPath.endsWith(format)) continue;
            return format;
        }
        return null;
    }

    public static boolean isSupportedArchiveFormat(String path) {
        return FileSystemRepository.getArchiveFormat(path) != null;
    }

    @Override
    public Set<DirectoryConfiguration> findConfigurationsFor(Consumer<? super Query> queryBuilder) {
        DefaultQuery query = new DefaultQuery();
        queryBuilder.accept(query);
        return query.getArtifacts().stream().flatMap(artifactQuery -> {
            String groupId = artifactQuery.getGroupId();
            String artifactId = artifactQuery.getArtifactId();
            String version = artifactQuery.getVersion();
            return this.moduleIndex.findConfigurationDirectories(groupId, artifactId).stream().map(dir -> {
                VersionToConfigDirectoryIndex index = this.artifactIndexes.computeIfAbsent((Path)dir, SingleModuleJsonVersionToConfigDirectoryIndex::new);
                if (artifactQuery.getForcedConfig().isPresent()) {
                    String configVersion = artifactQuery.getForcedConfig().get();
                    this.logger.log(groupId, artifactId, version, "Configuration is forced to version " + configVersion);
                    return index.findConfiguration(groupId, artifactId, configVersion);
                }
                Optional<DirectoryConfiguration> configuration = index.findConfiguration(groupId, artifactId, version);
                if (!configuration.isPresent() && artifactQuery.isUseLatestVersion()) {
                    this.logger.log(groupId, artifactId, version, "Configuration directory not found. Trying latest version.");
                    configuration = index.findLatestConfigurationFor(groupId, artifactId, version);
                    if (!configuration.isPresent()) {
                        this.logger.log(groupId, artifactId, version, "Latest version not found!");
                    }
                }
                Optional<DirectoryConfiguration> finalConfigurationDirectory = configuration;
                this.logger.log(groupId, artifactId, version, () -> {
                    if (finalConfigurationDirectory.isPresent()) {
                        Path path = ((DirectoryConfiguration)finalConfigurationDirectory.get()).getDirectory();
                        return "Configuration directory is " + String.valueOf(this.rootDirectory.relativize(path));
                    }
                    return "missing.";
                });
                return configuration;
            }).filter(Optional::isPresent).map(Optional::get);
        }).collect(Collectors.toSet());
    }

    public static interface Logger {
        default public void log(String groupId, String artifactId, String version, String message) {
            this.log(groupId, artifactId, version, () -> message);
        }

        default public void log(String groupId, String artifactId, String version, Supplier<String> message) {
        }
    }
}

