/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.util.List;

public abstract class JUnitPlatformNativeDependenciesHelper {
    private static final DependencyNotation JUNIT_PLATFORM_LAUNCHER = new DependencyNotation("org.junit.platform", "junit-platform-launcher", "");
    private static final DependencyNotation JUNIT_PLATFORM_ENGINE = new DependencyNotation("org.junit.platform", "junit-platform-engine", "");
    private static final DependencyNotation JUNIT_PLATFORM_CONSOLE = new DependencyNotation("org.junit.platform", "junit-platform-console", "");
    private static final DependencyNotation JUNIT_PLATFORM_REPORTING = new DependencyNotation("org.junit.platform", "junit-platform-reporting", "");
    private static final List<DependencyNotation> JUNIT_PLATFORM_DEPENDENCIES = List.of(JUNIT_PLATFORM_LAUNCHER, JUNIT_PLATFORM_CONSOLE, JUNIT_PLATFORM_REPORTING);

    private JUnitPlatformNativeDependenciesHelper() {
    }

    public static List<DependencyNotation> inferMissingDependenciesForTestRuntime(List<DependencyNotation> input) {
        String junitPlatformVersion = input.stream().filter(d -> d.equalsIgnoreVersion(JUNIT_PLATFORM_ENGINE)).findFirst().map(DependencyNotation::version).orElse("");
        List<DependencyNotation> list = JUNIT_PLATFORM_DEPENDENCIES.stream().filter(d -> input.stream().noneMatch(o -> o.equalsIgnoreVersion((DependencyNotation)d))).map(d -> d.withVersion(junitPlatformVersion)).toList();
        return list;
    }

    public record DependencyNotation(String groupId, String artifactId, String version) {
        public boolean equalsIgnoreVersion(DependencyNotation other) {
            return other.groupId.equals(this.groupId) && other.artifactId.equals(this.artifactId);
        }

        public DependencyNotation withVersion(String version) {
            return new DependencyNotation(this.groupId, this.artifactId, version);
        }
    }
}

