// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Debug Info: <pre>
 *   Specialization {@link FloorNode#floorInt}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link FloorNode#floorSafeInt}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link FloorNode#floorDouble}
 *     Activation probability: 0.20500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link FloorNode#floorToDouble}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(FloorNode.class)
@SuppressWarnings("javadoc")
public final class FloorNodeGen extends FloorNode implements Introspection.Provider {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link FloorNode#floorDouble}
     *   Parameter: {@link InlinedConditionProfile} isZero
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_IS_ZERO = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(7, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link FloorNode#floorDouble}
     *   Parameter: {@link InlinedConditionProfile} fitsInt
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_FITS_INT = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(9, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link FloorNode#floorDouble}
     *   Parameter: {@link InlinedConditionProfile} fitsSafeLong
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_FITS_SAFE_LONG = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(11, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link FloorNode#floorDouble}
     *   Parameter: {@link InlinedConditionProfile} smaller
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_SMALLER = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(13, 2)));

    @Child private JavaScriptNode arguments0_;
    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link FloorNode#floorInt}
     *   1: SpecializationActive {@link FloorNode#floorSafeInt}
     *   2: SpecializationActive {@link FloorNode#floorDouble}
     *   3: SpecializationActive {@link FloorNode#floorToDouble}
     *   4-6: ImplicitCast[type=double, index=0]
     *   7-8: InlinedCache
     *        Specialization: {@link FloorNode#floorDouble}
     *        Parameter: {@link InlinedConditionProfile} isZero
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   9-10: InlinedCache
     *        Specialization: {@link FloorNode#floorDouble}
     *        Parameter: {@link InlinedConditionProfile} fitsInt
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   11-12: InlinedCache
     *        Specialization: {@link FloorNode#floorDouble}
     *        Parameter: {@link InlinedConditionProfile} fitsSafeLong
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   13-14: InlinedCache
     *        Specialization: {@link FloorNode#floorDouble}
     *        Parameter: {@link InlinedConditionProfile} smaller
     *        Inline method: {@link InlinedConditionProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;

    private FloorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[FloorNode.floorInt(int)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[FloorNode.floorInt(int)] && SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] && SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b1011) == 0 /* only-active SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[FloorNode.floorInt(int)] && SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] && SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[FloorNode.floorInt(int)] */;
        return FloorNode.floorInt(arguments0Value_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b1100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[FloorNode.floorInt(int)] && SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] && SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[FloorNode.floorInt(int)] && SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] && SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
        return floorDouble(arguments0Value_, INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b1111) != 0 /* is SpecializationActive[FloorNode.floorInt(int)] || SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] || SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[FloorNode.floorInt(int)] */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return FloorNode.floorInt(arguments0Value__);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] */ && arguments0Value_ instanceof SafeInteger) {
                SafeInteger arguments0Value__ = (SafeInteger) arguments0Value_;
                return FloorNode.floorSafeInt(arguments0Value__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return floorDouble(arguments0Value__, INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                return floorToDouble(arguments0Value_, INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1100) != 0 /* is SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[FloorNode.floorInt(int)] */) {
            return FloorNode.floorInt(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[FloorNode.floorInt(int)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[FloorNode.floorInt(int)] && SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] && SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
                executeInt(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        if (arguments0Value instanceof Integer) {
            int arguments0Value_ = (int) arguments0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[FloorNode.floorInt(int)] */;
            this.state_0_ = state_0;
            return FloorNode.floorInt(arguments0Value_);
        }
        if (arguments0Value instanceof SafeInteger) {
            SafeInteger arguments0Value_ = (SafeInteger) arguments0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] */;
            this.state_0_ = state_0;
            return FloorNode.floorSafeInt(arguments0Value_);
        }
        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state_0 = (state_0 | (doubleCast0 << 4) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100 /* add SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_ = state_0;
                return floorDouble(arguments0Value_, INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER);
            }
        }
        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
        state_0 = state_0 | 0b1000 /* add SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
        this.state_0_ = state_0;
        return floorToDouble(arguments0Value, INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1111) & ((state_0 & 0b1111) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "floorInt";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[FloorNode.floorInt(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "floorSafeInt";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[FloorNode.floorSafeInt(SafeInteger)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "floorDouble";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[FloorNode.floorDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList(INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER));
            s[2] = cached;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "floorToDouble";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[FloorNode.floorToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList(INLINED_IS_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG, INLINED_SMALLER));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static FloorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new FloorNodeGen(context, builtin, arguments);
    }

}
