/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class MinNode
extends MathOperation {
    public MinNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    private static double minDoubleDouble(double a, double b, Node node, InlinedConditionProfile leftSmaller, InlinedConditionProfile rightSmaller, InlinedConditionProfile bothEqual, InlinedConditionProfile negativeZero) {
        if (leftSmaller.profile(node, a < b)) {
            return a;
        }
        if (rightSmaller.profile(node, b < a)) {
            return b;
        }
        if (bothEqual.profile(node, a == b)) {
            if (negativeZero.profile(node, JSRuntime.isNegativeZero(b))) {
                return b;
            }
            return a;
        }
        return Double.NaN;
    }

    protected static boolean caseIntInt(Object[] args) {
        assert (args.length == 2);
        return args[0] instanceof Integer && args[1] instanceof Integer;
    }

    @Specialization(guards={"args.length == 0"})
    protected static double min0Param(Object[] args) {
        return Double.POSITIVE_INFINITY;
    }

    @Specialization(guards={"args.length == 1"})
    protected double min1Param(Object[] args) {
        return this.toDouble(args[0]);
    }

    @Specialization(guards={"args.length == 2", "caseIntInt(args)"})
    protected int min2ParamInt(Object[] args, @Cached @Cached.Shared(value="minProfile") InlinedConditionProfile minProfile) {
        int i1 = (Integer)args[0];
        int i2 = (Integer)args[1];
        return MinNode.min(i1, i2, this, minProfile);
    }

    @Specialization(guards={"args.length == 2", "!caseIntInt(args)"})
    protected static Object min2Param(Object[] args, @Bind(value="this") Node node, @Cached @Cached.Exclusive InlinedConditionProfile isIntBranch, @Cached @Cached.Shared(value="minProfile") InlinedConditionProfile minProfile, @Cached JSToNumberNode toNumber1Node, @Cached JSToNumberNode toNumber2Node, @Cached @Cached.Shared(value="leftSmaller") InlinedConditionProfile leftSmaller, @Cached @Cached.Shared(value="rightSmaller") InlinedConditionProfile rightSmaller, @Cached @Cached.Shared(value="bothEqual") InlinedConditionProfile bothEqual, @Cached @Cached.Shared(value="negativeZero") InlinedConditionProfile negativeZero) {
        Number n1 = toNumber1Node.executeNumber(args[0]);
        Number n2 = toNumber2Node.executeNumber(args[1]);
        if (isIntBranch.profile(node, n1 instanceof Integer && n2 instanceof Integer)) {
            return MinNode.min((Integer)n1, (Integer)n2, node, minProfile);
        }
        double d1 = JSRuntime.doubleValue(n1);
        double d2 = JSRuntime.doubleValue(n2);
        return MinNode.minDoubleDouble(d1, d2, node, leftSmaller, rightSmaller, bothEqual, negativeZero);
    }

    protected static boolean caseIntIntInt(Object[] args) {
        assert (args.length == 3);
        return args[0] instanceof Integer && args[1] instanceof Integer && args[2] instanceof Integer;
    }

    @Specialization(guards={"args.length == 3", "caseIntIntInt(args)"})
    protected int min3ParamInt(Object[] args) {
        return Math.min(Math.min((Integer)args[0], (Integer)args[1]), (Integer)args[2]);
    }

    @Specialization(guards={"args.length == 3", "!caseIntIntInt(args)"})
    protected double min3ParamOther(Object[] args, @Cached @Cached.Shared(value="leftSmaller") InlinedConditionProfile leftSmaller, @Cached @Cached.Shared(value="rightSmaller") InlinedConditionProfile rightSmaller, @Cached @Cached.Shared(value="bothEqual") InlinedConditionProfile bothEqual, @Cached @Cached.Shared(value="negativeZero") InlinedConditionProfile negativeZero) {
        double smallest = MinNode.minDoubleDouble(this.toDouble(args[0]), this.toDouble(args[1]), this, leftSmaller, rightSmaller, bothEqual, negativeZero);
        return MinNode.minDoubleDouble(smallest, this.toDouble(args[2]), this, leftSmaller, rightSmaller, bothEqual, negativeZero);
    }

    @Specialization(guards={"args.length >= 4"})
    protected double minGeneric(Object[] args, @Cached @Cached.Shared(value="leftSmaller") InlinedConditionProfile leftSmaller, @Cached @Cached.Shared(value="rightSmaller") InlinedConditionProfile rightSmaller, @Cached @Cached.Shared(value="bothEqual") InlinedConditionProfile bothEqual, @Cached @Cached.Shared(value="negativeZero") InlinedConditionProfile negativeZero) {
        double smallest = MinNode.minDoubleDouble(this.toDouble(args[0]), this.toDouble(args[1]), this, leftSmaller, rightSmaller, bothEqual, negativeZero);
        for (int i = 2; i < args.length; ++i) {
            smallest = MinNode.minDoubleDouble(smallest, this.toDouble(args[i]), this, leftSmaller, rightSmaller, bothEqual, negativeZero);
        }
        return smallest;
    }

    private static int min(int a, int b, Node node, InlinedConditionProfile minProfile) {
        return minProfile.profile(node, a <= b) ? a : b;
    }
}

