/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.SetPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSSetObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class JSSet
extends JSNonProxy
implements JSConstructorFactory.Default.WithSpecies,
PrototypeSupplier {
    public static final JSSet INSTANCE = new JSSet();
    public static final TruffleString CLASS_NAME = Strings.constant("Set");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Set.prototype");

    private JSSet() {
    }

    public static JSSetObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getSetFactory();
        return JSSet.create(factory, realm, factory.getPrototype(realm));
    }

    public static JSSetObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        JSObjectFactory factory = context.getSetFactory();
        return JSSet.create(factory, realm, proto);
    }

    private static JSSetObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto) {
        JSHashMap internalMap = new JSHashMap();
        Shape shape = factory.getShape(realm, proto);
        JSSetObject newObj = factory.initProto(new JSSetObject(shape, proto, internalMap), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static Object normalize(Object value) {
        if (value instanceof Double) {
            return JSSet.normalizeDouble((Double)value);
        }
        return value;
    }

    public static Object normalizeDouble(double value) {
        if (JSRuntime.isNegativeZero(value)) {
            return 0;
        }
        if (JSRuntime.doubleIsRepresentableAsInt(value)) {
            return (int)value;
        }
        return value;
    }

    public static JSHashMap getInternalSet(JSDynamicObject obj) {
        assert (JSSet.isJSSet((Object)obj));
        return ((JSSetObject)obj).getMap();
    }

    public static int getSetSize(JSDynamicObject obj) {
        assert (JSSet.isJSSet((Object)obj));
        return JSSet.getInternalSet(obj).size();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSContext ctx = realm.getContext();
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, SetPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SetPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        Object values = JSDynamicObject.getOrNull(prototype, Strings.VALUES);
        JSObjectUtil.putDataProperty(prototype, Strings.KEYS, values, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(prototype, Symbol.SYMBOL_ITERATOR, values, JSAttributes.getDefaultNotEnumerable());
        if (ctx.getLanguageOptions().newSetMethods()) {
            JSObjectUtil.putFunctionsFromContainer(realm, prototype, SetPrototypeBuiltins.NEW_SET_BUILTINS);
        }
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.concatAll(Strings.BRACKET_OPEN, this.getClassName(), Strings.BRACKET_CLOSE);
        }
        JSHashMap set = JSSet.getInternalSet(obj);
        return JSRuntime.collectionToConsoleString(obj, allowSideEffects, format, this.getClassName(obj), set, depth);
    }

    public static boolean isJSSet(Object obj) {
        return obj instanceof JSSetObject;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSetPrototype();
    }
}

