// CheckStyle: start generated
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.builtins.NumberFunctionBuiltins.JSNumberIsFiniteNode;
import com.oracle.truffle.js.builtins.NumberFunctionBuiltins.JSNumberIsIntegerNode;
import com.oracle.truffle.js.builtins.NumberFunctionBuiltins.JSNumberIsNaNNode;
import com.oracle.truffle.js.builtins.NumberFunctionBuiltins.JSNumberIsSafeIntegerNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;

@GeneratedBy(NumberFunctionBuiltins.class)
@SuppressWarnings("javadoc")
public final class NumberFunctionBuiltinsFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link JSNumberIsNaNNode#isNaNNotDouble}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link JSNumberIsNaNNode#isNaNDouble}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(JSNumberIsNaNNode.class)
    @SuppressWarnings("javadoc")
    public static final class JSNumberIsNaNNodeGen extends JSNumberIsNaNNode implements Introspection.Provider {

        @Child private JavaScriptNode arguments0_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSNumberIsNaNNode#isNaNNotDouble}
         *   1: SpecializationActive {@link JSNumberIsNaNNode#isNaNDouble}
         *   2-4: ImplicitCast[type=double, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private JSNumberIsNaNNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */)) {
                return execute_double0(state_0, frameValue);
            } else {
                return execute_generic1(state_0, frameValue);
            }
        }

        private Object execute_double0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b11000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b10100) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */;
            return isNaNDouble(arguments0Value_);
        }

        private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] */) {
                    if ((!(isDouble(arguments0Value_)))) {
                        return isNaNNotDouble(arguments0Value_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return isNaNDouble(arguments0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */)) {
                return executeBoolean_double2(state_0, frameValue);
            } else {
                return executeBoolean_generic3(state_0, frameValue);
            }
        }

        private boolean executeBoolean_double2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b11000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b10100) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */;
            return isNaNDouble(arguments0Value_);
        }

        private boolean executeBoolean_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] */) {
                    if ((!(isDouble(arguments0Value_)))) {
                        return isNaNNotDouble(arguments0Value_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return isNaNDouble(arguments0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if ((!(isDouble(arguments0Value)))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] */;
                this.state_0_ = state_0;
                return isNaNNotDouble(arguments0Value);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                    double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                    state_0 = (state_0 | (doubleCast0 << 2) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */;
                    this.state_0_ = state_0;
                    return isNaNDouble(arguments0Value_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            Object[] s;
            data[0] = 0;
            int state_0 = this.state_0_;
            s = new Object[3];
            s[0] = "isNaNNotDouble";
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNNotDouble(Object)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isNaNDouble";
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsNaNNode.isNaNDouble(double)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            return Provider.create(data);
        }

        @NeverDefault
        public static JSNumberIsNaNNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsNaNNodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link JSNumberIsFiniteNode#isFinite(int)}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link JSNumberIsFiniteNode#isFinite(long)}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link JSNumberIsFiniteNode#isFinite(double)}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link JSNumberIsFiniteNode#isFinite(Object)}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(JSNumberIsFiniteNode.class)
    @SuppressWarnings("javadoc")
    public static final class JSNumberIsFiniteNodeGen extends JSNumberIsFiniteNode implements Introspection.Provider {

        @Child private JavaScriptNode arguments0_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSNumberIsFiniteNode#isFinite(int)}
         *   1: SpecializationActive {@link JSNumberIsFiniteNode#isFinite(long)}
         *   2: SpecializationActive {@link JSNumberIsFiniteNode#isFinite(double)}
         *   3: SpecializationActive {@link JSNumberIsFiniteNode#isFinite(Object)}
         *   4-6: ImplicitCast[type=double, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private JSNumberIsFiniteNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                return execute_int0(state_0, frameValue);
            } else if ((state_0 & 0b1101) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                return execute_long1(state_0, frameValue);
            } else if ((state_0 & 0b1011) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                return execute_double2(state_0, frameValue);
            } else {
                return execute_generic3(state_0, frameValue);
            }
        }

        private Object execute_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */;
            return isFinite(arguments0Value_);
        }

        private Object execute_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */;
            return isFinite(arguments0Value_);
        }

        private Object execute_double2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b1100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b1010000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */;
            return isFinite(arguments0Value_);
        }

        private Object execute_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b1111) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    return isFinite(arguments0Value__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */ && arguments0Value_ instanceof Long) {
                    long arguments0Value__ = (long) arguments0Value_;
                    return isFinite(arguments0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return isFinite(arguments0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */) {
                    if ((!(JSGuards.isNumber(arguments0Value_))) && (!(JSGuards.isNumberLong(arguments0Value_)))) {
                        return isFinite(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                return executeBoolean_int4(state_0, frameValue);
            } else if ((state_0 & 0b1101) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                return executeBoolean_long5(state_0, frameValue);
            } else if ((state_0 & 0b1011) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                return executeBoolean_double6(state_0, frameValue);
            } else {
                return executeBoolean_generic7(state_0, frameValue);
            }
        }

        private boolean executeBoolean_int4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */;
            return isFinite(arguments0Value_);
        }

        private boolean executeBoolean_long5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */;
            return isFinite(arguments0Value_);
        }

        private boolean executeBoolean_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b1100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b1010000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */;
            return isFinite(arguments0Value_);
        }

        private boolean executeBoolean_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b1111) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    return isFinite(arguments0Value__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */ && arguments0Value_ instanceof Long) {
                    long arguments0Value__ = (long) arguments0Value_;
                    return isFinite(arguments0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return isFinite(arguments0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */) {
                    if ((!(JSGuards.isNumber(arguments0Value_))) && (!(JSGuards.isNumberLong(arguments0Value_)))) {
                        return isFinite(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (int) arguments0Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */;
                this.state_0_ = state_0;
                return isFinite(arguments0Value_);
            }
            if (arguments0Value instanceof Long) {
                long arguments0Value_ = (long) arguments0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */;
                this.state_0_ = state_0;
                return isFinite(arguments0Value_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                    double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                    state_0 = (state_0 | (doubleCast0 << 4) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */;
                    this.state_0_ = state_0;
                    return isFinite(arguments0Value_);
                }
            }
            if ((!(JSGuards.isNumber(arguments0Value))) && (!(JSGuards.isNumberLong(arguments0Value)))) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */;
                this.state_0_ = state_0;
                return isFinite(arguments0Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b1111) & ((state_0 & 0b1111) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state_0 = this.state_0_;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(int)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(long)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(double)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsFiniteNode.isFinite(Object)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        @NeverDefault
        public static JSNumberIsFiniteNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsFiniteNodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link JSNumberIsIntegerNode#isInteger(int)}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link JSNumberIsIntegerNode#isInteger(long)}
     *     Activation probability: 0.26000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link JSNumberIsIntegerNode#isInteger(SafeInteger)}
     *     Activation probability: 0.20000
     *     With/without class size: 6/0 bytes
     *   Specialization {@link JSNumberIsIntegerNode#isInteger(double)}
     *     Activation probability: 0.14000
     *     With/without class size: 5/0 bytes
     *   Specialization {@link JSNumberIsIntegerNode#isInteger(Object)}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(JSNumberIsIntegerNode.class)
    @SuppressWarnings("javadoc")
    public static final class JSNumberIsIntegerNodeGen extends JSNumberIsIntegerNode implements Introspection.Provider {

        @Child private JavaScriptNode arguments0_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSNumberIsIntegerNode#isInteger(int)}
         *   1: SpecializationActive {@link JSNumberIsIntegerNode#isInteger(long)}
         *   2: SpecializationActive {@link JSNumberIsIntegerNode#isInteger(SafeInteger)}
         *   3: SpecializationActive {@link JSNumberIsIntegerNode#isInteger(double)}
         *   4: SpecializationActive {@link JSNumberIsIntegerNode#isInteger(Object)}
         *   5-7: ImplicitCast[type=double, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private JSNumberIsIntegerNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                return execute_int0(state_0, frameValue);
            } else if ((state_0 & 0b11101) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                return execute_long1(state_0, frameValue);
            } else if ((state_0 & 0b10111) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                return execute_double2(state_0, frameValue);
            } else {
                return execute_generic3(state_0, frameValue);
            }
        }

        private Object execute_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */;
            return JSNumberIsIntegerNode.isInteger(arguments0Value_);
        }

        private Object execute_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */;
            return JSNumberIsIntegerNode.isInteger(arguments0Value_);
        }

        private Object execute_double2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */;
            return JSNumberIsIntegerNode.isInteger(arguments0Value_);
        }

        private Object execute_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b11111) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */ && arguments0Value_ instanceof Long) {
                    long arguments0Value__ = (long) arguments0Value_;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] */ && arguments0Value_ instanceof SafeInteger) {
                    SafeInteger arguments0Value__ = (SafeInteger) arguments0Value_;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */) {
                    if ((!(JSGuards.isNumber(arguments0Value_))) && (!(JSGuards.isNumberLong(arguments0Value_)))) {
                        return JSNumberIsIntegerNode.isInteger(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                return executeBoolean_int4(state_0, frameValue);
            } else if ((state_0 & 0b11101) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                return executeBoolean_long5(state_0, frameValue);
            } else if ((state_0 & 0b10111) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                return executeBoolean_double6(state_0, frameValue);
            } else {
                return executeBoolean_generic7(state_0, frameValue);
            }
        }

        private boolean executeBoolean_int4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */;
            return JSNumberIsIntegerNode.isInteger(arguments0Value_);
        }

        private boolean executeBoolean_long5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */;
            return JSNumberIsIntegerNode.isInteger(arguments0Value_);
        }

        private boolean executeBoolean_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */;
            return JSNumberIsIntegerNode.isInteger(arguments0Value_);
        }

        private boolean executeBoolean_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b11111) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */ && arguments0Value_ instanceof Long) {
                    long arguments0Value__ = (long) arguments0Value_;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] */ && arguments0Value_ instanceof SafeInteger) {
                    SafeInteger arguments0Value__ = (SafeInteger) arguments0Value_;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return JSNumberIsIntegerNode.isInteger(arguments0Value__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */) {
                    if ((!(JSGuards.isNumber(arguments0Value_))) && (!(JSGuards.isNumberLong(arguments0Value_)))) {
                        return JSNumberIsIntegerNode.isInteger(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (int) arguments0Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */;
                this.state_0_ = state_0;
                return JSNumberIsIntegerNode.isInteger(arguments0Value_);
            }
            if (arguments0Value instanceof Long) {
                long arguments0Value_ = (long) arguments0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */;
                this.state_0_ = state_0;
                return JSNumberIsIntegerNode.isInteger(arguments0Value_);
            }
            if (arguments0Value instanceof SafeInteger) {
                SafeInteger arguments0Value_ = (SafeInteger) arguments0Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] */;
                this.state_0_ = state_0;
                return JSNumberIsIntegerNode.isInteger(arguments0Value_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                    double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                    state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */;
                    this.state_0_ = state_0;
                    return JSNumberIsIntegerNode.isInteger(arguments0Value_);
                }
            }
            if ((!(JSGuards.isNumber(arguments0Value))) && (!(JSGuards.isNumberLong(arguments0Value)))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */;
                this.state_0_ = state_0;
                return JSNumberIsIntegerNode.isInteger(arguments0Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            Object[] s;
            data[0] = 0;
            int state_0 = this.state_0_;
            s = new Object[3];
            s[0] = "isInteger";
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(int)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isInteger";
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(long)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isInteger";
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(SafeInteger)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isInteger";
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(double)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "isInteger";
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsIntegerNode.isInteger(Object)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            return Provider.create(data);
        }

        @NeverDefault
        public static JSNumberIsIntegerNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsIntegerNodeGen(context, builtin, arguments);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link JSNumberIsSafeIntegerNode#isSafeIntegerInt}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link JSNumberIsSafeIntegerNode#isSafeIntegerLong}
     *     Activation probability: 0.26000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link JSNumberIsSafeIntegerNode#isSafeIntegerSafeInteger}
     *     Activation probability: 0.20000
     *     With/without class size: 6/0 bytes
     *   Specialization {@link JSNumberIsSafeIntegerNode#isSafeIntegerDouble}
     *     Activation probability: 0.14000
     *     With/without class size: 5/0 bytes
     *   Specialization {@link JSNumberIsSafeIntegerNode#isSafeIntegerNotANumber}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(JSNumberIsSafeIntegerNode.class)
    @SuppressWarnings("javadoc")
    public static final class JSNumberIsSafeIntegerNodeGen extends JSNumberIsSafeIntegerNode implements Introspection.Provider {

        @Child private JavaScriptNode arguments0_;
        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSNumberIsSafeIntegerNode#isSafeIntegerInt}
         *   1: SpecializationActive {@link JSNumberIsSafeIntegerNode#isSafeIntegerLong}
         *   2: SpecializationActive {@link JSNumberIsSafeIntegerNode#isSafeIntegerSafeInteger}
         *   3: SpecializationActive {@link JSNumberIsSafeIntegerNode#isSafeIntegerDouble}
         *   4: SpecializationActive {@link JSNumberIsSafeIntegerNode#isSafeIntegerNotANumber}
         *   5-7: ImplicitCast[type=double, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private JSNumberIsSafeIntegerNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                return execute_int0(state_0, frameValue);
            } else if ((state_0 & 0b11101) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                return execute_long1(state_0, frameValue);
            } else if ((state_0 & 0b10111) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                return execute_double2(state_0, frameValue);
            } else {
                return execute_generic3(state_0, frameValue);
            }
        }

        private Object execute_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */;
            return isSafeIntegerInt(arguments0Value_);
        }

        private Object execute_long1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */;
            return isSafeIntegerLong(arguments0Value_);
        }

        private Object execute_double2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */;
            return isSafeIntegerDouble(arguments0Value_);
        }

        private Object execute_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b11111) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    return isSafeIntegerInt(arguments0Value__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */ && arguments0Value_ instanceof Long) {
                    long arguments0Value__ = (long) arguments0Value_;
                    return isSafeIntegerLong(arguments0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] */ && arguments0Value_ instanceof SafeInteger) {
                    SafeInteger arguments0Value__ = (SafeInteger) arguments0Value_;
                    return isSafeIntegerSafeInteger(arguments0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return isSafeIntegerDouble(arguments0Value__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */) {
                    if ((!(JSGuards.isNumber(arguments0Value_))) && (!(JSGuards.isNumberLong(arguments0Value_)))) {
                        return isSafeIntegerNotANumber(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                return executeBoolean_int4(state_0, frameValue);
            } else if ((state_0 & 0b11101) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                return executeBoolean_long5(state_0, frameValue);
            } else if ((state_0 & 0b10111) == 0 /* only-active SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                return executeBoolean_double6(state_0, frameValue);
            } else {
                return executeBoolean_generic7(state_0, frameValue);
            }
        }

        private boolean executeBoolean_int4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */;
            return isSafeIntegerInt(arguments0Value_);
        }

        private boolean executeBoolean_long5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */;
            return isSafeIntegerLong(arguments0Value_);
        }

        private boolean executeBoolean_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int arguments0Value_int = 0;
            double arguments0Value_;
            try {
                if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] && SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */)) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */;
            return isSafeIntegerDouble(arguments0Value_);
        }

        private boolean executeBoolean_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 0b11111) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] || SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    return isSafeIntegerInt(arguments0Value__);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */ && arguments0Value_ instanceof Long) {
                    long arguments0Value__ = (long) arguments0Value_;
                    return isSafeIntegerLong(arguments0Value__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] */ && arguments0Value_ instanceof SafeInteger) {
                    SafeInteger arguments0Value__ = (SafeInteger) arguments0Value_;
                    return isSafeIntegerSafeInteger(arguments0Value__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                    return isSafeIntegerDouble(arguments0Value__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */) {
                    if ((!(JSGuards.isNumber(arguments0Value_))) && (!(JSGuards.isNumberLong(arguments0Value_)))) {
                        return isSafeIntegerNotANumber(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (int) arguments0Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */;
                this.state_0_ = state_0;
                return isSafeIntegerInt(arguments0Value_);
            }
            if (arguments0Value instanceof Long) {
                long arguments0Value_ = (long) arguments0Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */;
                this.state_0_ = state_0;
                return isSafeIntegerLong(arguments0Value_);
            }
            if (arguments0Value instanceof SafeInteger) {
                SafeInteger arguments0Value_ = (SafeInteger) arguments0Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] */;
                this.state_0_ = state_0;
                return isSafeIntegerSafeInteger(arguments0Value_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                    double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                    state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */;
                    this.state_0_ = state_0;
                    return isSafeIntegerDouble(arguments0Value_);
                }
            }
            if ((!(JSGuards.isNumber(arguments0Value))) && (!(JSGuards.isNumberLong(arguments0Value)))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */;
                this.state_0_ = state_0;
                return isSafeIntegerNotANumber(arguments0Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            Object[] s;
            data[0] = 0;
            int state_0 = this.state_0_;
            s = new Object[3];
            s[0] = "isSafeIntegerInt";
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerInt(int)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isSafeIntegerLong";
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerLong(long)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isSafeIntegerSafeInteger";
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerSafeInteger(SafeInteger)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isSafeIntegerDouble";
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerDouble(double)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "isSafeIntegerNotANumber";
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NumberFunctionBuiltins.JSNumberIsSafeIntegerNode.isSafeIntegerNotANumber(Object)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            return Provider.create(data);
        }

        @NeverDefault
        public static JSNumberIsSafeIntegerNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberIsSafeIntegerNodeGen(context, builtin, arguments);
        }

    }
}
