/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalZonedDateTimeObject
extends JSTemporalCalendarHolder {
    private final BigInt nanoseconds;
    private final Object timeZone;

    protected JSTemporalZonedDateTimeObject(Shape shape, JSDynamicObject proto, BigInt nanoseconds, Object timeZone, Object calendar) {
        super(shape, proto, calendar);
        assert (TemporalUtil.isValidEpochNanoseconds(nanoseconds));
        this.nanoseconds = nanoseconds;
        this.timeZone = timeZone;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    public Object getTimeZone() {
        return this.timeZone;
    }

    @CompilerDirectives.TruffleBoundary
    private Instant toInstant() {
        BigInt[] res = this.nanoseconds.divideAndRemainder(TemporalUtil.BI_NS_PER_SECOND);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isTimeZone"), @ExportMessage(name="isDate"), @ExportMessage(name="isTime")})
    @CompilerDirectives.TruffleBoundary
    boolean isTimeZone() {
        return this.getZoneIdIntl() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone() throws UnsupportedMessageException {
        ZoneId tzObj = this.getZoneIdIntl();
        if (tzObj == null) {
            throw UnsupportedMessageException.create();
        }
        return tzObj;
    }

    @CompilerDirectives.TruffleBoundary
    private ZoneId getZoneIdIntl() {
        ZoneId zoneId;
        String id;
        Object object = this.timeZone;
        if (object instanceof TruffleString) {
            TruffleString string = (TruffleString)object;
            id = string.toJavaStringUncached();
        } else {
            Object tzID = JSRuntime.get(this.timeZone, Strings.ID_PROPERTY_NAME);
            id = JSRuntime.toJavaString(tzID);
        }
        try {
            zoneId = ZoneId.of(id);
        }
        catch (DateTimeException ex) {
            zoneId = null;
        }
        return zoneId;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() throws UnsupportedMessageException {
        return LocalDate.ofInstant(this.toInstant(), this.asTimeZone());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() throws UnsupportedMessageException {
        return LocalTime.ofInstant(this.toInstant(), this.asTimeZone());
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalZonedDateTime.TO_STRING_TAG;
    }
}

