/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;

public abstract class CalendarMethodsRecordLookupNode
extends JavaScriptBaseNode {
    protected final Key key;

    protected CalendarMethodsRecordLookupNode(Key key) {
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createDateAdd() {
        return CalendarMethodsRecordLookupNode.create(Key.DATE_ADD);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createDateFromFields() {
        return CalendarMethodsRecordLookupNode.create(Key.DATE_FROM_FIELDS);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createDateUntil() {
        return CalendarMethodsRecordLookupNode.create(Key.DATE_UNTIL);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createDay() {
        return CalendarMethodsRecordLookupNode.create(Key.DAY);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createFields() {
        return CalendarMethodsRecordLookupNode.create(Key.FIELDS);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createMergeFields() {
        return CalendarMethodsRecordLookupNode.create(Key.MERGE_FIELDS);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createMonthDayFromFields() {
        return CalendarMethodsRecordLookupNode.create(Key.MONTH_DAY_FROM_FIELDS);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode createYearMonthFromFields() {
        return CalendarMethodsRecordLookupNode.create(Key.YEAR_MONTH_FROM_FIELDS);
    }

    @NeverDefault
    public static CalendarMethodsRecordLookupNode create(Key key) {
        return CalendarMethodsRecordLookupNodeGen.create(key);
    }

    public abstract Object execute(Object var1);

    @Specialization
    protected Object lookup(TruffleString receiver) {
        JSRealm realm = this.getRealm();
        return switch (this.key.ordinal()) {
            case 0 -> realm.getTemporalCalendarDateAddFunctionObject();
            case 1 -> realm.getTemporalCalendarDateFromFieldsFunctionObject();
            case 2 -> realm.getTemporalCalendarDateUntilFunctionObject();
            case 3 -> realm.getTemporalCalendarDayFunctionObject();
            case 4 -> realm.getTemporalCalendarFieldsFunctionObject();
            case 5 -> realm.getTemporalCalendarMergeFieldsFunctionObject();
            case 6 -> realm.getTemporalCalendarMonthDayFromFieldsFunctionObject();
            case 7 -> realm.getTemporalCalendarYearMonthFromFieldsFunctionObject();
            case 8 -> realm.getTemporalCalendarYearFunctionObject();
            case 9 -> realm.getTemporalCalendarMonthFunctionObject();
            case 10 -> realm.getTemporalCalendarMonthCodeFunctionObject();
            case 11 -> realm.getTemporalCalendarDayOfWeekFunctionObject();
            case 12 -> realm.getTemporalCalendarDayOfYearFunctionObject();
            case 13 -> realm.getTemporalCalendarWeekOfYearFunctionObject();
            case 14 -> realm.getTemporalCalendarYearOfWeekFunctionObject();
            case 15 -> realm.getTemporalCalendarDaysInWeekFunctionObject();
            case 16 -> realm.getTemporalCalendarDaysInMonthFunctionObject();
            case 17 -> realm.getTemporalCalendarDaysInYearFunctionObject();
            case 18 -> realm.getTemporalCalendarMonthsInYearFunctionObject();
            case 19 -> realm.getTemporalCalendarInLeapYearFunctionObject();
            default -> throw CompilerDirectives.shouldNotReachHere((String)this.key.name());
        };
    }

    @Specialization(guards={"!isString(receiver)"})
    protected Object lookup(Object receiver, @Cached(value="create(getJSContext(), key.getPropertyKey())") GetMethodNode getMethod, @Cached InlinedBranchProfile errorBranch) {
        Object method = getMethod.executeWithTarget(receiver);
        if (method == Undefined.instance) {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorCallableExpected();
        }
        return method;
    }

    public static enum Key {
        DATE_ADD(TemporalConstants.DATE_ADD),
        DATE_FROM_FIELDS(TemporalConstants.DATE_FROM_FIELDS),
        DATE_UNTIL(TemporalConstants.DATE_UNTIL),
        DAY(TemporalConstants.DAY),
        FIELDS(TemporalConstants.FIELDS),
        MERGE_FIELDS(TemporalConstants.MERGE_FIELDS),
        MONTH_DAY_FROM_FIELDS(TemporalConstants.MONTH_DAY_FROM_FIELDS),
        YEAR_MONTH_FROM_FIELDS(TemporalConstants.YEAR_MONTH_FROM_FIELDS),
        YEAR(TemporalConstants.YEAR),
        MONTH(TemporalConstants.MONTH),
        MONTH_CODE(TemporalConstants.MONTH_CODE),
        DAY_OF_WEEK(TemporalConstants.DAY_OF_WEEK),
        DAY_OF_YEAR(TemporalConstants.DAY_OF_YEAR),
        WEEK_OF_YEAR(TemporalConstants.WEEK_OF_YEAR),
        YEAR_OF_WEEK(TemporalConstants.YEAR_OF_WEEK),
        DAYS_IN_WEEK(TemporalConstants.DAYS_IN_WEEK),
        DAYS_IN_MONTH(TemporalConstants.DAYS_IN_MONTH),
        DAYS_IN_YEAR(TemporalConstants.DAYS_IN_YEAR),
        MONTHS_IN_YEAR(TemporalConstants.MONTHS_IN_YEAR),
        IN_LEAP_YEAR(TemporalConstants.IN_LEAP_YEAR);

        private final TruffleString propertyKey;

        private Key(TruffleString propertyKey) {
            this.propertyKey = propertyKey;
        }

        TruffleString getPropertyKey() {
            return this.propertyKey;
        }
    }
}

