/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalAddDateTimeNode
extends JavaScriptBaseNode {
    protected TemporalAddDateTimeNode() {
    }

    public abstract JSTemporalDateTimeRecord execute(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, double var9, CalendarMethodsRecord var11, double var12, double var14, double var16, double var18, BigInt var20, JSDynamicObject var21);

    @Specialization
    protected JSTemporalDateTimeRecord addDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, double nanosecond, CalendarMethodsRecord calendarRec, double years, double months, double weeks, double days, BigInt normalizedTimeDuration, JSDynamicObject options, @Cached TemporalAddDateNode addDateNode, @Cached InlinedBranchProfile errorBranch) {
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        TimeRecord timeResult = TemporalUtil.addTime(hour, minute, second, millisecond, microsecond, nanosecond, normalizedTimeDuration, this, errorBranch);
        JSTemporalPlainDateObject datePart = JSTemporalPlainDate.create(ctx, realm, year, month, day, calendarRec.receiver(), this, errorBranch);
        JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days + timeResult.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject addedDate = addDateNode.execute(calendarRec, datePart, dateDuration, options);
        return JSTemporalDateTimeRecord.create(addedDate.getYear(), addedDate.getMonth(), addedDate.getDay(), timeResult.hour(), timeResult.minute(), timeResult.second(), timeResult.millisecond(), timeResult.microsecond(), timeResult.nanosecond());
    }
}

