/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;

@ImportStatic(value={JSGuards.class})
public abstract class JSToIntegerThrowOnInfinityNode
extends JavaScriptBaseNode {
    private final BranchProfile errorBranch = BranchProfile.create();
    private final BranchProfile isIntProfile = BranchProfile.create();
    private final BranchProfile isLongProfile = BranchProfile.create();
    private final BranchProfile isDoubleProfile = BranchProfile.create();

    public abstract Object execute(Object var1);

    public final int executeIntOrThrow(Object value) {
        Number n = (Number)this.execute(value);
        if (n instanceof Integer) {
            this.isIntProfile.enter();
            return (Integer)n;
        }
        if (n instanceof Long) {
            this.isLongProfile.enter();
            long l = (Long)n;
            if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
                this.errorBranch.enter();
                throw Errors.createRangeError("value out of range");
            }
            return (int)l;
        }
        this.isDoubleProfile.enter();
        double d = JSRuntime.doubleValue(n);
        if (d < -2.147483648E9 || 2.147483647E9 < d) {
            this.errorBranch.enter();
            throw Errors.createRangeError("value out of range");
        }
        return (int)d;
    }

    public final double executeDouble(Object value) {
        return JSRuntime.doubleValue((Number)this.execute(value));
    }

    @NeverDefault
    public static JSToIntegerThrowOnInfinityNode create() {
        return JSToIntegerThrowOnInfinityNodeGen.create();
    }

    @Specialization
    protected static int doInteger(int value) {
        return value;
    }

    @Specialization
    protected static long doLong(long value) {
        return value;
    }

    @Specialization
    protected static int doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static SafeInteger doSafeInteger(SafeInteger value) {
        return value;
    }

    @Specialization
    protected long doDoubleInfinite(double value) {
        if (Double.isNaN(value) || value == 0.0) {
            return 0L;
        }
        if (Double.isInfinite(value)) {
            this.errorBranch.enter();
            throw Errors.createRangeError("infinity not allowed");
        }
        return (long)value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(Object value) {
        return 0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static int doUndefined(Object value) {
        return 0;
    }

    @Specialization
    protected final Number doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final Number doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected Number doString(TruffleString value, @Cached.Shared @Cached JSToIntegerThrowOnInfinityNode toIntOrInf, @Cached JSStringToNumberNode stringToNumberNode) {
        return (Number)toIntOrInf.execute(stringToNumberNode.execute(value));
    }

    @Specialization(guards={"isJSObject(value) || isForeignObject(value)"})
    protected Number doJSOrForeignObject(Object value, @Cached.Shared @Cached JSToIntegerThrowOnInfinityNode toIntOrInf, @Cached JSToNumberNode toNumberNode) {
        return (Number)toIntOrInf.execute(toNumberNode.executeNumber(value));
    }
}

