/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.scriptengine;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import com.oracle.truffle.js.scriptengine.PlaceholderScriptEngine;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.graalvm.polyglot.Engine;

public final class GraalJSEngineFactory
implements ScriptEngineFactory {
    private static final String ENGINE_NAME = "Graal.js";
    private static final String NAME = "javascript";
    private static final String LANGUAGE = "ECMAScript";
    private static final String LANGUAGE_VERSION = "ECMAScript 262 Edition 11";
    private static final List<String> NAMES = List.of("js", "JS", "JavaScript", "javascript", "ECMAScript", "ecmascript", "Graal.js", "graal.js", "Graal-js", "graal-js", "Graal.JS", "Graal-JS", "GraalJS", "GraalJSPolyglot");
    private static final List<String> MIME_TYPES = List.of("application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript");
    private static final List<String> EXTENSIONS = List.of("js", "mjs");
    private static final boolean JS_AVAILABLE;
    private static final String PLACEHOLDER_NAME = "placeholder";
    private static final String PLACEHOLDER_VERSION = "1";
    private WeakReference<Engine> defaultEngine;
    private final Engine userDefinedEngine;

    public GraalJSEngineFactory() {
        this.defaultEngine = null;
        this.userDefinedEngine = null;
    }

    GraalJSEngineFactory(Engine engine) {
        this.userDefinedEngine = engine;
    }

    private static Engine createDefaultEngine() {
        return Engine.newBuilder().allowExperimentalOptions(true).build();
    }

    public Engine getPolyglotEngine() {
        Engine engine;
        if (this.userDefinedEngine != null) {
            return this.userDefinedEngine;
        }
        Engine engine2 = engine = this.defaultEngine == null ? null : (Engine)this.defaultEngine.get();
        if (engine == null) {
            engine = GraalJSEngineFactory.createDefaultEngine();
            this.defaultEngine = new WeakReference<Engine>(engine);
        }
        return engine;
    }

    @Override
    public String getEngineName() {
        return JS_AVAILABLE ? ENGINE_NAME : PLACEHOLDER_NAME;
    }

    @Override
    public String getEngineVersion() {
        return this.getPolyglotEngine().getVersion();
    }

    @Override
    public List<String> getExtensions() {
        return JS_AVAILABLE ? EXTENSIONS : Collections.emptyList();
    }

    @Override
    public List<String> getMimeTypes() {
        return JS_AVAILABLE ? MIME_TYPES : Collections.emptyList();
    }

    @Override
    public List<String> getNames() {
        return JS_AVAILABLE ? NAMES : Collections.singletonList(NAME);
    }

    @Override
    public String getLanguageName() {
        return JS_AVAILABLE ? LANGUAGE : PLACEHOLDER_NAME;
    }

    @Override
    public String getLanguageVersion() {
        return JS_AVAILABLE ? LANGUAGE_VERSION : PLACEHOLDER_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        switch (key) {
            case "javax.script.name": {
                return NAME;
            }
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
        }
        return null;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return JS_AVAILABLE ? new GraalJSScriptEngine(this) : new PlaceholderScriptEngine(this);
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(method);
        StringBuilder sb = new StringBuilder().append(obj).append('.').append(method).append('(');
        int len = args.length;
        if (len > 0) {
            Objects.requireNonNull(args[0]);
            sb.append(args[0]);
        }
        for (int i = 1; i < len; ++i) {
            Objects.requireNonNull(args[i]);
            sb.append(',').append(args[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(" + toDisplay + ")" + (JS_AVAILABLE ? "" : ";");
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String statement : statements) {
            Objects.requireNonNull(statement);
            sb.append(statement).append(';');
        }
        return sb.toString();
    }

    static {
        try (Engine engine = Engine.newBuilder().useSystemProperties(false).build();){
            JS_AVAILABLE = engine.getLanguages().containsKey("js");
        }
    }
}

