/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSymbolRecord;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.ArrayList;

final class CVLineRecord
extends CVSymbolRecord {
    private static final int LINE_RECORD_HEADER_SIZE = 12;
    private static final int DEFAULT_LINE_BLOCK_COUNT = 100;
    private static final int DEFAULT_LINE_ENTRY_COUNT = 100;
    private static final short CB_HAS_NO_COLUMNS_FLAG = 0;
    private String symbolName;
    private ArrayList<FileBlock> fileBlocks = new ArrayList(100);

    CVLineRecord(CVDebugInfo cvDebugInfo, String symbolName) {
        super(cvDebugInfo, 242);
        this.symbolName = symbolName;
    }

    void addNewFile(int fileId) {
        this.fileBlocks.add(new FileBlock(fileId));
    }

    void addNewLine(int addr, int line) {
        this.fileBlocks.get(this.fileBlocks.size() - 1).addEntry(new LineEntry(addr, line));
    }

    int getCurrentFileId() {
        assert (!this.fileBlocks.isEmpty());
        return this.fileBlocks.get((int)(this.fileBlocks.size() - 1)).fileId;
    }

    @Override
    protected int computeSize(int initialPos) {
        return this.computeContents(null, initialPos);
    }

    @Override
    protected int computeContents(byte[] buffer, int initialPos) {
        int pos = this.computeHeader(buffer, initialPos);
        for (FileBlock fileBlock : this.fileBlocks) {
            pos = fileBlock.computeContents(buffer, pos);
        }
        return pos;
    }

    private int computeHeader(byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 12;
        }
        assert (this.symbolName != null);
        int pos = initialPos;
        this.cvDebugInfo.getCVSymbolSection().markRelocationSite(pos, ObjectFile.RelocationKind.SECREL_4, this.symbolName, 1L);
        pos = CVUtil.putInt(0, buffer, pos);
        this.cvDebugInfo.getCVSymbolSection().markRelocationSite(pos, ObjectFile.RelocationKind.SECTION_2, this.symbolName, 1L);
        pos = CVUtil.putShort((short)0, buffer, pos);
        pos = CVUtil.putShort((short)0, buffer, pos);
        assert (!this.fileBlocks.isEmpty());
        int length = this.fileBlocks.get(this.fileBlocks.size() - 1).getHighAddr();
        pos = CVUtil.putInt(length, buffer, pos);
        return pos;
    }

    boolean isEmpty() {
        return this.fileBlocks.isEmpty();
    }

    @Override
    public String toString() {
        return String.format("CVLineRecord(type=0x%04x pos=0x%05x size=0x%d)", this.type, this.recordStartPosition, this.fileBlocks.size());
    }

    private static class LineEntry {
        static final int LINE_ENTRY_SIZE = 8;
        int addr;
        int lineAndFLags;

        LineEntry(int addr, int line, int deltaEnd, boolean isStatement) {
            this.addr = addr;
            assert (line <= 0xFFFFFF);
            assert (line >= 0);
            assert (deltaEnd <= 127);
            assert (deltaEnd >= 0);
            this.lineAndFLags = line | deltaEnd << 24 | (isStatement ? Integer.MIN_VALUE : 0);
        }

        LineEntry(int addr, int line) {
            this(addr, line, 0, false);
        }

        int computeContents(byte[] buffer, int initialPos) {
            int pos = initialPos;
            pos = CVUtil.putInt(this.addr, buffer, pos);
            pos = CVUtil.putInt(this.lineAndFLags, buffer, pos);
            return pos;
        }
    }

    private static class FileBlock {
        static final int FILE_BLOCK_HEADER_SIZE = 12;
        private ArrayList<LineEntry> lineEntries = new ArrayList(100);
        private int fileId;

        FileBlock(int fileId) {
            this.fileId = fileId;
        }

        void addEntry(LineEntry le) {
            this.lineEntries.add(le);
        }

        int computeContents(byte[] buffer, int initialPos) {
            if (buffer == null) {
                return this.computeSize(initialPos);
            }
            int pos = initialPos;
            pos = CVUtil.putInt(this.fileId, buffer, pos);
            pos = CVUtil.putInt(this.lineEntries.size(), buffer, pos);
            pos = CVUtil.putInt(this.computeSize(0), buffer, pos);
            for (LineEntry lineEntry : this.lineEntries) {
                pos = lineEntry.computeContents(buffer, pos);
            }
            return pos;
        }

        int computeSize(int initialPos) {
            return initialPos + 12 + 8 * this.lineEntries.size();
        }

        int getHighAddr() {
            assert (!this.lineEntries.isEmpty());
            return this.lineEntries.get((int)(this.lineEntries.size() - 1)).addr;
        }
    }
}

