/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.DirectInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

final class SpecialInvokeTypeFlow
extends DirectInvokeTypeFlow {
    protected ConcurrentMap<MethodFlowsGraph, Object> calleesFlows;

    protected SpecialInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invoke, target, actualParameters, actualReturn, location);
        assert (target.invokeKind() == CallTargetNode.InvokeKind.Special);
    }

    protected SpecialInvokeTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, DirectInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.calleesFlows = new ConcurrentHashMap<MethodFlowsGraph, Object>(4, 0.75f, 1);
    }

    @Override
    public TypeFlow<MethodCallTargetNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new SpecialInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public boolean addState(BigBang bb, TypeState add, boolean postFlow) {
        throw AnalysisError.shouldNotReachHere("The SpecialInvokeTypeFlow should not be updated directly.");
    }

    @Override
    public void update(BigBang bb) {
        throw AnalysisError.shouldNotReachHere("The SpecialInvokeTypeFlow should not be updated directly.");
    }

    @Override
    public void onObservedUpdate(BigBang bb) {
        assert (this.isClone());
        if (this.callee == null) {
            MethodCallTargetNode target = (MethodCallTargetNode)this.invoke.callTarget();
            ((DirectInvokeTypeFlow)this.originalInvoke).callee = this.callee = ((AnalysisMethod)target.targetMethod()).getTypeFlow();
        }
        TypeState invokeState = this.getReceiver().getState();
        for (AnalysisObject receiverObject : invokeState.objects()) {
            AnalysisContext calleeContext = bb.contextPolicy().calleeContext(bb, receiverObject, this.callerContext, this.callee);
            MethodFlowsGraph calleeFlows = this.callee.addContext(bb, calleeContext, this);
            if (this.calleesFlows.putIfAbsent(calleeFlows, Boolean.TRUE) == null) {
                this.linkCallee(bb, false, calleeFlows);
            }
            this.updateReceiver(bb, calleeFlows, receiverObject);
        }
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(BigBang bb) {
        return new ArrayList<MethodFlowsGraph>(this.calleesFlows.keySet());
    }

    @Override
    public String toString() {
        return "SpecialInvoke<" + ((MethodCallTargetNode)this.getSource()).targetMethod().format("%h.%n") + ">:" + this.getState();
    }
}

