/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.StaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.nodes.Invoke;

public class MethodFlowsGraph {
    protected final int id = TypeFlow.nextId.incrementAndGet();
    private final PointsToAnalysisMethod method;
    private AnalysisContext context;
    private boolean isClone;
    public TypeFlow<?>[] linearizedGraph;
    private FormalParamTypeFlow[] parameters;
    private InitialParamTypeFlow[] initialParameterFlows;
    private List<TypeFlow<?>> miscEntryFlows;
    private Map<Object, TypeFlow<?>> nodeFlows;
    private Set<Object> nonUniqueBcis;
    private Map<Object, InstanceOfTypeFlow> instanceOfFlows;
    private Map<Object, InvokeTypeFlow> invokeFlows;
    private FormalReturnTypeFlow result;
    private boolean isLinearized = false;
    private boolean sealed;

    public MethodFlowsGraph(PointsToAnalysisMethod analysisMethod) {
        int offset;
        this.method = analysisMethod;
        this.context = null;
        this.isClone = false;
        boolean isStatic = Modifier.isStatic(this.method.getModifiers());
        int parameterCount = this.method.getSignature().getParameterCount(!isStatic);
        this.parameters = new FormalParamTypeFlow[parameterCount];
        for (int i = offset = isStatic ? 0 : 1; i < this.parameters.length; ++i) {
            this.method.getSignature().getParameterType(i - offset, this.method.getDeclaringClass());
        }
        this.initialParameterFlows = new InitialParamTypeFlow[parameterCount];
        this.method.getSignature().getReturnType(this.method.getDeclaringClass());
        this.miscEntryFlows = new ArrayList();
        this.nodeFlows = new HashMap();
        this.instanceOfFlows = new HashMap<Object, InstanceOfTypeFlow>();
        this.invokeFlows = new HashMap<Object, InvokeTypeFlow>(4, 0.75f);
        this.nonUniqueBcis = new HashSet<Object>();
    }

    public MethodFlowsGraph(PointsToAnalysisMethod method, AnalysisContext context) {
        this.context = context;
        this.method = method;
        this.isClone = true;
    }

    public void cloneOriginalFlows(PointsToAnalysis bb) {
        assert (this.isClone && this.context != null);
        MethodFlowsGraph originalMethodFlowsGraph = this.method.getTypeFlow().originalMethodFlows;
        assert (originalMethodFlowsGraph != null && originalMethodFlowsGraph.isLinearized()) : " Method " + this + " is not linearized";
        this.linearizedGraph = new TypeFlow[originalMethodFlowsGraph.linearizedGraph.length];
        this.parameters = new FormalParamTypeFlow[originalMethodFlowsGraph.parameters.length];
        for (int i = 0; i < originalMethodFlowsGraph.parameters.length; ++i) {
            if (originalMethodFlowsGraph.getParameter(i) == null) continue;
            this.parameters[i] = this.lookupCloneOf(bb, originalMethodFlowsGraph.getParameter(i));
        }
        this.initialParameterFlows = new InitialParamTypeFlow[originalMethodFlowsGraph.initialParameterFlows.length];
        this.nodeFlows = originalMethodFlowsGraph.nodeFlows.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> this.lookupCloneOf(bb, (TypeFlow)e.getValue())));
        this.result = originalMethodFlowsGraph.getResult() != null ? this.lookupCloneOf(bb, originalMethodFlowsGraph.getResult()) : null;
        this.instanceOfFlows = originalMethodFlowsGraph.instanceOfFlows.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> (InstanceOfTypeFlow)this.lookupCloneOf(bb, (TypeFlow)e.getValue())));
        this.miscEntryFlows = originalMethodFlowsGraph.miscEntryFlows.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.invokeFlows = originalMethodFlowsGraph.invokeFlows.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> (InvokeTypeFlow)this.lookupCloneOf(bb, (TypeFlow)e.getValue())));
        this.sealed = true;
    }

    public <T extends TypeFlow<?>> T lookupCloneOf(PointsToAnalysis bb, T original) {
        assert (original != null) : "Looking for the clone of a 'null' flow in " + this;
        assert (!original.isClone()) : "Looking for the clone of the already cloned flow " + original + " in " + this;
        assert (!(original instanceof FieldTypeFlow)) : "Trying to clone a field type flow";
        assert (!(original instanceof ArrayElementsTypeFlow)) : "Trying to clone an mixed elements type flow";
        if (original instanceof AllInstantiatedTypeFlow || original instanceof AllSynchronizedTypeFlow) {
            return original;
        }
        if (original instanceof ProxyTypeFlow) {
            return (T)((ProxyTypeFlow)original).getInput();
        }
        int slot = original.getSlot();
        assert (slot >= 0 && slot < this.linearizedGraph.length) : "Slot index out of bounds " + slot + " : " + original + " [" + original.getSource() + "]";
        TypeFlow<?> clone = this.linearizedGraph[slot];
        if (clone == null) {
            if (this.sealed) {
                JVMCIError.shouldNotReachHere((String)"Trying to create a clone after the method flows have been sealed.");
            }
            clone = original.copy(bb, this);
            assert (slot == clone.getSlot());
            assert (this.linearizedGraph[slot] == null) : "Clone already exists: " + slot + " : " + original;
            this.linearizedGraph[slot] = clone;
        }
        return (T)clone;
    }

    public void linkClones(PointsToAnalysis bb) {
        MethodFlowsGraph originalMethodFlowsGraph = this.method.getTypeFlow().originalMethodFlows;
        for (int i = 0; i < originalMethodFlowsGraph.initialParameterFlows.length; ++i) {
            InitialParamTypeFlow initialParameterFlow = originalMethodFlowsGraph.getInitialParameterFlow(i);
            if (initialParameterFlow == null || this.parameters[i] == null) continue;
            initialParameterFlow.addUse(bb, this.parameters[i]);
            this.initialParameterFlows[i] = initialParameterFlow;
        }
        for (TypeFlow<?> original : originalMethodFlowsGraph.linearizedGraph) {
            TypeFlow<?> clone = this.lookupCloneOf(bb, original);
            clone.initClone(bb);
            for (TypeFlow<?> originalObserver : original.getObservers()) {
                assert (!(originalObserver instanceof AllInstantiatedTypeFlow));
                assert (!originalObserver.isClone());
                if (MethodFlowsGraph.nonCloneableFlow(originalObserver)) {
                    clone.addObserver(bb, originalObserver);
                    continue;
                }
                if (MethodFlowsGraph.crossMethodUse(original, originalObserver)) continue;
                TypeFlow<?> clonedObserver = this.lookupCloneOf(bb, originalObserver);
                clone.addObserver(bb, clonedObserver);
            }
            for (TypeFlow<?> originalUse : original.getUses()) {
                assert (!(originalUse instanceof AllInstantiatedTypeFlow));
                assert (!originalUse.isClone());
                if (MethodFlowsGraph.nonCloneableFlow(originalUse)) {
                    clone.addUse(bb, originalUse);
                    continue;
                }
                if (MethodFlowsGraph.crossMethodUse(original, originalUse)) continue;
                TypeFlow<?> clonedUse = this.lookupCloneOf(bb, originalUse);
                clone.addUse(bb, clonedUse);
            }
            if (!(clone instanceof StaticInvokeTypeFlow)) continue;
            StaticInvokeTypeFlow invokeFlow = (StaticInvokeTypeFlow)clone;
            bb.postFlow(invokeFlow);
        }
    }

    public static boolean nonCloneableFlow(TypeFlow<?> flow) {
        return flow instanceof FieldTypeFlow || flow instanceof ArrayElementsTypeFlow;
    }

    public static boolean crossMethodUse(TypeFlow<?> flow, TypeFlow<?> use) {
        return flow instanceof FormalReturnTypeFlow || use instanceof FormalParamTypeFlow;
    }

    public void linearizeGraph() {
        this.linearizedGraph = this.doLinearizeGraph();
        this.isLinearized = true;
    }

    private TypeFlow<?>[] doLinearizeGraph() {
        ArrayDeque worklist = new ArrayDeque();
        for (FormalParamTypeFlow param : this.parameters) {
            if (param == null) continue;
            worklist.add(param);
        }
        worklist.addAll(this.nodeFlows.values());
        worklist.addAll(this.miscEntryFlows);
        worklist.addAll(this.instanceOfFlows.values());
        worklist.addAll(this.invokeFlows.values());
        if (this.result != null) {
            worklist.add(this.result);
        }
        ArrayList<TypeFlow> resultFlows = new ArrayList<TypeFlow>();
        while (worklist.size() > 0) {
            TypeFlow flow = (TypeFlow)worklist.pop();
            if (flow.getSlot() != -1 || flow instanceof AllInstantiatedTypeFlow) continue;
            int slot = resultFlows.size();
            flow.setSlot(slot);
            resultFlows.add(flow);
            for (TypeFlow<?> use : flow.getUses()) {
                assert (use != null);
                if (use.isClone() || MethodFlowsGraph.crossMethodUse(flow, use) || MethodFlowsGraph.nonCloneableFlow(use)) continue;
                worklist.add(use);
            }
        }
        return resultFlows.toArray(new TypeFlow[resultFlows.size()]);
    }

    public int id() {
        return this.id;
    }

    public AnalysisContext context() {
        return this.context;
    }

    public PointsToAnalysisMethod getMethod() {
        return this.method;
    }

    public FormalReceiverTypeFlow getFormalReceiver() {
        return (FormalReceiverTypeFlow)this.getParameter(0);
    }

    public void setParameter(int index, FormalParamTypeFlow parameter) {
        assert (index >= 0 && index < this.parameters.length);
        this.parameters[index] = parameter;
    }

    public FormalParamTypeFlow getParameter(int idx) {
        assert (idx >= 0 && idx < this.parameters.length);
        return this.parameters[idx];
    }

    public TypeFlow<?>[] getParameters() {
        return this.parameters;
    }

    public void setInitialParameterFlow(InitialParamTypeFlow initialParameterFlow, int i) {
        assert (i >= 0 && i < this.initialParameterFlows.length);
        this.initialParameterFlows[i] = initialParameterFlow;
    }

    public InitialParamTypeFlow getInitialParameterFlow(int i) {
        assert (i >= 0 && i < this.initialParameterFlows.length);
        return this.initialParameterFlows[i];
    }

    public TypeFlow<?>[] getInitialParameterFlows() {
        return this.initialParameterFlows;
    }

    public void addNodeFlow(Object key, TypeFlow<?> flow) {
        assert (flow != null && !(flow instanceof AllInstantiatedTypeFlow));
        TypeFlow<?> previous = this.nodeFlows.put(key, flow);
        assert (previous == null) : "Overwriting flow for " + key + ": " + previous + " - " + flow;
    }

    public Collection<TypeFlow<?>> getMiscFlows() {
        return this.miscEntryFlows;
    }

    public Map<Object, TypeFlow<?>> getNodeFlows() {
        return this.nodeFlows;
    }

    public void addMiscEntryFlow(TypeFlow<?> entryFlow) {
        assert (!(entryFlow instanceof AllInstantiatedTypeFlow));
        this.miscEntryFlows.add(entryFlow);
    }

    public void setResult(FormalReturnTypeFlow result) {
        this.result = result;
    }

    public FormalReturnTypeFlow getResult() {
        return this.result;
    }

    public Set<Map.Entry<Object, InvokeTypeFlow>> getInvokes() {
        return this.invokeFlows.entrySet();
    }

    public InvokeTypeFlow getInvokeFlow(Invoke invoke) {
        return this.invokeFlows.get(invoke);
    }

    Collection<InvokeTypeFlow> getInvokeFlows() {
        return this.invokeFlows.values();
    }

    public Set<Map.Entry<Object, InstanceOfTypeFlow>> getInstanceOfFlows() {
        return this.instanceOfFlows.entrySet();
    }

    void addInstanceOf(Object key, InstanceOfTypeFlow instanceOf) {
        this.doAddFlow(key, instanceOf, this.instanceOfFlows);
    }

    void addInvoke(Object key, InvokeTypeFlow invokeTypeFlow) {
        this.doAddFlow(key, invokeTypeFlow, this.invokeFlows);
    }

    private <T extends TypeFlow<BytecodePosition>> void doAddFlow(Object key, T flow, Map<Object, T> map) {
        assert (map == this.instanceOfFlows || map == this.invokeFlows) : "Keys of these maps must not be overlapping";
        Object uniqueKey = key;
        if (this.nonUniqueBcis.contains(key) || this.removeNonUnique(key, this.instanceOfFlows) || this.removeNonUnique(key, this.invokeFlows)) {
            uniqueKey = new Object();
        }
        map.put(uniqueKey, flow);
    }

    private <T extends TypeFlow<BytecodePosition>> boolean removeNonUnique(Object key, Map<Object, T> map) {
        TypeFlow oldFlow = (TypeFlow)map.remove(key);
        if (oldFlow != null) {
            map.put(new Object(), oldFlow);
            this.nonUniqueBcis.add(key);
            return true;
        }
        return false;
    }

    public InvokeTypeFlow getInvoke(Object key) {
        return this.invokeFlows.get(key);
    }

    public boolean isLinearized() {
        return this.isLinearized;
    }

    public List<MethodFlowsGraph> callers(PointsToAnalysis bb) {
        ArrayList<MethodFlowsGraph> callers = new ArrayList<MethodFlowsGraph>();
        for (AnalysisMethod caller : this.method.getCallers()) {
            for (MethodFlowsGraph callerFlowGraph : PointsToAnalysis.assertPointsToAnalysisMethod(caller).getTypeFlow().getFlows()) {
                Iterator<InvokeTypeFlow> iterator = callerFlowGraph.getInvokeFlows().iterator();
                while (iterator.hasNext()) {
                    InvokeTypeFlow callerInvoke;
                    InvokeTypeFlow invoke = callerInvoke = iterator.next();
                    if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(callerInvoke)) {
                        invoke = callerInvoke.getTargetMethod().getContextInsensitiveInvoke();
                    }
                    for (MethodFlowsGraph calleeFlowGraph : invoke.getCalleesFlows(bb)) {
                        if (!calleeFlowGraph.equals(this)) continue;
                        callers.add(callerFlowGraph);
                    }
                }
            }
        }
        return callers;
    }

    public InvokeTypeFlow invokeFlow(MethodFlowsGraph callerFlowGraph, PointsToAnalysis bb) {
        for (InvokeTypeFlow callerInvoke : callerFlowGraph.getInvokeFlows()) {
            for (MethodFlowsGraph calleeFlowGraph : callerInvoke.getCalleesFlows(bb)) {
                if (!calleeFlowGraph.equals(this)) continue;
                return callerInvoke;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodFlowsGraph that = (MethodFlowsGraph)obj;
        return this.method.equals(that.method) && this.isClone == that.isClone && this.context.equals(that.context);
    }

    public int hashCode() {
        return 0x2A ^ this.method.hashCode() ^ (this.isClone ? this.context.hashCode() : 1);
    }

    public String toString() {
        return "MethodFlowsGraph<" + this.method.format("%h.%n(%p)") + " " + (this.isClone ? this.context : "original") + ">";
    }
}

