/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.code.BytecodePosition;

public class ArrayCopyTypeFlow
extends TypeFlow<BytecodePosition> {
    TypeFlow<?> srcArrayFlow;
    TypeFlow<?> dstArrayFlow;
    private TypeState lastSrc;
    private TypeState lastDst;

    public ArrayCopyTypeFlow(BytecodePosition location, AnalysisType declaredType, TypeFlow<?> srcArrayFlow, TypeFlow<?> dstArrayFlow) {
        super(location, declaredType);
        this.srcArrayFlow = srcArrayFlow;
        this.dstArrayFlow = dstArrayFlow;
    }

    public ArrayCopyTypeFlow(PointsToAnalysis bb, ArrayCopyTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.srcArrayFlow = methodFlows.lookupCloneOf(bb, original.srcArrayFlow);
        this.dstArrayFlow = methodFlows.lookupCloneOf(bb, original.dstArrayFlow);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new ArrayCopyTypeFlow(bb, this, methodFlows);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (this.isClone());
        if (bb.analysisPolicy().aliasArrayTypeFlows()) {
            return;
        }
        TypeState srcArrayState = this.srcArrayFlow.getState();
        TypeState dstArrayState = this.dstArrayFlow.getState();
        if (this.lastSrc == null || this.lastDst == null || ((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue()) {
            ArrayCopyTypeFlow.processStates(bb, srcArrayState, dstArrayState);
        } else {
            TypeState addedSrcState = TypeState.forSubtraction(bb, srcArrayState, this.lastSrc);
            TypeState addedDstState = TypeState.forSubtraction(bb, dstArrayState, this.lastDst);
            int addedSrcSize = addedSrcState.objectsCount();
            int addedDstSize = addedDstState.objectsCount();
            if (addedSrcSize != 0 || addedDstSize != 0) {
                if (addedSrcSize == 0) {
                    ArrayCopyTypeFlow.processStates(bb, srcArrayState, addedDstState);
                } else if (addedDstSize == 0) {
                    ArrayCopyTypeFlow.processStates(bb, addedSrcState, dstArrayState);
                } else if ((long)srcArrayState.objectsCount() * (long)addedDstSize + (long)addedSrcSize * (long)dstArrayState.objectsCount() < (long)srcArrayState.objectsCount() * (long)dstArrayState.objectsCount()) {
                    ArrayCopyTypeFlow.processStates(bb, srcArrayState, addedDstState);
                    ArrayCopyTypeFlow.processStates(bb, addedSrcState, dstArrayState);
                } else {
                    ArrayCopyTypeFlow.processStates(bb, srcArrayState, dstArrayState);
                }
            }
        }
        this.lastSrc = srcArrayState;
        this.lastDst = dstArrayState;
    }

    private static void processStates(PointsToAnalysis bb, TypeState srcArrayState, TypeState dstArrayState) {
        for (AnalysisObject srcArrayObject : srcArrayState.objects()) {
            if (!srcArrayObject.type().isArray()) continue;
            assert (srcArrayObject.type().isArray());
            if (srcArrayObject.isPrimitiveArray() || srcArrayObject.isEmptyObjectArrayConstant(bb)) continue;
            ArrayElementsTypeFlow srcArrayElementsFlow = srcArrayObject.getArrayElementsFlow(bb, false);
            for (AnalysisObject dstArrayObject : dstArrayState.objects()) {
                if (!dstArrayObject.type().isArray()) continue;
                assert (dstArrayObject.type().isArray());
                if (dstArrayObject.isPrimitiveArray() || dstArrayObject.isEmptyObjectArrayConstant(bb)) continue;
                ArrayElementsTypeFlow dstArrayElementsFlow = dstArrayObject.getArrayElementsFlow(bb, true);
                srcArrayElementsFlow.addUse(bb, dstArrayElementsFlow);
            }
        }
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add) {
        throw AnalysisError.shouldNotReachHere("Adding state to an ArrayCopyTypeFlow.");
    }

    public TypeFlow<?> source() {
        return this.srcArrayFlow;
    }

    public TypeFlow<?> destination() {
        return this.dstArrayFlow;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ArrayCopyTypeFlow<").append(this.getState()).append(">");
        return str.toString();
    }
}

