/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;

public class ImageHeap {
    private final ConcurrentHashMap<JavaConstant, Object> heapObjects = new ConcurrentHashMap();
    private final Map<AnalysisType, Set<ImageHeapObject>> typesToObjects = new ConcurrentHashMap<AnalysisType, Set<ImageHeapObject>>();

    public Object getTask(JavaConstant constant) {
        return this.heapObjects.get(constant);
    }

    public Object setTask(JavaConstant constant, AnalysisFuture<ImageHeapObject> task) {
        return this.heapObjects.putIfAbsent(constant, task);
    }

    public void setValue(JavaConstant constant, ImageHeapObject value) {
        this.heapObjects.put(constant, value);
    }

    public Set<ImageHeapObject> getObjects(AnalysisType type) {
        return this.typesToObjects.getOrDefault(type, Collections.emptySet());
    }

    public boolean add(AnalysisType type, ImageHeapObject heapObj) {
        Set objectSet = this.typesToObjects.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet());
        return objectSet.add(heapObj);
    }
}

