/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObject;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.word.WordBase;

public abstract class ImageHeapScanner {
    private static final JavaConstant[] emptyConstantArray = new JavaConstant[0];
    protected final ImageHeap imageHeap;
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisUniverse universe;
    protected final HostVM hostVM;
    protected final SnippetReflectionProvider snippetReflection;
    protected final ConstantReflectionProvider constantReflection;
    protected final ConstantReflectionProvider hostedConstantReflection;
    protected final SnippetReflectionProvider hostedSnippetReflection;
    protected ObjectScanningObserver scanningObserver;

    public ImageHeapScanner(ImageHeap heap, AnalysisMetaAccess aMetaAccess, SnippetReflectionProvider aSnippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver) {
        this.imageHeap = heap;
        this.metaAccess = aMetaAccess;
        this.universe = aMetaAccess.getUniverse();
        this.hostVM = aMetaAccess.getUniverse().hostVM();
        this.snippetReflection = aSnippetReflection;
        this.constantReflection = aConstantReflection;
        this.scanningObserver = aScanningObserver;
        this.hostedConstantReflection = GraalAccess.getOriginalProviders().getConstantReflection();
        this.hostedSnippetReflection = GraalAccess.getOriginalProviders().getSnippetReflection();
    }

    public void scanEmbeddedRoot(JavaConstant root, BytecodePosition position) {
        if (this.isNonNullObjectConstant(root)) {
            AnalysisType type = this.metaAccess.lookupJavaType(root);
            type.registerAsReachable();
            this.getOrCreateConstantReachableTask(root, new ObjectScanner.EmbeddedRootScan(position, root), null);
        }
    }

    public void onFieldRead(AnalysisField field) {
        assert (field.isRead());
        if (this.isValueAvailable(field)) {
            AnalysisType declaringClass = field.getDeclaringClass();
            if (field.isStatic()) {
                this.snapshotFieldValue(field, declaringClass.getOrComputeData().getFieldValue(field));
            } else {
                this.postTask(() -> this.onInstanceFieldRead(field, declaringClass));
            }
        }
    }

    private void onInstanceFieldRead(AnalysisField field, AnalysisType type) {
        for (AnalysisType subtype : type.getSubTypes()) {
            for (ImageHeapObject imageHeapObject : this.imageHeap.getObjects(subtype)) {
                this.snapshotFieldValue(field, ((ImageHeapInstance)imageHeapObject).getFieldValue(field));
            }
            if (subtype.equals(type)) continue;
            this.onInstanceFieldRead(field, subtype);
        }
    }

    public TypeData computeTypeData(AnalysisType type) {
        GraalError.guarantee((boolean)type.isReachable(), (String)"TypeData is only available for reachable types");
        AnalysisField[] staticFields = type.getStaticFields();
        TypeData data = new TypeData(staticFields.length);
        for (AnalysisField field : staticFields) {
            ValueSupplier<JavaConstant> rawFieldValue = this.readHostedFieldValue(field, null);
            data.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                JavaConstant value = this.onFieldValueReachable(field, rawFieldValue, new ObjectScanner.FieldScan(field));
                data.setFieldValue(field, value);
                return value;
            }));
        }
        return data;
    }

    void markTypeInstantiated(AnalysisType type) {
        if (this.universe.sealed() && !type.isReachable()) {
            throw AnalysisError.shouldNotReachHere("Universe is sealed. New type reachable: " + type.toJavaName());
        }
        type.registerAsInHeap();
    }

    JavaConstant markConstantReachable(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (this.isNonNullObjectConstant(constant)) {
            return this.getOrCreateConstantReachableTask(constant, reason, onAnalysisModified).getObject();
        }
        return constant;
    }

    protected ImageHeapObject toImageHeapObject(JavaConstant constant) {
        return this.toImageHeapObject(constant, ObjectScanner.OtherReason.RESCAN, null);
    }

    protected ImageHeapObject toImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        assert (constant != null && this.isNonNullObjectConstant(constant));
        return this.getOrCreateConstantReachableTask(constant, reason, onAnalysisModified);
    }

    protected ImageHeapObject getOrCreateConstantReachableTask(JavaConstant javaConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        ObjectScanner.ScanReason nonNullReason = Objects.requireNonNull(reason);
        Object existingTask = this.imageHeap.getTask(javaConstant);
        if (existingTask == null) {
            if (this.universe.sealed()) {
                throw AnalysisError.shouldNotReachHere("Universe is sealed. New constant reachable: " + javaConstant.toValueString());
            }
            AnalysisFuture<ImageHeapObject> newTask = new AnalysisFuture<ImageHeapObject>(() -> {
                ImageHeapObject imageHeapObject = this.createImageHeapObject(javaConstant, nonNullReason, onAnalysisModified);
                this.imageHeap.setValue(javaConstant, imageHeapObject);
                return imageHeapObject;
            });
            existingTask = this.imageHeap.setTask(javaConstant, newTask);
            if (existingTask == null) {
                this.postTask(newTask);
                return newTask.ensureDone();
            }
        }
        return existingTask instanceof ImageHeapObject ? (ImageHeapObject)existingTask : (ImageHeapObject)((AnalysisFuture)existingTask).ensureDone();
    }

    protected ImageHeapObject createImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        ImageHeapObject newImageHeapObject;
        assert (constant.getJavaKind() == JavaKind.Object && !constant.isNull());
        Optional<JavaConstant> replaced = this.maybeReplace(constant, reason);
        if (replaced.isPresent()) {
            return this.toImageHeapObject(replaced.get(), reason, onAnalysisModified);
        }
        AnalysisType type = this.metaAccess.lookupJavaType(constant);
        if (type.isArray()) {
            if (type.getComponentType().isPrimitive()) {
                newImageHeapObject = new ImageHeapArray(constant, emptyConstantArray);
            } else {
                int length = this.constantReflection.readArrayLength(constant);
                JavaConstant[] arrayElements = new JavaConstant[length];
                ObjectScanner.ArrayScan arrayReason = new ObjectScanner.ArrayScan(type, constant, reason);
                for (int idx = 0; idx < length; ++idx) {
                    JavaConstant rawElementValue = this.constantReflection.readArrayElement(constant, idx);
                    arrayElements[idx] = this.onArrayElementReachable(constant, type, rawElementValue, idx, arrayReason, onAnalysisModified);
                }
                newImageHeapObject = new ImageHeapArray(constant, arrayElements);
            }
            this.markTypeInstantiated(type);
        } else {
            this.markTypeInstantiated(type);
            AnalysisField[] instanceFields = type.getInstanceFields(true);
            newImageHeapObject = new ImageHeapInstance(constant, instanceFields.length);
            for (AnalysisField field : instanceFields) {
                ValueSupplier<JavaConstant> rawFieldValue;
                ObjectScanner.FieldScan fieldReason = new ObjectScanner.FieldScan(field, constant, reason);
                try {
                    rawFieldValue = this.readHostedFieldValue(field, this.universe.toHosted(constant));
                }
                catch (InternalError | LinkageError | TypeNotPresentException e) {
                    continue;
                }
                ImageHeapInstance finalObject = (ImageHeapInstance)newImageHeapObject;
                finalObject.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                    JavaConstant value = this.onFieldValueReachable(field, constant, rawFieldValue, fieldReason, onAnalysisModified);
                    finalObject.setFieldValue(field, value);
                    return value;
                }));
            }
        }
        this.postTask(() -> this.onObjectReachable(newImageHeapObject));
        return newImageHeapObject;
    }

    private Optional<JavaConstant> maybeReplace(JavaConstant constant, ObjectScanner.ScanReason reason) {
        Object replaced;
        Object unwrapped = this.unwrapObject(constant);
        if (unwrapped == null) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Could not unwrap constant", reason));
        }
        if (unwrapped instanceof ImageHeapObject) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Double wrapping of constant. Most likely, the reachability analysis code itself is seen as reachable.", reason));
        }
        if (constant.getJavaKind() == JavaKind.Object && (replaced = this.universe.replaceObject(unwrapped)) != unwrapped) {
            JavaConstant replacedConstant = this.universe.getSnippetReflection().forObject(replaced);
            return Optional.of(replacedConstant);
        }
        return Optional.empty();
    }

    protected Object unwrapObject(JavaConstant constant) {
        return this.snippetReflection.asObject(Object.class, constant);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason) {
        return this.onFieldValueReachable(field, null, rawValue, reason, null);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, null, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, JavaConstant receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, receiver, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, JavaConstant receiver, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        boolean analysisModified;
        AnalysisError.guarantee(field.isReachable(), "Field value is only reachable when field is reachable " + field.format("%H.%n"), new Object[0]);
        AnalysisError.guarantee(rawValue.isAvailable(), "Value not yet available for " + field.format("%H.%n"), new Object[0]);
        JavaConstant transformedValue = this.transformFieldValue(field, receiver, rawValue.get());
        JavaConstant fieldValue = this.markConstantReachable(transformedValue, reason, onAnalysisModified);
        if (this.scanningObserver != null && (analysisModified = this.notifyAnalysis(field, receiver, fieldValue, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
        return fieldValue;
    }

    private boolean notifyAnalysis(AnalysisField field, JavaConstant receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean analysisModified = false;
        if (fieldValue.getJavaKind() == JavaKind.Object && this.hostVM.isRelocatedPointer(this.asObject(fieldValue))) {
            analysisModified = this.scanningObserver.forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
        } else if (fieldValue.isNull()) {
            analysisModified = this.scanningObserver.forNullFieldValue(receiver, field, reason);
        } else if (fieldValue.getJavaKind() == JavaKind.Object) {
            analysisModified = this.scanningObserver.forNonNullFieldValue(receiver, field, fieldValue, reason);
        }
        return analysisModified;
    }

    protected JavaConstant transformFieldValue(AnalysisField field, JavaConstant receiverConstant, JavaConstant originalValueConstant) {
        return originalValueConstant;
    }

    protected JavaConstant onArrayElementReachable(JavaConstant array, AnalysisType arrayType, JavaConstant rawElementValue, int elementIndex, ObjectScanner.ScanReason reason) {
        return this.onArrayElementReachable(array, arrayType, rawElementValue, elementIndex, reason, null);
    }

    protected JavaConstant onArrayElementReachable(JavaConstant array, AnalysisType arrayType, JavaConstant rawElementValue, int elementIndex, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        boolean analysisModified;
        JavaConstant elementValue = this.markConstantReachable(rawElementValue, reason, onAnalysisModified);
        if (this.scanningObserver != null && arrayType.getComponentType().getJavaKind() == JavaKind.Object && (analysisModified = this.notifyAnalysis(array, arrayType, elementValue, elementIndex, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
        return elementValue;
    }

    private boolean isNonNullObjectConstant(JavaConstant constant) {
        return constant.getJavaKind() == JavaKind.Object && constant.isNonNull() && !this.isWordType(constant);
    }

    private boolean isWordType(JavaConstant rawElementValue) {
        Object obj = this.snippetReflection.asObject(Object.class, rawElementValue);
        return obj instanceof WordBase;
    }

    private boolean notifyAnalysis(JavaConstant array, AnalysisType arrayType, JavaConstant elementValue, int elementIndex, ObjectScanner.ScanReason reason) {
        boolean analysisModified;
        if (elementValue.isNull()) {
            analysisModified = this.scanningObserver.forNullArrayElement(array, arrayType, elementIndex, reason);
        } else {
            if (this.isWordType(elementValue)) {
                return false;
            }
            AnalysisType elementType = this.metaAccess.lookupJavaType(elementValue);
            analysisModified = this.scanningObserver.forNonNullArrayElement(array, arrayType, elementValue, elementType, elementIndex, reason);
        }
        return analysisModified;
    }

    protected void onObjectReachable(ImageHeapObject imageHeapObject) {
        AnalysisType objectType = this.metaAccess.lookupJavaType(imageHeapObject.getObject());
        this.imageHeap.add(objectType, imageHeapObject);
        this.markTypeInstantiated(objectType);
        if (imageHeapObject instanceof ImageHeapInstance) {
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapObject;
            for (AnalysisField field : objectType.getInstanceFields(true)) {
                if (!field.isRead() || !this.isValueAvailable(field)) continue;
                this.snapshotFieldValue(field, imageHeapInstance.getFieldValue(field));
            }
        }
    }

    public boolean isValueAvailable(AnalysisField field) {
        return true;
    }

    private void snapshotFieldValue(AnalysisField field, Object fieldTask) {
        if (fieldTask instanceof AnalysisFuture) {
            AnalysisError.guarantee(field.isReachable(), "Field value snapshot computed for field not reachable " + field.format("%H.%n"), new Object[0]);
            this.postTask((AnalysisFuture)fieldTask);
        }
    }

    protected String formatReason(String message, ObjectScanner.ScanReason reason) {
        return message + " " + reason;
    }

    protected ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        JavaConstant value = this.universe.lookup(this.hostedConstantReflection.readFieldValue(field.wrapped, receiver));
        return ValueSupplier.eagerValue(value);
    }

    protected boolean skipScanning() {
        return false;
    }

    public Object rescanRoot(Field reflectionField) {
        if (this.skipScanning()) {
            return null;
        }
        ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
        if (type.isReachable()) {
            AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
            JavaConstant fieldValue = this.readHostedFieldValue(field, null).get();
            TypeData typeData = field.getDeclaringClass().getOrComputeData();
            AnalysisFuture<JavaConstant> fieldTask = this.patchStaticField(typeData, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
            if (field.isRead() || field.isFolded()) {
                Object root = this.asObject(fieldTask.ensureDone());
                this.rescanCollectionElements(root);
                return root;
            }
        }
        return null;
    }

    public void rescanField(Object receiver, Field reflectionField) {
        if (this.skipScanning()) {
            return;
        }
        ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
        if (type.isReachable()) {
            JavaConstant fieldValue;
            AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
            assert (!field.isStatic());
            JavaConstant receiverConstant = this.asConstant(receiver);
            Optional<JavaConstant> replaced = this.maybeReplace(receiverConstant, ObjectScanner.OtherReason.RESCAN);
            if (replaced.isPresent()) {
                receiverConstant = replaced.get();
            }
            if ((fieldValue = this.readHostedFieldValue(field, this.universe.toHosted(receiverConstant)).get()) != null) {
                ImageHeapInstance receiverObject = (ImageHeapInstance)this.toImageHeapObject(receiverConstant);
                AnalysisFuture<JavaConstant> fieldTask = this.patchInstanceField(receiverObject, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
                if (field.isRead() || field.isFolded()) {
                    this.rescanCollectionElements(this.asObject(fieldTask.ensureDone()));
                }
            }
        }
    }

    protected AnalysisFuture<JavaConstant> patchStaticField(TypeData typeData, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, fieldValue, reason, onAnalysisModified);
            typeData.setFieldValue(field, value);
            return value;
        });
        typeData.setFieldTask(field, task);
        return task;
    }

    protected AnalysisFuture<JavaConstant> patchInstanceField(ImageHeapInstance receiverObject, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, receiverObject.getObject(), fieldValue, reason, onAnalysisModified);
            receiverObject.setFieldValue(field, value);
            return value;
        });
        receiverObject.setFieldTask(field, task);
        return task;
    }

    public void rescanObject(Object object) {
        this.rescanObject(object, ObjectScanner.OtherReason.RESCAN);
        this.rescanCollectionElements(object);
    }

    public void rescanObject(Object object, ObjectScanner.ScanReason reason) {
        if (this.skipScanning()) {
            return;
        }
        if (object == null) {
            return;
        }
        this.doScan(this.asConstant(object), reason);
    }

    private void rescanCollectionElements(Object object) {
        if (object instanceof Object[]) {
            Object[] array;
            for (Object element : array = (Object[])object) {
                this.doScan(this.asConstant(element));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.forEach(e -> this.doScan(this.asConstant(e)));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.forEach((k, v) -> {
                this.doScan(this.asConstant(k));
                this.doScan(this.asConstant(v));
            });
        } else if (object instanceof EconomicMap) {
            this.rescanEconomicMap((EconomicMap)object);
        }
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> object) {
        MapCursor cursor = object.getEntries();
        while (cursor.advance()) {
            this.doScan(this.asConstant(cursor.getKey()));
            this.doScan(this.asConstant(cursor.getValue()));
        }
    }

    void doScan(JavaConstant constant) {
        this.doScan(constant, ObjectScanner.OtherReason.RESCAN);
    }

    void doScan(JavaConstant constant, ObjectScanner.ScanReason reason) {
        if (this.isNonNullObjectConstant(constant)) {
            this.getOrCreateConstantReachableTask(constant, reason, null);
        }
    }

    protected AnalysisType analysisType(Object constant) {
        return this.metaAccess.lookupJavaType((Class)constant.getClass());
    }

    protected AnalysisType constantType(JavaConstant constant) {
        return this.metaAccess.lookupJavaType(constant);
    }

    protected Object asObject(JavaConstant constant) {
        return this.snippetReflection.asObject(Object.class, constant);
    }

    public JavaConstant asConstant(Object object) {
        return this.snippetReflection.forObject(object);
    }

    public void cleanupAfterAnalysis() {
        this.scanningObserver = null;
    }

    public ObjectScanningObserver getScanningObserver() {
        return this.scanningObserver;
    }

    protected abstract Class<?> getClass(String var1);

    protected AnalysisType lookupJavaType(String className) {
        return this.metaAccess.lookupJavaType((Class)this.getClass(className));
    }

    protected AnalysisField lookupJavaField(String className, String fieldName) {
        return this.metaAccess.lookupJavaField(ReflectionUtil.lookupField(this.getClass(className), (String)fieldName));
    }

    public void postTask(AnalysisFuture<?> future) {
        if (future.isDone()) {
            return;
        }
        ((PointsToAnalysis)this.universe.getBigbang()).postTask((DebugContext debug) -> future.ensureDone());
    }

    public void postTask(Runnable task) {
        ((PointsToAnalysis)this.universe.getBigbang()).postTask((DebugContext debug) -> task.run());
    }
}

