/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.thread.VMOperation;
import java.util.concurrent.atomic.AtomicReference;

public class AllocationFreeList<T extends Element<T>> {
    private final AtomicReference<Element<T>> head = new AtomicReference<Object>(null);

    protected AllocationFreeList() {
    }

    public static <U extends Element<U>> AllocationFreeList<U> factory() {
        return new AllocationFreeList();
    }

    public T getFirst() {
        Element candidate = this.sampleHead();
        while (candidate != null && !candidate.enabled) {
            candidate = candidate.next;
        }
        return (T)Element.asT(candidate);
    }

    public Object getFirstObject() {
        return this.head.get();
    }

    public void prepend(T element) {
        Element<T> headSample;
        T asElement = element;
        if (((Element)asElement).getHasBeenOnList()) {
            throw PreviouslyRegisteredElementException.getPreallocatedInstance();
        }
        ((Element)asElement).hasBeenOnList = true;
        ((Element)asElement).enabled = true;
        do {
            headSample = this.sampleHead();
            ((Element)asElement).next = (Element)headSample;
        } while (!this.head.compareAndSet(headSample, (Element<T>)asElement));
    }

    public void scrub() {
        VMOperation.guaranteeInProgressAtSafepoint("AllocationFreeList.scrub");
        Element headSample = this.sampleHead();
        if (headSample != null) {
            Element newHead = null;
            Element newTail = null;
            Element rest = null;
            Element current = headSample;
            while (current != null) {
                rest = current.next;
                current.next = null;
                if (current.enabled) {
                    if (newHead == null) {
                        newHead = current;
                    }
                    if (newTail != null) {
                        newTail.next = current;
                    }
                    newTail = current;
                }
                current = rest;
            }
            this.head.set(newHead);
        }
    }

    private Element<T> sampleHead() {
        return this.head.get();
    }

    public T testingBackDoorGetFirst() {
        return (T)Element.asT((Element)this.sampleHead());
    }

    public static class PreviouslyRegisteredElementException
    extends RuntimeException {
        private static PreviouslyRegisteredElementException preallocatedPreviouslyRegisteredElementException = new PreviouslyRegisteredElementException("Element was previously registered.");
        private static final long serialVersionUID = 2066230621024365993L;

        public static PreviouslyRegisteredElementException getPreallocatedInstance() {
            return preallocatedPreviouslyRegisteredElementException;
        }

        public PreviouslyRegisteredElementException(String message) {
            super(message);
        }
    }

    public static class Element<T extends Element<T>> {
        private Element<T> next;
        private boolean enabled;
        private boolean hasBeenOnList;

        protected Element() {
        }

        public T getNextElement() {
            Element<T> candidate = this.next;
            while (candidate != null && !candidate.enabled) {
                candidate = candidate.next;
            }
            return Element.asT(candidate);
        }

        public Object getNextObject() {
            return this.next;
        }

        public void removeElement() {
            this.enabled = false;
        }

        private static <T extends Element<T>> T asT(Element<T> element) {
            return (T)element;
        }

        public boolean getHasBeenOnList() {
            return this.hasBeenOnList;
        }

        public boolean testingBackDoorIsEnabled() {
            return this.enabled;
        }

        public T testingBackDoorGetNextElement() {
            return Element.asT(this.next);
        }
    }
}

