/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Locale;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.UnistdNoTransitions;
import com.oracle.svm.core.posix.headers.Wait;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.ArrayList;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class, InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class})
public class PosixUtils {
    static String setLocale(String category, String locale) {
        int intCategory = PosixUtils.getCategory(category);
        return PosixUtils.setLocale(intCategory, locale);
    }

    public static String setLocale(int category, String locale) {
        if (locale == null) {
            CCharPointer cstrResult = Locale.setlocale(category, (CCharPointer)WordFactory.nullPointer());
            return CTypeConversion.toJavaString((CCharPointer)cstrResult);
        }
        try (CTypeConversion.CCharPointerHolder localePin = CTypeConversion.toCString((CharSequence)locale);){
            CCharPointer cstrLocale = localePin.get();
            CCharPointer cstrResult = Locale.setlocale(category, cstrLocale);
            String string = CTypeConversion.toJavaString((CCharPointer)cstrResult);
            return string;
        }
    }

    private static int getCategory(String category) {
        switch (category) {
            case "LC_ALL": {
                return Locale.LC_ALL();
            }
            case "LC_COLLATE": {
                return Locale.LC_COLLATE();
            }
            case "LC_CTYPE": {
                return Locale.LC_CTYPE();
            }
            case "LC_MONETARY": {
                return Locale.LC_MONETARY();
            }
            case "LC_NUMERIC": {
                return Locale.LC_NUMERIC();
            }
            case "LC_TIME": {
                return Locale.LC_TIME();
            }
            case "LC_MESSAGES": {
                return Locale.LC_MESSAGES();
            }
        }
        if (Platform.includedIn(DeprecatedPlatform.LINUX_SUBSTITUTION.class)) {
            switch (category) {
                case "LC_PAPER": {
                    return Locale.LC_PAPER();
                }
                case "LC_NAME": {
                    return Locale.LC_NAME();
                }
                case "LC_ADDRESS": {
                    return Locale.LC_ADDRESS();
                }
                case "LC_TELEPHONE": {
                    return Locale.LC_TELEPHONE();
                }
                case "LC_MEASUREMENT": {
                    return Locale.LC_MEASUREMENT();
                }
                case "LC_IDENTIFICATION": {
                    return Locale.LC_IDENTIFICATION();
                }
            }
        }
        throw VMError.shouldNotReachHere("Unknown locale category: " + category);
    }

    static String removeTrailingSlashes(String path) {
        int p;
        for (p = path.length() - 1; p > 0 && path.charAt(p) == '/'; --p) {
        }
        return p > 0 ? path.substring(0, p + 1) : path;
    }

    public static int getFD(FileDescriptor descriptor) {
        return Util_java_io_FileDescriptor.toTarget((FileDescriptor)descriptor).fd;
    }

    static void setFD(FileDescriptor descriptor, int fd) {
        Util_java_io_FileDescriptor.toTarget((FileDescriptor)descriptor).fd = fd;
    }

    public static String lastErrorString(String defaultMsg) {
        int errno = Errno.errno();
        return PosixUtils.errorString(errno, defaultMsg);
    }

    public static IOException newIOExceptionWithLastError(String defaultMsg) {
        return new IOException(PosixUtils.lastErrorString(defaultMsg));
    }

    public static String errorString(int errno, String defaultMsg) {
        String result = "";
        if (errno != 0) {
            result = CTypeConversion.toJavaString((CCharPointer)Errno.strerror(errno));
        }
        return result.length() != 0 ? result : defaultMsg;
    }

    static void fileOpen(String path, FileDescriptor fd, int flags) throws FileNotFoundException {
        block13: {
            try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)PosixUtils.removeTrailingSlashes(path));){
                CCharPointer pathPtr = pathPin.get();
                int handle = Fcntl.open(pathPtr, flags, 438);
                if (handle >= 0) {
                    PosixUtils.setFD(fd, handle);
                    break block13;
                }
                throw new FileNotFoundException(path);
            }
        }
    }

    static void fileClose(FileDescriptor fd) throws IOException {
        int handle = PosixUtils.getFD(fd);
        if (handle == -1) {
            return;
        }
        PosixUtils.setFD(fd, -1);
        if (handle >= 0 && handle <= 2) {
            int devnull;
            try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)"/dev/null");){
                CCharPointer pathPtr = pathPin.get();
                devnull = Fcntl.open(pathPtr, Fcntl.O_WRONLY(), 0);
            }
            if (devnull < 0) {
                PosixUtils.setFD(fd, handle);
                throw PosixUtils.newIOExceptionWithLastError("open /dev/null failed");
            }
            Unistd.dup2(devnull, handle);
            Unistd.close(devnull);
        } else if (Unistd.close(handle) == -1) {
            throw PosixUtils.newIOExceptionWithLastError("close failed");
        }
    }

    public static int getpid() {
        return Unistd.getpid();
    }

    public static int getpid(Process process) {
        Target_java_lang_UNIXProcess instance = SubstrateUtil.cast(process, Target_java_lang_UNIXProcess.class);
        return instance.pid;
    }

    public static int waitForProcessExit(int ppid) {
        int status;
        CIntPointer statusptr = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Wait.waitpid(ppid, statusptr, 0) < 0) {
            if (Errno.errno() == Errno.ECHILD()) {
                return 0;
            }
            if (Errno.errno() != Errno.EINTR()) {
                return -1;
            }
        }
        if (Wait.WIFEXITED(status = statusptr.read())) {
            return Wait.WEXITSTATUS(status);
        }
        if (Wait.WIFSIGNALED(status)) {
            return 128 + Wait.WTERMSIG(status);
        }
        return status;
    }

    static int readSingle(FileDescriptor fd) throws IOException {
        CCharPointer retPtr = (CCharPointer)StackValue.get(CCharPointer.class);
        int handle = PosixUtils.getFDHandle(fd);
        SignedWord nread = Unistd.read(handle, (PointerBase)retPtr, WordFactory.unsigned((int)1));
        if (nread.equal(0)) {
            return -1;
        }
        if (nread.equal(-1)) {
            throw PosixUtils.newIOExceptionWithLastError("Read error");
        }
        return retPtr.read() & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readBytes(byte[] b, int off, int len, FileDescriptor fd) throws IOException {
        SignedWord nread;
        block21: {
            if (b == null) {
                throw new NullPointerException();
            }
            if (PosixUtils.outOfBounds(off, len, b)) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            CCharPointer buf = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)len));
            try {
                if (buf.equal((ComparableWord)WordFactory.zero())) {
                    throw new OutOfMemoryError();
                }
                int handle = PosixUtils.getFDHandle(fd);
                nread = Unistd.read(handle, (PointerBase)buf, WordFactory.unsigned((int)len));
                if (nread.greaterThan(0)) {
                    try (PinnedObject pin = PinnedObject.create((Object)b);){
                        LibC.memcpy(pin.addressOfArrayElement(off), (PointerBase)buf, (UnsignedWord)nread);
                        break block21;
                    }
                }
                if (nread.equal(-1)) {
                    throw PosixUtils.newIOExceptionWithLastError("Read error");
                }
                nread = WordFactory.signed((int)-1);
            }
            finally {
                LibC.free((PointerBase)buf);
            }
        }
        return (int)nread.rawValue();
    }

    static void writeSingle(FileDescriptor fd, int b, boolean append) throws IOException {
        int handle = PosixUtils.getFD(fd);
        if (handle == -1) {
            throw new IOException("Stream Closed");
        }
        CCharPointer bufPtr = (CCharPointer)StackValue.get(CCharPointer.class);
        bufPtr.write((byte)b);
        SignedWord n = Unistd.write(handle, (PointerBase)bufPtr, WordFactory.unsigned((int)1));
        if (n.equal(-1)) {
            throw PosixUtils.newIOExceptionWithLastError("Write error");
        }
    }

    static void writeBytes(FileDescriptor descriptor, byte[] bytes, int off, int len, boolean append) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (PosixUtils.outOfBounds(off, len, bytes)) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try (PinnedObject bytesPin = PinnedObject.create((Object)bytes);){
            CCharPointer curBuf = (CCharPointer)bytesPin.addressOfArrayElement(off);
            UnsignedWord curLen = WordFactory.unsigned((int)len);
            while (curLen.notEqual(0)) {
                int fd = PosixUtils.getFD(descriptor);
                if (fd == -1) {
                    throw new IOException("Stream Closed");
                }
                SignedWord n = Unistd.write(fd, (PointerBase)curBuf, curLen);
                if (n.equal(-1)) {
                    throw PosixUtils.newIOExceptionWithLastError("Write error");
                }
                curBuf = curBuf.addressOf(n);
                curLen = curLen.subtract((UnsignedWord)n);
            }
        }
    }

    public static boolean writeBytes(FileDescriptor descriptor, CCharPointer bytes, UnsignedWord length) {
        CCharPointer curBuf = bytes;
        UnsignedWord curLen = length;
        while (curLen.notEqual(0)) {
            int fd = PosixUtils.getFD(descriptor);
            if (fd == -1) {
                return false;
            }
            SignedWord n = Unistd.write(fd, (PointerBase)curBuf, curLen);
            if (n.equal(-1)) {
                return false;
            }
            curBuf = curBuf.addressOf(n);
            curLen = curLen.subtract((UnsignedWord)n);
        }
        return true;
    }

    static boolean flush(FileDescriptor descriptor) {
        int fd = PosixUtils.getFD(descriptor);
        return Unistd.fsync(fd) == 0;
    }

    static int getFDHandle(FileDescriptor fd) throws IOException {
        int handle = PosixUtils.getFD(fd);
        if (handle == -1) {
            throw new IOException("Stream Closed");
        }
        return handle;
    }

    static boolean outOfBounds(int off, int len, byte[] array) {
        return off < 0 || len < 0 || array.length - off < len;
    }

    static String collapse(String path) {
        int next;
        boolean absolute = path.charAt(0) == '/';
        String wpath = absolute ? path.substring(1) : path;
        ArrayList<String> parts = new ArrayList<String>();
        int pos = 0;
        do {
            String part;
            String string = part = (next = wpath.indexOf(47, pos)) != -1 ? wpath.substring(pos, next) : wpath.substring(pos);
            if (part.length() > 0 && !part.equals(".")) {
                if (part.equals("..")) {
                    parts.remove(parts.size() - 1);
                } else {
                    parts.add(part);
                }
            }
            pos = next + 1;
        } while (next != -1);
        StringBuilder rpath = new StringBuilder(absolute ? "/" : "");
        for (String part : parts) {
            rpath.append(part).append('/');
        }
        rpath.deleteCharAt(rpath.length() - 1);
        return rpath.toString();
    }

    public static PointerBase dlopen(String file, int mode) {
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)file);){
            CCharPointer pathPtr = pathPin.get();
            PointerBase pointerBase = Dlfcn.dlopen(pathPtr, mode);
            return pointerBase;
        }
    }

    public static <T extends PointerBase> T dlsym(PointerBase handle, String name) {
        try (CTypeConversion.CCharPointerHolder namePin = CTypeConversion.toCString((CharSequence)name);){
            CCharPointer namePtr = namePin.get();
            Object t = Dlfcn.dlsym(handle, namePtr);
            return t;
        }
    }

    public static String dlerror() {
        return CTypeConversion.toJavaString((CCharPointer)Dlfcn.dlerror());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void checkStatusIs0(int status, String message) {
        VMError.guarantee(status == 0, message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean readEntirely(int fd, CCharPointer buffer, int bufferLen) {
        int readBytes;
        int bufferOffset = 0;
        do {
            if ((readBytes = PosixUtils.readBytes(fd, buffer, bufferLen - 1, bufferOffset)) < 0) {
                return false;
            }
            bufferOffset += readBytes;
        } while (readBytes != 0);
        buffer.write(bufferOffset, (byte)0);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readBytes(int fd, CCharPointer buffer, int bufferLen, int readOffset) {
        int readBytes = -1;
        if (readOffset < bufferLen) {
            while ((readBytes = (int)UnistdNoTransitions.read(fd, (PointerBase)buffer.addressOf(readOffset), WordFactory.unsigned((int)(bufferLen - readOffset))).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
        }
        return readBytes;
    }

    static final class Util_java_io_FileDescriptor {
        Util_java_io_FileDescriptor() {
        }

        @SuppressFBWarnings(value={"BC"}, justification="Cast from @TargetClass")
        static FileDescriptor fromTarget(Target_java_io_FileDescriptor tjifd) {
            return (FileDescriptor)FileDescriptor.class.cast(tjifd);
        }

        @SuppressFBWarnings(value={"BC"}, justification="Cast to @TargetClass")
        static Target_java_io_FileDescriptor toTarget(FileDescriptor jifd) {
            return (Target_java_io_FileDescriptor)Target_java_io_FileDescriptor.class.cast(jifd);
        }
    }

    @TargetClass(value=FileDescriptor.class)
    private static final class Target_java_io_FileDescriptor {
        @Alias
        int fd;

        private Target_java_io_FileDescriptor() {
        }

        @Substitute
        public void sync() throws SyncFailedException {
            if (Unistd.fsync(this.fd) == -1) {
                throw new SyncFailedException("sync failed");
            }
        }

        @Substitute
        @TargetElement(onlyWith={JDK11OrLater.class})
        private static boolean getAppend(int fd) {
            int flags = Fcntl.fcntl(fd, Fcntl.F_GETFL());
            return (flags & Fcntl.O_APPEND()) != 0;
        }

        @Substitute
        @TargetElement(onlyWith={JDK11OrLater.class})
        private void close0() throws IOException {
            PosixUtils.fileClose(Util_java_io_FileDescriptor.fromTarget(this));
        }
    }
}

