/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.JavaUtilZipSubstitutions;
import com.oracle.svm.core.posix.Util_java_util_zip_Deflater;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.ZLib;
import java.util.zip.Deflater;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=Deflater.class)
final class Target_java_util_zip_Deflater {
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private byte[] buf;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int off;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int len;
    @Alias
    private int level;
    @Alias
    private int strategy;
    @Alias
    private boolean setParams;
    @Alias
    private boolean finish;
    @Alias
    private boolean finished;

    Target_java_util_zip_Deflater() {
    }

    @Substitute
    private static long init(int level, int strategy, boolean nowrap) {
        ZLib.z_stream strm = (ZLib.z_stream)LibC.calloc(WordFactory.unsigned((int)1), SizeOf.unsigned(ZLib.z_stream.class));
        if (strm.isNull()) {
            throw new OutOfMemoryError();
        }
        int ret = ZLib.deflateInit2(strm, level, ZLib.Z_DEFLATED(), nowrap ? -ZLib.MAX_WBITS() : ZLib.MAX_WBITS(), JavaUtilZipSubstitutions.Util_java_util_zip_Deflater.DEF_MEM_LEVEL, strategy);
        if (ret == ZLib.Z_OK()) {
            return strm.rawValue();
        }
        LibC.free(strm);
        if (ret == ZLib.Z_MEM_ERROR()) {
            throw new OutOfMemoryError();
        }
        if (ret == ZLib.Z_STREAM_ERROR()) {
            throw new IllegalArgumentException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
        throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
    }

    @Substitute
    private static void setDictionary(long addr, byte[] b, int off, int len) {
        try (PinnedObject pinned = PinnedObject.create((Object)b);){
            JavaUtilZipSubstitutions.Util_java_util_zip_Deflater.doSetDictionary(addr, (CCharPointer)pinned.addressOfArrayElement(off), len);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private int deflateBytes(long addr, byte[] b, int off, int len, int flush) {
        strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        pinnedInBuf = PinnedObject.create((Object)this.buf);
        var9_8 = null;
        try {
            block61: {
                block62: {
                    block63: {
                        block58: {
                            block59: {
                                block60: {
                                    block55: {
                                        block56: {
                                            block57: {
                                                block52: {
                                                    block53: {
                                                        block54: {
                                                            block49: {
                                                                block50: {
                                                                    block51: {
                                                                        pinnedOutBuf = PinnedObject.create((Object)b);
                                                                        var11_11 = null;
                                                                        strm.set_next_in((CCharPointer)pinnedInBuf.addressOfArrayElement(this.off));
                                                                        strm.set_next_out((CCharPointer)pinnedOutBuf.addressOfArrayElement(off));
                                                                        strm.set_avail_in(this.len);
                                                                        strm.set_avail_out(len);
                                                                        if (!this.setParams) ** GOTO lbl48
                                                                        res = ZLib.deflateParams(strm, this.level, this.strategy);
                                                                        this.setParams = false;
                                                                        if (res != ZLib.Z_OK()) break block49;
                                                                        var13_14 = Util_java_util_zip_Deflater.update(this, len, strm);
                                                                        if (pinnedOutBuf == null) break block50;
                                                                        if (var11_11 == null) break block51;
                                                                        try {
                                                                            pinnedOutBuf.close();
                                                                        }
                                                                        catch (Throwable var14_19) {
                                                                            var11_11.addSuppressed(var14_19);
                                                                        }
                                                                        break block50;
                                                                    }
                                                                    pinnedOutBuf.close();
                                                                }
                                                                return var13_14;
                                                            }
                                                            if (res != ZLib.Z_BUF_ERROR()) break block52;
                                                            var13_15 = 0;
                                                            if (pinnedOutBuf == null) break block53;
                                                            if (var11_11 == null) break block54;
                                                            try {
                                                                pinnedOutBuf.close();
                                                            }
                                                            catch (Throwable var14_21) {
                                                                var11_11.addSuppressed(var14_21);
                                                            }
                                                            break block53;
                                                        }
                                                        pinnedOutBuf.close();
                                                    }
                                                    return var13_15;
                                                }
                                                throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
lbl48:
                                                // 1 sources

                                                res = ZLib.deflate(strm, this.finish != false ? ZLib.Z_FINISH() : flush);
                                                if (res != ZLib.Z_STREAM_END()) break block55;
                                                this.finished = true;
                                                var13_16 = Util_java_util_zip_Deflater.update(this, len, strm);
                                                if (pinnedOutBuf == null) break block56;
                                                if (var11_11 == null) break block57;
                                                try {
                                                    pinnedOutBuf.close();
                                                }
                                                catch (Throwable var14_23) {
                                                    var11_11.addSuppressed(var14_23);
                                                }
                                                break block56;
                                            }
                                            pinnedOutBuf.close();
                                        }
                                        return var13_16;
                                    }
                                    if (res != ZLib.Z_OK()) break block58;
                                    var13_17 = Util_java_util_zip_Deflater.update(this, len, strm);
                                    if (pinnedOutBuf == null) break block59;
                                    if (var11_11 == null) break block60;
                                    try {
                                        pinnedOutBuf.close();
                                    }
                                    catch (Throwable var14_25) {
                                        var11_11.addSuppressed(var14_25);
                                    }
                                    break block59;
                                }
                                pinnedOutBuf.close();
                            }
                            return var13_17;
                        }
                        if (res != ZLib.Z_BUF_ERROR()) break block61;
                        var13_18 = 0;
                        if (pinnedOutBuf == null) break block62;
                        if (var11_11 == null) break block63;
                        try {
                            pinnedOutBuf.close();
                        }
                        catch (Throwable var14_27) {
                            var11_11.addSuppressed(var14_27);
                        }
                        break block62;
                    }
                    pinnedOutBuf.close();
                }
                return var13_18;
            }
            try {
                try {
                    try {
                        throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
                    }
                    catch (Throwable var12_13) {
                        var11_11 = var12_13;
                        throw var12_13;
                    }
                }
                catch (Throwable var15_29) {
                    if (pinnedOutBuf != null) {
                        if (var11_11 != null) {
                            try {
                                pinnedOutBuf.close();
                            }
                            catch (Throwable var16_30) {
                                var11_11.addSuppressed(var16_30);
                            }
                        } else {
                            pinnedOutBuf.close();
                        }
                    }
                    throw var15_29;
                }
            }
            catch (Throwable var10_10) {
                var9_8 = var10_10;
                throw var10_10;
            }
        }
        finally {
            if (pinnedInBuf != null) {
                if (var9_8 != null) {
                    try {
                        pinnedInBuf.close();
                    }
                    catch (Throwable var14_20) {
                        var9_8.addSuppressed(var14_20);
                    }
                } else {
                    pinnedInBuf.close();
                }
            }
        }
    }

    @Substitute
    private static int getAdler(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        return (int)strm.adler().rawValue();
    }

    @Substitute
    private static void reset(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        if (ZLib.deflateReset(strm) != ZLib.Z_OK()) {
            throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
    }

    @Substitute
    private static void end(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        if (ZLib.deflateEnd(strm) == ZLib.Z_STREAM_ERROR()) {
            throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
        LibC.free(strm);
    }
}

